/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.genericformat;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.model.ProgramDataModel;
import fr.ifremer.tutti.service.genericformat.GenericFormatValidateFileResult;
import fr.ifremer.tutti.ui.swing.content.genericformat.GenericFormatImportUI;
import fr.ifremer.tutti.ui.swing.content.genericformat.GenericFormatImportUIModel;
import fr.ifremer.tutti.ui.swing.content.genericformat.tree.DataSelectTreeModel;
import fr.ifremer.tutti.ui.swing.content.genericformat.tree.ProgramSelectTreeNode;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultTreeModel;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.application.swing.ApplicationUI;
import org.nuiton.jaxx.application.swing.util.CloseableUI;

public class GenericFormatImportUIHandler
extends AbstractTuttiUIHandler<GenericFormatImportUIModel, GenericFormatImportUI>
implements CloseableUI {
    private static final Log log = LogFactory.getLog(GenericFormatImportUIHandler.class);

    public void beforeInit(GenericFormatImportUI ui) {
        super.beforeInit((ApplicationUI)ui);
        this.getDataContext().resetValidationDataContext();
        GenericFormatImportUIModel model = new GenericFormatImportUIModel();
        if (this.getContext().isProgramFilled()) {
            String programId = this.getContext().getProgramId();
            if (log.isInfoEnabled()) {
                log.info((Object)("Using selected program " + programId));
            }
            Program program = this.getPersistenceService().getProgram(programId);
            model.setProgram(program);
        }
        ui.setContextValue(model);
        model.addPropertyChangeListener(new PropertyChangeListener(){
            final Set<String> propertyNamesToCanValidate = Sets.newHashSet((Object[])new String[]{"importFile", "program"});
            final Set<String> propertyNamesToCanImport = Sets.newHashSet((Object[])new String[]{"validateDone", "program", "validateResult", "dataSelected"});

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                GenericFormatImportUIModel source = (GenericFormatImportUIModel)((Object)evt.getSource());
                String propertyName = evt.getPropertyName();
                if (this.propertyNamesToCanValidate.contains(propertyName)) {
                    boolean canValidate = source.computeIsCanValidate();
                    source.setCanValidate(canValidate);
                    source.setValidateResult(null);
                    source.setValidateReportFile(null);
                }
                if (this.propertyNamesToCanImport.contains(propertyName)) {
                    boolean canImport = source.computeIsCanImport();
                    source.setCanImport(canImport);
                    source.setImportResult(null);
                    source.setImportReportFile(null);
                }
                if ("canValidate".equals(propertyName) && !((Boolean)evt.getNewValue()).booleanValue()) {
                    ((GenericFormatImportUI)GenericFormatImportUIHandler.this.getUI()).getValidateResultPanel().setVisible(false);
                }
                if ("canImport".equals(propertyName) && !((Boolean)evt.getNewValue()).booleanValue()) {
                    ((GenericFormatImportUI)GenericFormatImportUIHandler.this.getUI()).getImportResultPanel().setVisible(false);
                }
                if ("validateResult".equals(propertyName)) {
                    GenericFormatImportUIHandler.this.onValidateResultChanged((GenericFormatValidateFileResult)evt.getNewValue());
                }
            }
        });
    }

    public void afterInit(GenericFormatImportUI ui) {
        this.initUI(ui);
        JTree tree = ui.getDataSelectionTree();
        tree.getSelectionModel().setSelectionMode(1);
        ToolTipManager.sharedInstance().registerComponent(tree);
        DataSelectTreeModel.installDataSelectionHandler(tree);
        DataSelectTreeModel treeModel = ui.getTreeModel();
        treeModel.addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                DataSelectTreeModel source = (DataSelectTreeModel)e.getSource();
                boolean dataSelected = source.isDataSelected();
                ((GenericFormatImportUIModel)((Object)GenericFormatImportUIHandler.this.getModel())).setDataSelected(dataSelected);
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                DataSelectTreeModel source = (DataSelectTreeModel)e.getSource();
                boolean dataSelected = source.isDataSelected();
                ((GenericFormatImportUIModel)((Object)GenericFormatImportUIHandler.this.getModel())).setDataSelected(dataSelected);
            }
        });
        GenericFormatImportUIModel model = (GenericFormatImportUIModel)((Object)this.getModel());
        this.initBeanFilterableComboBox(ui.getProgramComboBox(), Lists.newArrayList((Iterable)this.getPersistenceService().getAllProgram()), model.getProgram());
        SwingValidator<GenericFormatImportUIModel> validator = ui.getValidator();
        this.registerValidators(validator);
    }

    protected JComponent getComponentToFocus() {
        return ((GenericFormatImportUI)this.getUI()).getProgramComboBox();
    }

    public void onCloseUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("closing: " + this.ui));
        }
        this.clearValidators();
    }

    public boolean quitUI() {
        return true;
    }

    public SwingValidator<GenericFormatImportUIModel> getValidator() {
        return ((GenericFormatImportUI)this.ui).getValidator();
    }

    private void onValidateResultChanged(GenericFormatValidateFileResult validateFileResult) {
        ProgramSelectTreeNode root;
        if (validateFileResult == null) {
            root = null;
        } else {
            ProgramDataModel dataModel = validateFileResult.getDataModel();
            root = new ProgramSelectTreeNode(dataModel);
        }
        DefaultTreeModel treeModel = (DefaultTreeModel)((GenericFormatImportUI)this.ui).getDataSelectionTree().getModel();
        treeModel.setRoot(root);
        ((GenericFormatImportUIModel)((Object)this.getModel())).setRootNode(root);
    }
}

