/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import fr.ifremer.adagio.core.dao.referential.ObjectTypeCode;
import fr.ifremer.tutti.TuttiConfiguration;
import fr.ifremer.tutti.persistence.InvalidBatchModelException;
import fr.ifremer.tutti.persistence.TuttiPersistence;
import fr.ifremer.tutti.persistence.TuttiPersistenceServiceImplementor;
import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.data.AccidentalBatch;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatch;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatchFrequency;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.Cruises;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.FishingOperations;
import fr.ifremer.tutti.persistence.entities.data.IndividualObservationBatch;
import fr.ifremer.tutti.persistence.entities.data.MarineLitterBatch;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.data.SpeciesAbleBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequency;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocols;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.ObjectType;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.entities.referential.TuttiLocation;
import fr.ifremer.tutti.persistence.entities.referential.TuttiReferentialEntity;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.persistence.model.CruiseDataModel;
import fr.ifremer.tutti.persistence.model.OperationDataModel;
import fr.ifremer.tutti.persistence.model.ProgramDataModel;
import fr.ifremer.tutti.persistence.service.AccidentalBatchPersistenceService;
import fr.ifremer.tutti.persistence.service.AttachmentPersistenceService;
import fr.ifremer.tutti.persistence.service.BenthosBatchPersistenceService;
import fr.ifremer.tutti.persistence.service.CatchBatchPersistenceService;
import fr.ifremer.tutti.persistence.service.CruisePersistenceService;
import fr.ifremer.tutti.persistence.service.FishingOperationPersistenceService;
import fr.ifremer.tutti.persistence.service.IndividualObservationBatchPersistenceService;
import fr.ifremer.tutti.persistence.service.MarineLitterBatchPersistenceService;
import fr.ifremer.tutti.persistence.service.ProgramPersistenceService;
import fr.ifremer.tutti.persistence.service.ProtocolPersistenceService;
import fr.ifremer.tutti.persistence.service.SpeciesBatchPersistenceService;
import fr.ifremer.tutti.persistence.service.TechnicalPersistenceService;
import fr.ifremer.tutti.persistence.service.TuttiPersistenceServiceLocator;
import fr.ifremer.tutti.persistence.service.UpdateSchemaContextSupport;
import fr.ifremer.tutti.persistence.service.referential.CaracteristicPersistenceService;
import fr.ifremer.tutti.persistence.service.referential.GearPersistenceService;
import fr.ifremer.tutti.persistence.service.referential.LocationPersistenceService;
import fr.ifremer.tutti.persistence.service.referential.ObjectTypePersistenceService;
import fr.ifremer.tutti.persistence.service.referential.PersonPersistenceService;
import fr.ifremer.tutti.persistence.service.referential.SpeciesPersistenceService;
import fr.ifremer.tutti.persistence.service.referential.VesselPersistenceService;
import fr.ifremer.tutti.util.Jdbcs;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.version.Version;

public class TuttiPersistenceImpl
implements TuttiPersistence {
    private static final Log log = LogFactory.getLog(TuttiPersistenceImpl.class);
    @Resource(name="caracteristicPersistenceService")
    protected CaracteristicPersistenceService caracteristicService;
    @Resource(name="gearPersistenceService")
    protected GearPersistenceService gearService;
    @Resource(name="locationPersistenceService")
    protected LocationPersistenceService locationService;
    @Resource(name="objectTypePersistenceService")
    protected ObjectTypePersistenceService objectTypeService;
    @Resource(name="personPersistenceService")
    protected PersonPersistenceService personService;
    @Resource(name="speciesPersistenceService")
    protected SpeciesPersistenceService speciesService;
    @Resource(name="vesselPersistenceService")
    protected VesselPersistenceService vesselService;
    @Resource(name="programPersistenceService")
    protected ProgramPersistenceService programService;
    @Resource(name="cruisePersistenceService")
    protected CruisePersistenceService cruiseService;
    @Resource(name="fishingOperationPersistenceService")
    protected FishingOperationPersistenceService fishingOperationService;
    @Resource(name="batchPersistenceService")
    protected CatchBatchPersistenceService catchBatchService;
    @Resource(name="speciesBatchPersistenceService")
    protected SpeciesBatchPersistenceService speciesBatchService;
    @Resource(name="benthosBatchPersistenceService")
    protected BenthosBatchPersistenceService benthosBatchService;
    @Resource(name="marineLitterBatchPersistenceService")
    protected MarineLitterBatchPersistenceService marineLitterBatchService;
    @Resource(name="accidentalBatchPersistenceService")
    protected AccidentalBatchPersistenceService accidentalBatchService;
    @Resource(name="individualObservationBatchPersistenceService")
    protected IndividualObservationBatchPersistenceService individualObservationBatchService;
    @Resource(name="protocolPersistenceService")
    protected ProtocolPersistenceService protocolService;
    @Resource(name="attachmentPersistenceService")
    protected AttachmentPersistenceService attachmentService;
    @Resource(name="technicalPersistenceService")
    protected TechnicalPersistenceService technicalPersistenceService;
    private boolean skipShutdownDbWhenClosing;
    protected boolean close;

    @Override
    public String getImplementationName() {
        return "Persistence Adagio implementation";
    }

    @Override
    public void setSkipShutdownDbWhenClosing() {
        this.skipShutdownDbWhenClosing = true;
    }

    @Override
    public void lazyInit() {
    }

    @Override
    public void clearAllCaches() {
        this.getTechnicalPersistenceService().clearAllCaches();
    }

    @Override
    public <V> V invoke(Callable<V> call) {
        return this.getTechnicalPersistenceService().invoke(call);
    }

    @Override
    public <U extends UpdateSchemaContextSupport> void prepareUpdateSchemaContext(U context) {
        this.getTechnicalPersistenceService().prepareUpdateSchemaContext(context);
    }

    @Override
    public Version getSchemaVersion() {
        return this.getTechnicalPersistenceService().getSchemaVersion();
    }

    @Override
    public Version getSchemaVersionIfUpdate() {
        return this.getTechnicalPersistenceService().getSchemaVersionIfUpdate();
    }

    @Override
    public void updateSchema() {
        this.getTechnicalPersistenceService().updateSchema();
    }

    @Override
    public void sanityDb() {
        this.getTechnicalPersistenceService().sanityDb();
    }

    @Override
    public boolean isTemporary(TuttiReferentialEntity entity) {
        return this.getTechnicalPersistenceService().isTemporary(entity);
    }

    @Override
    public void init() {
        if (log.isInfoEnabled()) {
            log.info((Object)("Open persistence driver " + this.getImplementationName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (!this.close) {
            this.close = true;
            TuttiPersistenceImpl tuttiPersistenceImpl = this;
            synchronized (tuttiPersistenceImpl) {
                block11: {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Close persistence driver " + this.getImplementationName()));
                    }
                    this.caracteristicService.close();
                    this.gearService.close();
                    this.locationService.close();
                    this.objectTypeService.close();
                    this.personService.close();
                    this.speciesService.close();
                    this.vesselService.close();
                    this.programService.close();
                    this.cruiseService.close();
                    this.fishingOperationService.close();
                    this.catchBatchService.close();
                    this.speciesBatchService.close();
                    this.benthosBatchService.close();
                    this.marineLitterBatchService.close();
                    this.accidentalBatchService.close();
                    this.individualObservationBatchService.close();
                    this.protocolService.close();
                    this.attachmentService.close();
                    if (this.skipShutdownDbWhenClosing) {
                        if (log.isInfoEnabled()) {
                            log.info((Object)"Skip to shutdown db while closing, lucky you...");
                        }
                    } else {
                        if (log.isInfoEnabled()) {
                            log.info((Object)"Do shutdown db nicely");
                        }
                        try {
                            Jdbcs.shutdown(TuttiConfiguration.getInstance());
                        }
                        catch (SQLException e) {
                            if (!log.isErrorEnabled()) break block11;
                            log.error((Object)"Could not shutdown the database", (Throwable)e);
                        }
                    }
                }
                TuttiPersistenceServiceLocator.shutdownTutti();
            }
        }
    }

    @Override
    public ProgramDataModel loadProgram(String programId, boolean loadFishingOperation) {
        Program program = this.getProgram(programId);
        LinkedHashSet<CruiseDataModel> cruiseModels = new LinkedHashSet<CruiseDataModel>();
        ArrayList<Cruise> cruises = new ArrayList<Cruise>(this.getAllCruise(programId));
        Cruises.sort(cruises);
        for (Cruise cruise : cruises) {
            List<String> fishingOperationIds = loadFishingOperation ? this.getAllFishingOperationIds(cruise.getId()) : Collections.emptyList();
            CruiseDataModel model = this.loadCruise(cruise, fishingOperationIds);
            cruiseModels.add(model);
        }
        ProgramDataModel result = new ProgramDataModel(program, cruiseModels);
        return result;
    }

    @Override
    public ProgramDataModel loadCruises(String programId, boolean loadFishingOperation, String ... cruiseIds) {
        Program program = this.getProgram(programId);
        LinkedHashSet<CruiseDataModel> cruiseModels = new LinkedHashSet<CruiseDataModel>();
        for (String cruiseId : cruiseIds) {
            Cruise cruise = this.getCruise(cruiseId);
            List<String> fishingOperationIds = loadFishingOperation ? this.getAllFishingOperationIds(cruise.getId()) : Collections.emptyList();
            CruiseDataModel model = this.loadCruise(cruise, fishingOperationIds);
            cruiseModels.add(model);
        }
        ProgramDataModel result = new ProgramDataModel(program, cruiseModels);
        return result;
    }

    @Override
    public ProgramDataModel loadCruise(String programId, String cruiseId, String ... fishingOperationIds) {
        Program program = this.getProgram(programId);
        LinkedHashSet<CruiseDataModel> cruiseModels = new LinkedHashSet<CruiseDataModel>();
        Cruise cruise = this.getCruise(cruiseId);
        CruiseDataModel model = this.loadCruise(cruise, Arrays.asList(fishingOperationIds));
        cruiseModels.add(model);
        ProgramDataModel result = new ProgramDataModel(program, cruiseModels);
        return result;
    }

    protected CruiseDataModel loadCruise(Cruise cruise, List<String> fishingOperationIds) {
        LinkedHashSet<OperationDataModel> fishingOperationModels = new LinkedHashSet<OperationDataModel>();
        ArrayList<FishingOperation> fishingOperations = new ArrayList<FishingOperation>(this.getAllFishingOperation(cruise.getId()));
        FishingOperations.sort(fishingOperations);
        for (FishingOperation fishingOperation : fishingOperations) {
            if (!fishingOperationIds.contains(fishingOperation.getId())) continue;
            OperationDataModel model = new OperationDataModel(fishingOperation);
            fishingOperationModels.add(model);
        }
        CruiseDataModel result = new CruiseDataModel(cruise, fishingOperationModels);
        return result;
    }

    @Override
    public List<Caracteristic> getAllCaracteristic() {
        return this.getCaracteristicService().getAllCaracteristic();
    }

    @Override
    public List<Caracteristic> getAllCaracteristicWithProtected() {
        return this.getCaracteristicService().getAllCaracteristicWithProtected();
    }

    @Override
    public List<Caracteristic> getAllCaracteristicForSampleCategory() {
        return this.getCaracteristicService().getAllCaracteristicForSampleCategory();
    }

    @Override
    public List<Caracteristic> getAllNumericCaracteristic() {
        return this.getCaracteristicService().getAllNumericCaracteristic();
    }

    @Override
    public Caracteristic getSizeCategoryCaracteristic() {
        return this.getCaracteristicService().getSizeCategoryCaracteristic();
    }

    @Override
    public Caracteristic getSexCaracteristic() {
        return this.getCaracteristicService().getSexCaracteristic();
    }

    @Override
    public Caracteristic getSortedUnsortedCaracteristic() {
        return this.getCaracteristicService().getSortedUnsortedCaracteristic();
    }

    @Override
    public Caracteristic getMaturityCaracteristic() {
        return this.getCaracteristicService().getMaturityCaracteristic();
    }

    @Override
    public Caracteristic getAgeCaracteristic() {
        return this.getCaracteristicService().getAgeCaracteristic();
    }

    @Override
    public Caracteristic getMarineLitterCategoryCaracteristic() {
        return this.getCaracteristicService().getMarineLitterCategoryCaracteristic();
    }

    @Override
    public Caracteristic getMarineLitterSizeCategoryCaracteristic() {
        return this.getCaracteristicService().getMarineLitterSizeCategoryCaracteristic();
    }

    @Override
    public Caracteristic getVerticalOpeningCaracteristic() {
        return this.getCaracteristicService().getVerticalOpeningCaracteristic();
    }

    @Override
    public Caracteristic getHorizontalOpeningWingsCaracteristic() {
        return this.getCaracteristicService().getHorizontalOpeningWingsCaracteristic();
    }

    @Override
    public Caracteristic getHorizontalOpeningDoorCaracteristic() {
        return this.getCaracteristicService().getHorizontalOpeningDoorCaracteristic();
    }

    @Override
    public Caracteristic getDeadOrAliveCaracteristic() {
        return this.getCaracteristicService().getDeadOrAliveCaracteristic();
    }

    @Override
    public Caracteristic getPmfmIdCaracteristic() {
        return this.getCaracteristicService().getPmfmIdCaracteristic();
    }

    @Override
    public Caracteristic getWeightMeasuredCaracteristic() {
        return this.getCaracteristicService().getWeightMeasuredCaracteristic();
    }

    @Override
    public Caracteristic getCaracteristic(Integer pmfmId) {
        return this.getCaracteristicService().getCaracteristic(pmfmId);
    }

    @Override
    public boolean isVracBatch(SpeciesAbleBatch speciesBatch) {
        return this.getCaracteristicService().isVracBatch(speciesBatch);
    }

    @Override
    public Predicate<SpeciesAbleBatch> getVracBatchPredicate() {
        return this.getCaracteristicService().getVracBatchPredicate();
    }

    @Override
    public boolean isHorsVracBatch(SpeciesAbleBatch speciesBatch) {
        return this.getCaracteristicService().isHorsVracBatch(speciesBatch);
    }

    @Override
    public List<TuttiLocation> getAllProgramZone() {
        return this.getLocationService().getAllProgramZone();
    }

    @Override
    public List<TuttiLocation> getAllCountry() {
        return this.getLocationService().getAllCountry();
    }

    @Override
    public List<TuttiLocation> getAllHarbour() {
        return this.getLocationService().getAllHarbour();
    }

    @Override
    public List<TuttiLocation> getAllFishingOperationStrata(String zoneId) {
        return this.getLocationService().getAllFishingOperationStrata(zoneId);
    }

    @Override
    public List<TuttiLocation> getAllFishingOperationSubStrata(String zoneId, String strataId) {
        return this.getLocationService().getAllFishingOperationSubStrata(zoneId, strataId);
    }

    @Override
    public List<TuttiLocation> getAllFishingOperationLocation(String zoneId, String strataId, String subStrataId) {
        return this.getLocationService().getAllFishingOperationLocation(zoneId, strataId, subStrataId);
    }

    @Override
    public String getLocationLabelByLatLong(Float latitude, Float longitude) {
        return this.getLocationService().getLocationLabelByLatLong(latitude, longitude);
    }

    @Override
    public Integer getLocationIdByLatLong(Float latitude, Float longitude) {
        return this.getLocationService().getLocationIdByLatLong(latitude, longitude);
    }

    @Override
    public TuttiLocation getLocation(String id) {
        return this.getLocationService().getLocation(id);
    }

    @Override
    public List<ObjectType> getAllObjectType() {
        return this.getObjectTypeService().getAllObjectType();
    }

    @Override
    public ObjectType getObjectType(String objectTypeCode) {
        return this.getObjectTypeService().getObjectType(objectTypeCode);
    }

    @Override
    public List<Gear> getAllScientificGear() {
        return this.getGearService().getAllScientificGear();
    }

    @Override
    public List<Gear> getAllFishingGear() {
        return this.getGearService().getAllFishingGear();
    }

    @Override
    public Gear getGear(Integer gearId) {
        return this.getGearService().getGear(gearId);
    }

    @Override
    public boolean isTemporaryGearUsed(Integer id) {
        return this.getGearService().isTemporaryGearUsed(id);
    }

    @Override
    public List<Gear> addTemporaryGears(List<Gear> gears) {
        return this.getGearService().addTemporaryGears(gears);
    }

    @Override
    public List<Gear> updateTemporaryGears(List<Gear> gears) {
        return this.getGearService().updateTemporaryGears(gears);
    }

    @Override
    public List<Gear> linkTemporaryGears(List<Gear> gears) {
        return this.getGearService().linkTemporaryGears(gears);
    }

    @Override
    public void replaceGear(Gear source, Gear target, boolean delete) {
        this.getGearService().replaceGear(source, target, delete);
    }

    @Override
    public void deleteTemporaryGear(Integer id) {
        this.getGearService().deleteTemporaryGear(id);
    }

    @Override
    public void deleteTemporaryGears(Collection<Integer> id) {
        this.getGearService().deleteTemporaryGears(id);
    }

    @Override
    public List<Species> getAllSpecies() {
        List<Species> result = this.getSpeciesService().getAllSpecies();
        this.setSpeciesSurveyCode(result, this.getProtocol());
        return result;
    }

    @Override
    public List<Species> getAllReferentSpecies() {
        List<Species> result = this.getSpeciesService().getAllReferentSpecies();
        this.setSpeciesSurveyCode(result, this.getProtocol());
        return result;
    }

    @Override
    public Species getSpeciesByReferenceTaxonIdWithVernacularCode(Integer referenceTaxonId) {
        return this.getSpeciesService().getSpeciesByReferenceTaxonIdWithVernacularCode(referenceTaxonId);
    }

    @Override
    public Species getSpeciesByReferenceTaxonId(Integer referenceTaxonId) {
        return this.getSpeciesService().getSpeciesByReferenceTaxonId(referenceTaxonId);
    }

    @Override
    public boolean isTemporarySpeciesUsed(Integer referenceTaxonId) {
        SpeciesProtocol speciesProtocol;
        TuttiProtocol protocol = this.getProtocol();
        if (protocol != null && (speciesProtocol = TuttiProtocols.getSpeciesOrBenthosProtocol(protocol, referenceTaxonId)) != null) {
            return true;
        }
        return this.getSpeciesService().isTemporarySpeciesUsed(referenceTaxonId);
    }

    @Override
    public List<Species> addTemporarySpecies(List<Species> species) {
        return this.getSpeciesService().addTemporarySpecies(species);
    }

    @Override
    public List<Species> updateTemporarySpecies(List<Species> species) {
        return this.getSpeciesService().updateTemporarySpecies(species);
    }

    @Override
    public List<Species> linkTemporarySpecies(List<Species> species) {
        return this.getSpeciesService().linkTemporarySpecies(species);
    }

    @Override
    public void replaceSpecies(Species source, Species target, boolean delete) {
        this.getSpeciesService().replaceSpecies(source, target, delete);
        if (delete) {
            this.removeSpeciesFromProtocol(Lists.newArrayList((Object[])new Integer[]{source.getReferenceTaxonId()}));
        }
    }

    @Override
    public void deleteTemporarySpecies(Integer referenceTaxonId) {
        this.getSpeciesService().deleteTemporarySpecies(referenceTaxonId);
        this.removeSpeciesFromProtocol(Lists.newArrayList((Object[])new Integer[]{referenceTaxonId}));
    }

    @Override
    public void deleteTemporarySpecies(Collection<Integer> referenceTaxonIds) {
        this.getSpeciesService().deleteTemporarySpecies(referenceTaxonIds);
        this.removeSpeciesFromProtocol(referenceTaxonIds);
    }

    protected void removeSpeciesFromProtocol(Collection<Integer> referenceTaxonIds) {
        TuttiProtocol protocol = this.getProtocol();
        if (protocol != null) {
            boolean wasRemoved = false;
            for (Integer referenceTaxonId : referenceTaxonIds) {
                wasRemoved |= TuttiProtocols.removeSpeciesOrBenthosProtocol(protocol, referenceTaxonId);
            }
            if (wasRemoved) {
                if (log.isInfoEnabled()) {
                    log.info((Object)"Save protocol (some species or benthos were removed from it.)");
                }
                this.saveProtocol(protocol);
            }
        }
    }

    @Override
    public List<Person> getAllPerson() {
        return this.getPersonService().getAllPerson();
    }

    @Override
    public Person getPerson(Integer personId) {
        return this.getPersonService().getPerson(personId);
    }

    @Override
    public boolean isTemporaryPersonUsed(Integer id) {
        return this.getPersonService().isTemporaryPersonUsed(id);
    }

    @Override
    public List<Person> addTemporaryPersons(List<Person> persons) {
        return this.getPersonService().addTemporaryPersons(persons);
    }

    @Override
    public List<Person> updateTemporaryPersons(List<Person> persons) {
        return this.getPersonService().updateTemporaryPersons(persons);
    }

    @Override
    public List<Person> linkTemporaryPersons(List<Person> persons) {
        return this.getPersonService().linkTemporaryPersons(persons);
    }

    @Override
    public void replacePerson(Person source, Person target, boolean delete) {
        this.getPersonService().replacePerson(source, target, delete);
    }

    @Override
    public void deleteTemporaryPerson(Integer id) {
        this.getPersonService().deleteTemporaryPerson(id);
    }

    @Override
    public void deleteTemporaryPersons(Collection<Integer> ids) {
        this.getPersonService().deleteTemporaryPersons(ids);
    }

    @Override
    public List<Vessel> getAllScientificVessel() {
        return this.getVesselService().getAllScientificVessel();
    }

    @Override
    public List<Vessel> getAllFishingVessel() {
        return this.getVesselService().getAllFishingVessel();
    }

    @Override
    public Vessel getVessel(String vesselCode) {
        return this.getVesselService().getVessel(vesselCode);
    }

    @Override
    public boolean isTemporaryVesselUsed(String code) {
        return this.getVesselService().isTemporaryVesselUsed(code);
    }

    @Override
    public List<Vessel> addTemporaryVessels(List<Vessel> vessels) {
        return this.getVesselService().addTemporaryVessels(vessels);
    }

    @Override
    public List<Vessel> updateTemporaryVessels(List<Vessel> vessels) {
        return this.getVesselService().updateTemporaryVessels(vessels);
    }

    @Override
    public List<Vessel> linkTemporaryVessels(List<Vessel> vessels) {
        return this.getVesselService().linkTemporaryVessels(vessels);
    }

    @Override
    public void replaceVessel(Vessel source, Vessel target, boolean delete) {
        this.getVesselService().replaceVessel(source, target, delete);
    }

    @Override
    public void deleteTemporaryVessel(String code) {
        this.getVesselService().deleteTemporaryVessel(code);
    }

    @Override
    public void deleteTemporaryVessels(Collection<String> codes) {
        this.getVesselService().deleteTemporaryVessels(codes);
    }

    @Override
    public List<Attachment> getAllAttachments(ObjectTypeCode objectType, Integer objectId) {
        return this.getAttachmentService().getAllAttachments(objectType, objectId);
    }

    @Override
    public File getAttachmentFile(String attachmentId) {
        return this.getAttachmentService().getAttachmentFile(attachmentId);
    }

    @Override
    public Attachment createAttachment(Attachment attachment, File file) {
        return this.getAttachmentService().createAttachment(attachment, file);
    }

    @Override
    public Attachment saveAttachment(Attachment attachment) {
        return this.getAttachmentService().saveAttachment(attachment);
    }

    @Override
    public void deleteAttachment(String attachmentId) {
        this.getAttachmentService().deleteAttachment(attachmentId);
    }

    @Override
    public void deleteAllAttachment(ObjectTypeCode objectType, Integer ... objectIds) {
        this.getAttachmentService().deleteAllAttachment(objectType, objectIds);
    }

    @Override
    public List<Program> getAllProgram() {
        return this.getProgramService().getAllProgram();
    }

    @Override
    public Program getProgram(String id) {
        return this.getProgramService().getProgram(id);
    }

    @Override
    public Program createProgram(Program bean) {
        return this.getProgramService().createProgram(bean);
    }

    @Override
    public Program saveProgram(Program bean) {
        return this.getProgramService().saveProgram(bean);
    }

    @Override
    public List<String> getAllCruiseId(String programId) {
        return this.getCruiseService().getAllCruiseId(programId);
    }

    @Override
    public List<Cruise> getAllCruise(String programId) {
        return this.getCruiseService().getAllCruise(programId);
    }

    @Override
    public Cruise getCruise(String id) {
        return this.getCruiseService().getCruise(id);
    }

    @Override
    public Cruise createCruise(Cruise bean) {
        return this.getCruiseService().createCruise(bean);
    }

    @Override
    public Cruise saveCruise(Cruise bean, boolean updateVessel, boolean updateGear) {
        return this.getCruiseService().saveCruise(bean, updateVessel, updateGear);
    }

    @Override
    public void setCruiseReadyToSynch(Integer cruiseId) {
        this.getCruiseService().setCruiseReadyToSynch(cruiseId);
    }

    @Override
    public CaracteristicMap getGearCaracteristics(String cruiseId, String gearId, short rankOrder) {
        return this.getCruiseService().getGearCaracteristics(cruiseId, gearId, rankOrder);
    }

    @Override
    public boolean isOperationUseGears(Integer cruiseId, Collection<Gear> gears) {
        return this.getCruiseService().isOperationUseGears(cruiseId, gears);
    }

    @Override
    public void saveGearCaracteristics(Gear gear, Cruise cruise) {
        this.getCruiseService().saveGearCaracteristics(gear, cruise);
    }

    @Override
    public TuttiProtocol getProtocol() {
        return this.getProtocolService().getProtocol();
    }

    @Override
    public void setProtocol(TuttiProtocol protocol) {
        this.getProtocolService().setProtocol(protocol);
    }

    @Override
    public boolean isProtocolExist(String id) {
        return this.getProtocolService().isProtocolExist(id);
    }

    @Override
    public String getFirstAvailableName(String protocolName) {
        return this.getProtocolService().getFirstAvailableName(protocolName);
    }

    @Override
    public List<String> getAllProtocolNames() {
        return this.getProtocolService().getAllProtocolNames();
    }

    @Override
    public TuttiProtocol getProtocolByName(String protocolName) {
        return this.getProtocolService().getProtocolByName(protocolName);
    }

    @Override
    public List<TuttiProtocol> getAllProtocol() {
        return this.getProtocolService().getAllProtocol();
    }

    @Override
    public List<String> getAllProtocolId() {
        return this.getProtocolService().getAllProtocolId();
    }

    @Override
    public TuttiProtocol saveProtocol(TuttiProtocol bean) {
        return this.getProtocolService().saveProtocol(bean);
    }

    @Override
    public void deleteProtocol(String id) {
        this.getProtocolService().deleteProtocol(id);
    }

    @Override
    public TuttiProtocol createProtocol(TuttiProtocol bean) {
        return this.protocolService.createProtocol(bean);
    }

    @Override
    public TuttiProtocol getProtocol(String id) {
        TuttiProtocol protocol = this.getProtocolService().getProtocol(id);
        List<Species> allReferentSpecies = this.getAllReferentSpecies();
        Map<Integer, String> missingSpecies = TuttiProtocols.detectMissingSpecies(protocol, allReferentSpecies);
        TuttiProtocols.removeBadSpecies(protocol, missingSpecies);
        Map<Integer, String> missingBenthos = TuttiProtocols.detectMissingBenthos(protocol, allReferentSpecies);
        TuttiProtocols.removeBadBenthos(protocol, missingBenthos);
        return protocol;
    }

    @Override
    public int getFishingOperationCount(String cruiseId) {
        return this.getFishingOperationService().getFishingOperationCount(cruiseId);
    }

    @Override
    public List<String> getAllFishingOperationIds(String cruiseId) {
        return this.getFishingOperationService().getAllFishingOperationIds(cruiseId);
    }

    @Override
    public List<FishingOperation> getAllFishingOperation(String cruiseId) {
        return this.getFishingOperationService().getAllFishingOperation(cruiseId);
    }

    @Override
    public FishingOperation getFishingOperation(String id) {
        return this.getFishingOperationService().getFishingOperation(id);
    }

    @Override
    public List<Vessel> getFishingOperationSecondaryVessel(String fishingOperationId) {
        return this.getFishingOperationService().getFishingOperationSecondaryVessel(fishingOperationId);
    }

    @Override
    public FishingOperation createFishingOperation(FishingOperation bean) {
        return this.getFishingOperationService().createFishingOperation(bean);
    }

    @Override
    public FishingOperation saveFishingOperation(FishingOperation bean) {
        return this.getFishingOperationService().saveFishingOperation(bean);
    }

    @Override
    public Collection<FishingOperation> saveFishingOperations(Collection<FishingOperation> beans) {
        return this.getFishingOperationService().saveFishingOperations(beans);
    }

    @Override
    public void deleteFishingOperation(String id) {
        this.getFishingOperationService().deleteFishingOperation(id);
    }

    @Override
    public boolean isFishingOperationWithCatchBatch(String operationId) {
        return this.getCatchBatchService().isFishingOperationWithCatchBatch(operationId);
    }

    @Override
    public CatchBatch getCatchBatchFromFishingOperation(String id) throws InvalidBatchModelException {
        return this.getCatchBatchService().getCatchBatchFromFishingOperation(id);
    }

    @Override
    public CatchBatch createCatchBatch(CatchBatch bean) {
        return this.getCatchBatchService().createCatchBatch(bean);
    }

    @Override
    public CatchBatch saveCatchBatch(CatchBatch bean) {
        return this.getCatchBatchService().saveCatchBatch(bean);
    }

    @Override
    public void deleteCatchBatch(String fishingOperationId) {
        this.getCatchBatchService().deleteCatchBatch(fishingOperationId);
    }

    @Override
    public void recomputeCatchBatchSampleRatios(String fishingOperationId) {
        this.getCatchBatchService().recomputeCatchBatchSampleRatios(fishingOperationId);
    }

    @Override
    public BatchContainer<SpeciesBatch> getRootSpeciesBatch(String fishingOperationId, boolean validateTree) throws InvalidBatchModelException {
        return this.getSpeciesBatchService().getRootSpeciesBatch(fishingOperationId, validateTree);
    }

    @Override
    public SpeciesBatch createSpeciesBatch(SpeciesBatch bean, String parentBatchId, boolean computeRankOrder) {
        return this.getSpeciesBatchService().createSpeciesBatch(bean, parentBatchId, computeRankOrder);
    }

    @Override
    public Collection<SpeciesBatch> createSpeciesBatches(String fishingOperationId, Collection<SpeciesBatch> beans) {
        return this.getSpeciesBatchService().createSpeciesBatches(fishingOperationId, beans);
    }

    @Override
    public SpeciesBatch saveSpeciesBatch(SpeciesBatch bean) {
        return this.getSpeciesBatchService().saveSpeciesBatch(bean);
    }

    @Override
    public void deleteSpeciesBatch(String id) {
        this.getSpeciesBatchService().deleteSpeciesBatch(id);
    }

    @Override
    public void deleteSpeciesSubBatch(String id) {
        this.getSpeciesBatchService().deleteSpeciesSubBatch(id);
    }

    @Override
    public void changeSpeciesBatchSpecies(String batchId, Species species) {
        this.getSpeciesBatchService().changeSpeciesBatchSpecies(batchId, species);
    }

    @Override
    public List<SpeciesBatch> getAllSpeciesBatchToConfirm(String fishingOperationId) throws InvalidBatchModelException {
        return this.getSpeciesBatchService().getAllSpeciesBatchToConfirm(fishingOperationId);
    }

    @Override
    public List<SpeciesBatchFrequency> getAllSpeciesBatchFrequency(String speciesBatchId) {
        return this.getSpeciesBatchService().getAllSpeciesBatchFrequency(speciesBatchId);
    }

    @Override
    public Multimap<Species, SpeciesBatchFrequency> getAllSpeciesBatchFrequencyForBatch(BatchContainer<SpeciesBatch> batchContainer) {
        return this.getSpeciesBatchService().getAllSpeciesBatchFrequencyForBatch(batchContainer);
    }

    @Override
    public List<SpeciesBatchFrequency> saveSpeciesBatchFrequency(String speciesBatchId, List<SpeciesBatchFrequency> frequencies) {
        return this.getSpeciesBatchService().saveSpeciesBatchFrequency(speciesBatchId, frequencies);
    }

    @Override
    public BatchContainer<BenthosBatch> getRootBenthosBatch(String fishingOperationId, boolean validateTree) throws InvalidBatchModelException {
        return this.getBenthosBatchService().getRootBenthosBatch(fishingOperationId, validateTree);
    }

    @Override
    public BenthosBatch createBenthosBatch(BenthosBatch bean, String parentBatchId, boolean computeRankOrder) {
        return this.getBenthosBatchService().createBenthosBatch(bean, parentBatchId, computeRankOrder);
    }

    @Override
    public Collection<BenthosBatch> createBenthosBatches(String fishingOperationId, Collection<BenthosBatch> beans) {
        return this.getBenthosBatchService().createBenthosBatches(fishingOperationId, beans);
    }

    @Override
    public BenthosBatch saveBenthosBatch(BenthosBatch bean) {
        return this.getBenthosBatchService().saveBenthosBatch(bean);
    }

    @Override
    public void deleteBenthosBatch(String id) {
        this.getBenthosBatchService().deleteBenthosBatch(id);
    }

    @Override
    public void deleteBenthosSubBatch(String id) {
        this.getBenthosBatchService().deleteBenthosSubBatch(id);
    }

    @Override
    public void changeBenthosBatchSpecies(String batchId, Species species) {
        this.getBenthosBatchService().changeBenthosBatchSpecies(batchId, species);
    }

    @Override
    public List<BenthosBatch> getAllBenthosBatchToConfirm(String fishingOperationId) throws InvalidBatchModelException {
        return this.getBenthosBatchService().getAllBenthosBatchToConfirm(fishingOperationId);
    }

    @Override
    public List<BenthosBatchFrequency> getAllBenthosBatchFrequency(String benthosBatchId) {
        return this.getBenthosBatchService().getAllBenthosBatchFrequency(benthosBatchId);
    }

    @Override
    public Multimap<Species, BenthosBatchFrequency> getAllBenthosBatchFrequencyForBatch(BatchContainer<BenthosBatch> batchContainer) {
        return this.getBenthosBatchService().getAllBenthosBatchFrequencyForBatch(batchContainer);
    }

    @Override
    public List<BenthosBatchFrequency> saveBenthosBatchFrequency(String benthosBatchId, List<BenthosBatchFrequency> frequencies) {
        return this.getBenthosBatchService().saveBenthosBatchFrequency(benthosBatchId, frequencies);
    }

    @Override
    public BatchContainer<MarineLitterBatch> getRootMarineLitterBatch(String fishingOperationId) {
        return this.getMarineLitterBatchService().getRootMarineLitterBatch(fishingOperationId);
    }

    @Override
    public MarineLitterBatch createMarineLitterBatch(MarineLitterBatch bean) {
        return this.getMarineLitterBatchService().createMarineLitterBatch(bean);
    }

    @Override
    public Collection<MarineLitterBatch> createMarineLitterBatches(String fishingOperationId, Collection<MarineLitterBatch> beans) {
        return this.getMarineLitterBatchService().createMarineLitterBatches(fishingOperationId, beans);
    }

    @Override
    public MarineLitterBatch saveMarineLitterBatch(MarineLitterBatch bean) {
        return this.getMarineLitterBatchService().saveMarineLitterBatch(bean);
    }

    @Override
    public void deleteMarineLitterBatch(String id) {
        this.getMarineLitterBatchService().deleteMarineLitterBatch(id);
    }

    @Override
    public List<AccidentalBatch> getAllAccidentalBatch(String fishingOperationId) {
        return this.getAccidentalBatchService().getAllAccidentalBatch(fishingOperationId);
    }

    @Override
    public AccidentalBatch createAccidentalBatch(AccidentalBatch bean) {
        return this.getAccidentalBatchService().createAccidentalBatch(bean);
    }

    @Override
    public Collection<AccidentalBatch> createAccidentalBatches(String fishingOperationId, Collection<AccidentalBatch> beans) {
        return this.getAccidentalBatchService().createAccidentalBatches(fishingOperationId, beans);
    }

    @Override
    public AccidentalBatch saveAccidentalBatch(AccidentalBatch bean) {
        return this.getAccidentalBatchService().saveAccidentalBatch(bean);
    }

    @Override
    public void deleteAccidentalBatch(String id) {
        this.getAccidentalBatchService().deleteAccidentalBatch(id);
    }

    @Override
    public void deleteAccidentalBatchForFishingOperation(String fishingOperationId) {
        this.getAccidentalBatchService().deleteAccidentalBatchForFishingOperation(fishingOperationId);
    }

    @Override
    public List<IndividualObservationBatch> getAllIndividualObservationBatch(String fishingOperationId) {
        return this.getIndividualObservationBatchService().getAllIndividualObservationBatch(fishingOperationId);
    }

    @Override
    public IndividualObservationBatch createIndividualObservationBatch(IndividualObservationBatch bean) {
        return this.getIndividualObservationBatchService().createIndividualObservationBatch(bean);
    }

    @Override
    public Collection<IndividualObservationBatch> createIndividualObservationBatches(String fishingOperationId, Collection<IndividualObservationBatch> beans) {
        return this.getIndividualObservationBatchService().createIndividualObservationBatches(fishingOperationId, beans);
    }

    @Override
    public IndividualObservationBatch saveIndividualObservationBatch(IndividualObservationBatch bean) {
        return this.getIndividualObservationBatchService().saveIndividualObservationBatch(bean);
    }

    @Override
    public void deleteIndividualObservationBatch(String id) {
        this.getIndividualObservationBatchService().deleteIndividualObservationBatch(id);
    }

    @Override
    public void deleteIndividualObservationBatchForFishingOperation(String fishingOperationId) {
        this.getIndividualObservationBatchService().deleteIndividualObservationBatchForFishingOperation(fishingOperationId);
    }

    protected void setSpeciesSurveyCode(List<Species> speciesList, TuttiProtocol protocol) {
        if (protocol != null && !protocol.isSpeciesEmpty()) {
            Integer taxonId;
            String surveyCode;
            TreeMap surveyCodeByTaxonId = Maps.newTreeMap();
            if (!protocol.isSpeciesEmpty()) {
                for (SpeciesProtocol speciesProtocol : protocol.getSpecies()) {
                    surveyCode = speciesProtocol.getSpeciesSurveyCode();
                    if (!StringUtils.isNotBlank((CharSequence)surveyCode)) continue;
                    taxonId = speciesProtocol.getSpeciesReferenceTaxonId();
                    surveyCodeByTaxonId.put(taxonId, surveyCode);
                }
            }
            if (!protocol.isBenthosEmpty()) {
                for (SpeciesProtocol speciesProtocol : protocol.getBenthos()) {
                    String oldSurveyCode;
                    surveyCode = speciesProtocol.getSpeciesSurveyCode();
                    if (!StringUtils.isNotBlank((CharSequence)surveyCode) || (oldSurveyCode = surveyCodeByTaxonId.put(taxonId = speciesProtocol.getSpeciesReferenceTaxonId(), surveyCode)) == null || !log.isWarnEnabled()) continue;
                    log.warn((Object)String.format("Detect a species in both species and benthos protocol: taxonId=%d, species surveyCode=%s, benthos surveyCode=%s", taxonId, oldSurveyCode, surveyCode));
                }
            }
            for (Species species : speciesList) {
                Integer taxonId2 = species.getReferenceTaxonId();
                String surveyCode2 = (String)surveyCodeByTaxonId.get(taxonId2);
                species.setSurveyCode(surveyCode2);
            }
        }
    }

    public AccidentalBatchPersistenceService getAccidentalBatchService() {
        return this.getServiceInitialized(this.accidentalBatchService);
    }

    public AttachmentPersistenceService getAttachmentService() {
        return this.getServiceInitialized(this.attachmentService);
    }

    public BenthosBatchPersistenceService getBenthosBatchService() {
        return this.getServiceInitialized(this.benthosBatchService);
    }

    public CaracteristicPersistenceService getCaracteristicService() {
        return this.getServiceInitialized(this.caracteristicService);
    }

    public CatchBatchPersistenceService getCatchBatchService() {
        return this.getServiceInitialized(this.catchBatchService);
    }

    public CruisePersistenceService getCruiseService() {
        return this.getServiceInitialized(this.cruiseService);
    }

    public FishingOperationPersistenceService getFishingOperationService() {
        return this.getServiceInitialized(this.fishingOperationService);
    }

    public GearPersistenceService getGearService() {
        return this.getServiceInitialized(this.gearService);
    }

    public IndividualObservationBatchPersistenceService getIndividualObservationBatchService() {
        return this.getServiceInitialized(this.individualObservationBatchService);
    }

    public LocationPersistenceService getLocationService() {
        return this.getServiceInitialized(this.locationService);
    }

    public MarineLitterBatchPersistenceService getMarineLitterBatchService() {
        return this.getServiceInitialized(this.marineLitterBatchService);
    }

    public ObjectTypePersistenceService getObjectTypeService() {
        return this.getServiceInitialized(this.objectTypeService);
    }

    public PersonPersistenceService getPersonService() {
        return this.getServiceInitialized(this.personService);
    }

    public ProtocolPersistenceService getProtocolService() {
        return this.getServiceInitialized(this.protocolService);
    }

    public ProgramPersistenceService getProgramService() {
        return this.getServiceInitialized(this.programService);
    }

    public SpeciesBatchPersistenceService getSpeciesBatchService() {
        return this.getServiceInitialized(this.speciesBatchService);
    }

    public SpeciesPersistenceService getSpeciesService() {
        return this.getServiceInitialized(this.speciesService);
    }

    public TechnicalPersistenceService getTechnicalPersistenceService() {
        return this.getServiceInitialized(this.technicalPersistenceService);
    }

    public VesselPersistenceService getVesselService() {
        return this.getServiceInitialized(this.vesselService);
    }

    protected <S extends TuttiPersistenceServiceImplementor> S getServiceInitialized(S service) {
        service.lazyInit();
        return service;
    }
}

