/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives.adapters;

import java.util.Collection;
import org.apache.commons.collections.primitives.ByteCollection;
import org.apache.commons.collections.primitives.ByteIterator;
import org.apache.commons.collections.primitives.adapters.ByteCollectionCollection;
import org.apache.commons.collections.primitives.adapters.IteratorByteIterator;

abstract class AbstractCollectionByteCollection
implements ByteCollection {
    protected AbstractCollectionByteCollection() {
    }

    public boolean add(byte element) {
        return this.getCollection().add(new Byte(element));
    }

    public boolean addAll(ByteCollection c) {
        return this.getCollection().addAll(ByteCollectionCollection.wrap(c));
    }

    public void clear() {
        this.getCollection().clear();
    }

    public boolean contains(byte element) {
        return this.getCollection().contains(new Byte(element));
    }

    public boolean containsAll(ByteCollection c) {
        return this.getCollection().containsAll(ByteCollectionCollection.wrap(c));
    }

    public String toString() {
        return this.getCollection().toString();
    }

    public boolean isEmpty() {
        return this.getCollection().isEmpty();
    }

    public ByteIterator iterator() {
        return IteratorByteIterator.wrap(this.getCollection().iterator());
    }

    public boolean removeElement(byte element) {
        return this.getCollection().remove(new Byte(element));
    }

    public boolean removeAll(ByteCollection c) {
        return this.getCollection().removeAll(ByteCollectionCollection.wrap(c));
    }

    public boolean retainAll(ByteCollection c) {
        return this.getCollection().retainAll(ByteCollectionCollection.wrap(c));
    }

    public int size() {
        return this.getCollection().size();
    }

    public byte[] toArray() {
        Object[] src = this.getCollection().toArray();
        byte[] dest = new byte[src.length];
        for (int i = 0; i < src.length; ++i) {
            dest[i] = ((Number)src[i]).byteValue();
        }
        return dest;
    }

    public byte[] toArray(byte[] dest) {
        Object[] src = this.getCollection().toArray();
        if (dest.length < src.length) {
            dest = new byte[src.length];
        }
        for (int i = 0; i < src.length; ++i) {
            dest[i] = ((Number)src[i]).byteValue();
        }
        return dest;
    }

    protected abstract Collection getCollection();
}

