/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat.importactions;

import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.service.catches.WeightCleaningService;
import fr.ifremer.tutti.service.genericformat.GenericFormatContextSupport;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportContext;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportCruiseContext;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportOperationContext;
import fr.ifremer.tutti.service.genericformat.importactions.ImportActionSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class DoCleanWeightAction
extends ImportActionSupport {
    private static final Log log = LogFactory.getLog(DoCleanWeightAction.class);
    private final WeightCleaningService weightCleaningService;

    public DoCleanWeightAction(GenericFormatImportContext importContext, WeightCleaningService weightCleaningService) {
        super(importContext);
        this.weightCleaningService = weightCleaningService;
    }

    @Override
    protected boolean canExecute() {
        return this.importContext.getImportRequest().isCleanWeights() && this.importContext.isTechnicalFilesValid() && this.importContext.getCatchFileResult().isValid() && this.importContext.getMarineLitterFileResult().isValid();
    }

    @Override
    protected void doExecute() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Will clean weights.");
        }
        this.importContext.doActionOnCruiseContexts(new GenericFormatContextSupport.CruiseContextAction(){

            @Override
            public void onCruise(GenericFormatImportCruiseContext cruiseContext, ProgressionModel progressionModel) {
                for (GenericFormatImportOperationContext operationContext : cruiseContext.getFishingOperationContexts()) {
                    progressionModel.increments(I18n.t((String)"tutti.service.genericFormat.cleanWeights.fishingOperation", (Object[])new Object[]{cruiseContext.getCruiseLabel(), operationContext.getFishingOperationLabel()}));
                    DoCleanWeightAction.this.weightCleaningService.cleanFishingOperation(operationContext.getFishingOperation().getId());
                }
            }
        });
    }
}

