/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.bigfin;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.io.Files;
import fr.ifremer.adagio.core.dao.referential.ObjectTypeCode;
import fr.ifremer.adagio.core.dao.referential.pmfm.PmfmId;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.Attachments;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequency;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequencys;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchs;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.AbstractTuttiService;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiServiceContext;
import fr.ifremer.tutti.service.bigfin.BigfinDataRow;
import fr.ifremer.tutti.service.bigfin.BigfinDataRowModel;
import fr.ifremer.tutti.service.bigfin.BigfinImportResult;
import fr.ifremer.tutti.service.bigfin.Signs;
import fr.ifremer.tutti.util.Weights;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.Import;
import org.nuiton.csv.ImportModel;
import org.nuiton.csv.ImportRuntimeException;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationBusinessException;

public class BigfinImportService
extends AbstractTuttiService {
    private static final Log log = LogFactory.getLog(BigfinImportService.class);
    protected PersistenceService persistenceService;
    protected Caracteristic sizeCaracteristic;
    protected Caracteristic genderCaracteristic;
    protected Map<Signs, CaracteristicQualitativeValue> signsToCaracteristicValue;
    protected Map<String, SpeciesProtocol> speciesProtocolBySurveyCode;

    @Override
    public void setServiceContext(TuttiServiceContext context) {
        super.setServiceContext(context);
        this.persistenceService = this.getService(PersistenceService.class);
        this.signsToCaracteristicValue = Maps.newEnumMap(Signs.class);
        Caracteristic caracteristic = this.persistenceService.getSortedUnsortedCaracteristic();
        Signs.VRAC.registerSign(caracteristic, this.signsToCaracteristicValue);
        Signs.HORS_VRAC.registerSign(caracteristic, this.signsToCaracteristicValue);
        this.sizeCaracteristic = this.persistenceService.getSizeCategoryCaracteristic();
        Signs.NOT_SIZED.registerSign(this.sizeCaracteristic, this.signsToCaracteristicValue);
        Signs.SMALL.registerSign(this.sizeCaracteristic, this.signsToCaracteristicValue);
        Signs.BIG.registerSign(this.sizeCaracteristic, this.signsToCaracteristicValue);
        this.genderCaracteristic = this.persistenceService.getSexCaracteristic();
        Signs.NOT_SEXED.registerSign(this.genderCaracteristic, this.signsToCaracteristicValue);
        Signs.MALE.registerSign(this.genderCaracteristic, this.signsToCaracteristicValue);
        Signs.FEMALE.registerSign(this.genderCaracteristic, this.signsToCaracteristicValue);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BigfinImportResult importFile(File bigfinFile, FishingOperation operation, CatchBatch catchBatch) {
        Preconditions.checkNotNull((Object)bigfinFile);
        Preconditions.checkArgument((boolean)bigfinFile.exists(), (Object)("Bigfin file " + bigfinFile + " does not exist."));
        TuttiProtocol protocol = this.persistenceService.getProtocol();
        if (protocol == null) {
            throw new ApplicationBusinessException(I18n.t((String)"tutti.service.bigfinimport.error.no.protocol", (Object[])new Object[0]));
        }
        List<Species> allReferentSpecies = this.persistenceService.getAllReferentSpecies();
        List<Species> allSpeciesWithSurveyCode = this.persistenceService.getReferentSpeciesWithSurveyCode(allReferentSpecies);
        TreeMap speciesBySurveyCode = Maps.newTreeMap();
        for (Species species : allReferentSpecies) {
            String surveyCode = species.getSurveyCode();
            if (StringUtils.isNotBlank((CharSequence)surveyCode)) {
                speciesBySurveyCode.put(surveyCode, species);
                continue;
            }
            if (species.getRefTaxCode() == null) continue;
            speciesBySurveyCode.put(species.getRefTaxCode(), species);
        }
        this.speciesProtocolBySurveyCode = Maps.newTreeMap();
        for (SpeciesProtocol speciesProtocol : protocol.getSpecies()) {
            if (StringUtils.isNotBlank((CharSequence)speciesProtocol.getSpeciesSurveyCode())) {
                this.speciesProtocolBySurveyCode.put(speciesProtocol.getSpeciesSurveyCode(), speciesProtocol);
                continue;
            }
            this.speciesProtocolBySurveyCode.put(speciesProtocol.getSpeciesReferenceTaxonId().toString(), speciesProtocol);
        }
        BatchContainer<SpeciesBatch> rootSpeciesBatch = this.persistenceService.getRootSpeciesBatch(operation.getId(), false);
        HashSet<Species> speciesNotRecognized = new HashSet<Species>();
        HashSet<Species> speciesNotInProtocol = new HashSet<Species>();
        HashSet<Species> speciesInProtocolButWithoutLengthStepPmfmId = new HashSet<Species>();
        ArrayList<BigfinDataRow> rows = new ArrayList<BigfinDataRow>();
        BigfinImportResult result = new BigfinImportResult(bigfinFile);
        BigfinDataRowModel importModel = new BigfinDataRowModel(';', speciesBySurveyCode);
        BufferedReader reader = null;
        Import importer = null;
        try {
            reader = Files.newReader((File)bigfinFile, (Charset)Charsets.UTF_8);
            importer = Import.newImport((ImportModel)importModel, (Reader)reader);
            for (BigfinDataRow bean : importer) {
                String error;
                String error2;
                Species species = bean.getSpecies();
                String station = bean.getStation();
                Date dt = bean.getDt();
                if (station == null || !station.equals(operation.getStationNumber()) || dt == null || !DateUtils.isSameDay((Date)dt, (Date)operation.getGearShootingStartDate())) continue;
                if (bean.getSzClass() == null) {
                    error2 = I18n.t((String)"tutti.service.bigfinImport.error.szClass.unknwon", (Object[])new Object[]{bean.getRecordId()});
                    if (log.isErrorEnabled()) {
                        log.error((Object)error2);
                    }
                    result.addError(error2);
                }
                if (species == null || species.getId() == null) {
                    if (!speciesNotRecognized.add(species)) continue;
                    error2 = I18n.t((String)"tutti.service.bigfinImport.error.species.not.found", (Object[])new Object[]{species.getExternalCode()});
                    if (log.isErrorEnabled()) {
                        log.error((Object)error2);
                    }
                    result.addError(error2);
                    continue;
                }
                String code = species.getSurveyCode();
                if (StringUtils.isBlank((CharSequence)code)) {
                    code = species.getReferenceTaxonId().toString();
                }
                SpeciesProtocol speciesProtocol = this.speciesProtocolBySurveyCode.get(code);
                String speciesLabel = species.getSurveyCode();
                if (StringUtils.isBlank((CharSequence)speciesLabel)) {
                    speciesLabel = species.getRefTaxCode();
                }
                if (speciesProtocol == null) {
                    if (!speciesNotInProtocol.add(species)) continue;
                    error = I18n.t((String)"tutti.service.bigfinImport.warning.species.notInProtocol", (Object[])new Object[]{speciesLabel});
                    if (log.isWarnEnabled()) {
                        log.warn((Object)error);
                    }
                    result.addWarning(error);
                    continue;
                }
                if (speciesProtocol.getLengthStepPmfmId() == null) {
                    if (!speciesInProtocolButWithoutLengthStepPmfmId.add(species)) continue;
                    error = I18n.t((String)"tutti.service.bigfinImport.error.species.without.lengthstep", (Object[])new Object[]{speciesLabel});
                    if (log.isErrorEnabled()) {
                        log.error((Object)error);
                    }
                    result.addError(error);
                    continue;
                }
                rows.add(bean);
            }
        }
        catch (ImportRuntimeException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new ImportRuntimeException("Could not import bigfin data from file " + bigfinFile, (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(importer);
                IOUtils.closeQuietly((Reader)reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)importer);
        IOUtils.closeQuietly((Reader)reader);
        if (result.isDone()) {
            List rootSpeciesBatches = rootSpeciesBatch.getChildren();
            ImmutableListMultimap batchesBySpecies = Multimaps.index((Iterable)rootSpeciesBatches, (Function)new Function<SpeciesBatch, Species>(){

                public Species apply(SpeciesBatch input) {
                    return input.getSpecies();
                }
            });
            ImmutableListMultimap rowsBySpecies = Multimaps.index(rows, (Function)new Function<BigfinDataRow, Species>(){

                public Species apply(BigfinDataRow bigfinDataRow) {
                    return bigfinDataRow.getSpecies();
                }
            });
            SampleCategoryModel sampleCategoryModel = this.context.getSampleCategoryModel();
            List samplingOrder = sampleCategoryModel.getSamplingOrder();
            ArrayList<Integer> pmfmIds = new ArrayList<Integer>();
            pmfmIds.add(PmfmId.SORTED_UNSORTED.getValue());
            ArrayList<Object> functions = new ArrayList<Object>();
            for (Integer categoryId : samplingOrder) {
                if (PmfmId.SIZE_CATEGORY.getValue().equals(categoryId)) {
                    pmfmIds.add(categoryId);
                    functions.add(new Function<BigfinDataRow, Signs>(){

                        public Signs apply(BigfinDataRow bigfinDataRow) {
                            Signs result = bigfinDataRow.getSzClass();
                            return result;
                        }
                    });
                    continue;
                }
                if (!PmfmId.SEX.getValue().equals(categoryId)) continue;
                pmfmIds.add(categoryId);
                functions.add(new Function<BigfinDataRow, Signs>(){

                    public Signs apply(BigfinDataRow bigfinDataRow) {
                        Signs result = bigfinDataRow.getGender();
                        return result;
                    }
                });
            }
            ArrayList<Category> categories = new ArrayList<Category>();
            for (int i = 0; i < pmfmIds.size(); ++i) {
                Category category = new Category((Integer)pmfmIds.get(i), i < functions.size() ? (Function)functions.get(i) : null);
                categories.add(category);
            }
            for (Species species : rowsBySpecies.keySet()) {
                String code = species.getSurveyCode();
                if (StringUtils.isBlank((CharSequence)code)) {
                    code = species.getReferenceTaxonId().toString();
                }
                SpeciesProtocol speciesProtocol = this.speciesProtocolBySurveyCode.get(code);
                Caracteristic lengthStepPmfm = this.persistenceService.getCaracteristic(Integer.parseInt(speciesProtocol.getLengthStepPmfmId()));
                Collection speciesRows = rowsBySpecies.get((Object)species);
                ImmutableListMultimap rowsByVracHorsVrac = Multimaps.index((Iterable)speciesRows, (Function)new Function<BigfinDataRow, Signs>(){

                    public Signs apply(BigfinDataRow bigfinDataRow) {
                        Signs result = bigfinDataRow.getVracHorsVrac();
                        return result;
                    }
                });
                Collection speciesBatches = batchesBySpecies.get((Object)species);
                ImmutableMap speciesBatchByVracHorsVrac = Maps.uniqueIndex((Iterable)speciesBatches, (Function)SpeciesBatchs.GET_SAMPLE_CATEGORY_VALUE);
                BrowseBatchesParameter commonParameter = new BrowseBatchesParameter(operation, species, lengthStepPmfm, categories, result);
                this.browseBatchesToAddFrequencies(commonParameter, null, 0, (Map<Serializable, SpeciesBatch>)speciesBatchByVracHorsVrac, (Multimap<Signs, BigfinDataRow>)rowsByVracHorsVrac);
            }
            this.addFileAsAttachment(bigfinFile, catchBatch);
        }
        return result;
    }

    protected void browseBatchesToAddFrequencies(BrowseBatchesParameter commonParameter, SpeciesBatch parentBatch, int depth, Map<Serializable, SpeciesBatch> batchesByCaracteristic, Multimap<Signs, BigfinDataRow> rowsByCaracteristic) {
        Category category = commonParameter.getCategories().get(depth++);
        for (Signs caracteristic : rowsByCaracteristic.keySet()) {
            Collection bigfinDataRows = rowsByCaracteristic.get((Object)caracteristic);
            SpeciesBatch batch = batchesByCaracteristic.get(this.signsToCaracteristicValue.get((Object)caracteristic));
            boolean batchHasFrequencies = false;
            if (batch == null) {
                batch = caracteristic.isNullEquivalent() ? parentBatch : this.createSpeciesBatch(commonParameter.getSpecies(), commonParameter.getOperation(), category.getPmfmId(), caracteristic, parentBatch != null ? parentBatch.getId() : null);
            } else {
                List<SpeciesBatchFrequency> frequencies = this.persistenceService.getAllSpeciesBatchFrequency(batch.getId());
                batchHasFrequencies = CollectionUtils.isNotEmpty(frequencies);
            }
            if (category.getCategoryValueGetter() == null) {
                if (CollectionUtils.isNotEmpty((Collection)batch.getChildBatchs())) {
                    commonParameter.getResult().addWarning(I18n.t((String)"tutti.service.bigfinImport.warning.species.tooCategorized", (Object[])new Object[]{commonParameter.getSpeciesLabel(), this.sizeCaracteristic.getParameterName(), this.genderCaracteristic.getParameterName()}));
                    continue;
                }
                Integer deletedNb = this.persistenceService.countFrequenciesNumber(this.persistenceService.getAllSpeciesBatchFrequency(batch.getId()), false);
                List<SpeciesBatchFrequency> frequencies = this.createFrequencies(batch, bigfinDataRows, commonParameter.getLengthStepPmfm());
                this.persistenceService.saveSpeciesBatchFrequency(batch.getId(), frequencies);
                commonParameter.getResult().incrementNbFrequenciesDeleted(deletedNb != null ? deletedNb : 0);
                Integer importedNb = this.persistenceService.countFrequenciesNumber(frequencies, false);
                commonParameter.getResult().incrementNbFrequenciesImported(importedNb != null ? importedNb : 0);
                continue;
            }
            if (batchHasFrequencies) {
                CaracteristicQualitativeValue qualitativeValue = this.signsToCaracteristicValue.get((Object)caracteristic);
                commonParameter.getResult().addWarning(I18n.t((String)"tutti.service.bigfinImport.warning.species.batch.frequenciesOnHigherLevel", (Object[])new Object[]{commonParameter.getSpeciesLabel(), qualitativeValue.getName()}));
                continue;
            }
            List batchChildren = batch.getChildBatchs();
            ImmutableListMultimap rowsByNewCaracteristic = Multimaps.index((Iterable)bigfinDataRows, category.getCategoryValueGetter());
            HashMap<Serializable, SpeciesBatch> childrenByCaracteristic = new HashMap<Serializable, SpeciesBatch>();
            if (CollectionUtils.isNotEmpty((Collection)batchChildren)) {
                SpeciesBatch firstBatch = (SpeciesBatch)batchChildren.get(0);
                Integer categoryId = firstBatch.getSampleCategoryId();
                Category nextCategory = commonParameter.getCategories().get(depth);
                if (!nextCategory.getPmfmId().equals(categoryId)) {
                    Set signsSet = rowsByNewCaracteristic.keySet();
                    if (signsSet.size() == 1 && ((Signs)((Object)signsSet.iterator().next())).isNullEquivalent()) {
                        category = commonParameter.getCategories().get(depth++);
                        rowsByNewCaracteristic = Multimaps.index((Iterable)bigfinDataRows, category.getCategoryValueGetter());
                        nextCategory = commonParameter.getCategories().get(depth);
                        if (!nextCategory.getPmfmId().equals(categoryId)) {
                            commonParameter.getResult().addWarning(I18n.t((String)"tutti.service.bigfinImport.warning.species.categoriesSkipped", (Object[])new Object[]{commonParameter.getSpeciesLabel(), this.sizeCaracteristic.getParameterName(), this.genderCaracteristic.getParameterName()}));
                            continue;
                        }
                    } else {
                        commonParameter.getResult().addWarning(I18n.t((String)"tutti.service.bigfinImport.warning.species.categorySkipped", (Object[])new Object[]{commonParameter.getSpeciesLabel(), this.persistenceService.getCaracteristic(nextCategory.getPmfmId()).getParameterName()}));
                        continue;
                    }
                }
                childrenByCaracteristic.putAll((Map<Serializable, SpeciesBatch>)Maps.uniqueIndex((Iterable)batchChildren, (Function)SpeciesBatchs.GET_SAMPLE_CATEGORY_VALUE));
            }
            this.browseBatchesToAddFrequencies(commonParameter, batch, depth, childrenByCaracteristic, (Multimap<Signs, BigfinDataRow>)rowsByNewCaracteristic);
        }
    }

    protected SpeciesBatch createSpeciesBatch(Species species, FishingOperation operation, Integer categoryId, Signs signs, String parentBatchId) {
        Preconditions.checkArgument((boolean)signs.getCategory().equals(categoryId));
        SpeciesBatch batch = SpeciesBatchs.newSpeciesBatch();
        batch.setSpecies(species);
        batch.setFishingOperation(operation);
        batch.setSampleCategoryId(categoryId);
        batch.setSampleCategoryValue((Serializable)this.signsToCaracteristicValue.get((Object)signs));
        batch = this.persistenceService.createSpeciesBatch(batch, parentBatchId);
        return batch;
    }

    protected List<SpeciesBatchFrequency> createFrequencies(SpeciesBatch batch, Collection<BigfinDataRow> rows, Caracteristic lengthStepPmfm) {
        Preconditions.checkNotNull((Object)lengthStepPmfm);
        String unit = lengthStepPmfm.getUnit();
        Float precision = lengthStepPmfm.getPrecision();
        if (precision == null) {
            precision = Float.valueOf(1.0f);
        }
        ArrayListMultimap weightsByLengthStep = ArrayListMultimap.create();
        for (BigfinDataRow row : rows) {
            Float weight = row.getWeight();
            float length = row.getLength();
            if ("cm".equals(unit)) {
                length /= 10.0f;
            }
            int intValue = (int)(length * 10.0f);
            int intStep = (int)(precision.floatValue() * 10.0f);
            int correctIntStep = intValue - intValue % intStep;
            float lengthStep = (float)correctIntStep / 10.0f;
            weightsByLengthStep.put((Object)Float.valueOf(lengthStep), (Object)weight);
        }
        ArrayList<SpeciesBatchFrequency> frequencies = new ArrayList<SpeciesBatchFrequency>();
        for (Float lengthStep : weightsByLengthStep.keySet()) {
            SpeciesBatchFrequency frequency = SpeciesBatchFrequencys.newSpeciesBatchFrequency();
            frequencies.add(frequency);
            frequency.setBatch(batch);
            frequency.setLengthStep(lengthStep);
            frequency.setLengthStepCaracteristic(lengthStepPmfm);
            List weights = weightsByLengthStep.get((Object)lengthStep);
            frequency.setNumber(Integer.valueOf(weights.size()));
            Float totalWeight = Float.valueOf(0.0f);
            for (Float weight : weights) {
                if (weight == null) continue;
                totalWeight = Float.valueOf(totalWeight.floatValue() + weight.floatValue());
            }
            if (!(totalWeight.floatValue() > 0.0f)) continue;
            totalWeight = Float.valueOf(Weights.roundKiloGram((float)(totalWeight.floatValue() / 1000.0f)));
            frequency.setWeight(totalWeight);
        }
        return frequencies;
    }

    protected void addFileAsAttachment(File f, CatchBatch catchBatch) {
        Attachment attachment = Attachments.newAttachment();
        attachment.setObjectType(ObjectTypeCode.CATCH_BATCH);
        attachment.setObjectId(Integer.valueOf(catchBatch.getId()));
        attachment.setName(f.getName());
        String date = DateFormat.getDateTimeInstance().format(this.context.currentDate());
        String comment = I18n.t((String)"tutti.service.bigfin.import.attachment.comment", (Object[])new Object[]{date});
        attachment.setComment(comment);
        this.persistenceService.createAttachment(attachment, f);
    }

    private class BrowseBatchesParameter {
        private FishingOperation operation;
        private Species species;
        private Caracteristic lengthStepPmfm;
        private List<Category> categories;
        private BigfinImportResult result;
        private String speciesLabel;

        public BrowseBatchesParameter(FishingOperation operation, Species species, Caracteristic lengthStepPmfm, List<Category> categories, BigfinImportResult result) {
            this.operation = operation;
            this.species = species;
            this.lengthStepPmfm = lengthStepPmfm;
            this.categories = categories;
            this.result = result;
            this.speciesLabel = species.getSurveyCode();
            if (StringUtils.isBlank((CharSequence)this.speciesLabel)) {
                this.speciesLabel = species.getRefTaxCode();
            }
        }

        public FishingOperation getOperation() {
            return this.operation;
        }

        public Species getSpecies() {
            return this.species;
        }

        public Caracteristic getLengthStepPmfm() {
            return this.lengthStepPmfm;
        }

        public List<Category> getCategories() {
            return this.categories;
        }

        public BigfinImportResult getResult() {
            return this.result;
        }

        public String getSpeciesLabel() {
            return this.speciesLabel;
        }
    }

    private class Category {
        private Integer pmfmId;
        private Function<BigfinDataRow, Signs> categoryValueGetter;

        public Category(Integer pmfmId, Function<BigfinDataRow, Signs> dataGetter) {
            this.pmfmId = pmfmId;
            this.categoryValueGetter = dataGetter;
        }

        public Integer getPmfmId() {
            return this.pmfmId;
        }

        public Function<BigfinDataRow, Signs> getCategoryValueGetter() {
            return this.categoryValueGetter;
        }
    }
}

