/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.action;

import fr.ifremer.adagio.core.AdagioTechnicalException;
import fr.ifremer.adagio.core.action.ActionUtils;
import fr.ifremer.adagio.core.config.AdagioConfiguration;
import fr.ifremer.adagio.core.dao.technical.DaoUtils;
import fr.ifremer.adagio.core.service.DatabaseSchemaService;
import fr.ifremer.adagio.core.service.ServiceLocator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.version.Version;

public class DatabaseUpdateAction {
    private static final Log log = LogFactory.getLog(DatabaseUpdateAction.class);

    public void run() {
        AdagioConfiguration config = AdagioConfiguration.getInstance();
        if (log.isInfoEnabled()) {
            log.info((Object)"Starting database schema update...");
        }
        ActionUtils.logConnectionProperties();
        boolean isValidConnection = DaoUtils.isValidConnectionProperties(config.getJdbcDriver(), config.getJdbcURL(), config.getJdbcUsername(), config.getJdbcPassword());
        if (!isValidConnection) {
            log.warn((Object)"Connection error: could not update the schema.");
            return;
        }
        DatabaseSchemaService databaseSchemaService = ServiceLocator.instance().getService("databaseSchemaService", DatabaseSchemaService.class);
        if (!databaseSchemaService.isDbLoaded()) {
            log.warn((Object)"Database not start ! Could not update the schema.");
            return;
        }
        try {
            Version actualDbVersion = databaseSchemaService.getDbVersion();
            if (actualDbVersion != null) {
                log.info((Object)("Database schema version is: " + actualDbVersion.toString()));
            }
            Version expectedDbVersion = databaseSchemaService.getApplicationVersion();
            log.info((Object)("Database schema version AFTER the update should be: " + expectedDbVersion.toString()));
        }
        catch (AdagioTechnicalException e) {
            log.error((Object)"Error while getting versions.", (Throwable)e);
        }
        try {
            log.info((Object)"Launching update...");
            databaseSchemaService.updateSchema();
            log.info((Object)"Database schema successfullly updated.");
        }
        catch (AdagioTechnicalException e) {
            log.error((Object)"Error while updating the database schema.", (Throwable)e);
        }
    }
}

