/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.area.impl;

import org.eclipse.birt.report.engine.content.IAutoTextContent;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.layout.area.IArea;
import org.eclipse.birt.report.engine.layout.area.IContainerArea;
import org.eclipse.birt.report.engine.layout.area.IImageArea;
import org.eclipse.birt.report.engine.layout.area.impl.BlockContainerArea;
import org.eclipse.birt.report.engine.layout.area.impl.CellArea;
import org.eclipse.birt.report.engine.layout.area.impl.ImageArea;
import org.eclipse.birt.report.engine.layout.area.impl.InlineContainerArea;
import org.eclipse.birt.report.engine.layout.area.impl.LineArea;
import org.eclipse.birt.report.engine.layout.area.impl.LogicContainerArea;
import org.eclipse.birt.report.engine.layout.area.impl.PageArea;
import org.eclipse.birt.report.engine.layout.area.impl.RowArea;
import org.eclipse.birt.report.engine.layout.area.impl.TableArea;
import org.eclipse.birt.report.engine.layout.area.impl.TemplateArea;
import org.eclipse.birt.report.engine.layout.area.impl.TextArea;
import org.eclipse.birt.report.engine.layout.pdf.font.FontInfo;

public class AreaFactory {
    public static IImageArea createImageArea(IImageContent image) {
        return new ImageArea(image);
    }

    public static IArea createTableGroupArea(IContent group) {
        return new BlockContainerArea(group);
    }

    public static IArea createTemplateArea(IAutoTextContent autoText) {
        return new TemplateArea(autoText);
    }

    public static IArea createTextArea(ITextContent content, String text, FontInfo fi) {
        return new TextArea(content, text, fi);
    }

    public static IArea createTextArea(ITextContent textContent, FontInfo fi, boolean blankLine) {
        return new TextArea(textContent, fi, blankLine);
    }

    public static IArea createTextArea(ITextContent textContent, int offset, int baseLevel, int runLevel, FontInfo fontInfo) {
        return new TextArea(textContent, offset, baseLevel, runLevel, fontInfo);
    }

    public static IArea createTextArea(ITextContent textContent, IStyle areaStyle, int offset, int baseLevel, int runLevel, FontInfo fontInfo) {
        return new TextArea(textContent, areaStyle, offset, baseLevel, runLevel, fontInfo);
    }

    public static IContainerArea createBlockContainer(IContent content) {
        return new BlockContainerArea(content);
    }

    public static IContainerArea createLogicContainer(IReportContent report) {
        return new LogicContainerArea(report);
    }

    public static CellArea createCellArea(ICellContent cell) {
        return new CellArea(cell);
    }

    public static IContainerArea createPageArea(IPageContent pageContent) {
        return new PageArea(pageContent);
    }

    public static TableArea createTableArea(ITableContent table) {
        return new TableArea(table);
    }

    public static RowArea createRowArea(IRowContent row) {
        return new RowArea(row);
    }

    public static LineArea createLineArea(IReportContent report) {
        return new LineArea(report);
    }

    public static IContainerArea createInlineContainer(IContent content) {
        return new InlineContainerArea(content);
    }

    public static IContainerArea createInlineContainer(IContent content, boolean isFirst, boolean isLast) {
        IContainerArea containerArea = AreaFactory.createInlineContainer(content);
        IStyle style = containerArea.getStyle();
        if (!isFirst) {
            style.setProperty(42, IStyle.NUMBER_0);
            style.setProperty(3, IStyle.NUMBER_0);
            style.setProperty(16, IStyle.NUMBER_0);
        }
        if (!isLast) {
            style.setProperty(10, IStyle.NUMBER_0);
            style.setProperty(4, IStyle.NUMBER_0);
            style.setProperty(17, IStyle.NUMBER_0);
        }
        return containerArea;
    }
}

