/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.text.AbstractDocument;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.swing.Item;
import jaxx.runtime.swing.JAXXComboBox;
import jaxx.runtime.swing.editor.BooleanCellEditor;
import jaxx.runtime.swing.model.JaxxDefaultComboBoxModel;
import jaxx.runtime.swing.model.JaxxDefaultListModel;
import jaxx.runtime.swing.renderer.BooleanCellRenderer;
import jaxx.runtime.swing.renderer.EmptyNumberTableCellRenderer;
import jaxx.runtime.swing.renderer.EnumTableCellRenderer;
import jaxx.runtime.swing.renderer.I18nTableCellRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.LayerUI;
import org.jdesktop.swingx.JXTreeTable;
import org.nuiton.i18n.I18n;

public class SwingUtil
extends JAXXUtil {
    private static final Log log = LogFactory.getLog(SwingUtil.class);
    public static final String DEFAULT_ICON_PATH = "/icons/";
    public static final String DEFAULT_ICON_PATH_PROPERTY = "default.icon.path";
    private static Field numReaders;
    private static Field notifyingListeners;
    public static final String ICON_PREFIX = "icon.";
    public static final String COLOR_PREFIX = "color.";

    public static Dimension newMinDimension() {
        return new Dimension(0, 0);
    }

    public static Dimension newMaxXDimension() {
        return new Dimension(Short.MAX_VALUE, 0);
    }

    public static Dimension newMaxYDimension() {
        return new Dimension(0, Short.MAX_VALUE);
    }

    public static Dimension newMaxXYDimension() {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    public static void setText(final JTextComponent c, final String text) {
        try {
            AbstractDocument document = (AbstractDocument)c.getDocument();
            if (numReaders == null) {
                numReaders = AbstractDocument.class.getDeclaredField("numReaders");
                numReaders.setAccessible(true);
            }
            if (notifyingListeners == null) {
                notifyingListeners = AbstractDocument.class.getDeclaredField("notifyingListeners");
                notifyingListeners.setAccessible(true);
            }
            if (notifyingListeners.get(document).equals(Boolean.TRUE)) {
                return;
            }
            if ((Integer)numReaders.get(document) > 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!c.getText().equals(text)) {
                            c.setText(text);
                        }
                    }
                });
                return;
            }
            String oldText = c.getText();
            if (oldText == null || !oldText.equals(text)) {
                c.setText(text);
            }
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            c.setText(text);
        }
    }

    public static void fillComboBox(JComboBox combo, Collection<?> data, Object select) {
        ComboBoxModel comboBoxModel = combo.getModel();
        if (comboBoxModel instanceof JaxxDefaultComboBoxModel) {
            JaxxDefaultComboBoxModel model = (JaxxDefaultComboBoxModel)comboBoxModel;
            model.removeListDataListener(combo);
            model.setAllElements(data);
            model.addListDataListener(combo);
            model.setSelectedItem(select);
        } else if (comboBoxModel instanceof DefaultComboBoxModel) {
            DefaultComboBoxModel model = (DefaultComboBoxModel)combo.getModel();
            model.removeListDataListener(combo);
            model.removeAllElements();
            if (data != null) {
                for (Object o : data) {
                    model.addElement(o);
                }
            }
            model.addListDataListener(combo);
            model.setSelectedItem(select);
        } else {
            throw new IllegalArgumentException("this method need a DefaultComboBoxModel for this model but was " + combo.getModel().getClass());
        }
    }

    public static void fillList(JList list, Collection<?> data, Object select) {
        ListModel listModel = list.getModel();
        if (listModel instanceof JaxxDefaultListModel) {
            JaxxDefaultListModel model = (JaxxDefaultListModel)listModel;
            model.setAllElements(data);
            list.setSelectedValue(select, true);
        } else if (listModel instanceof DefaultListModel) {
            DefaultListModel model = (DefaultListModel)listModel;
            model.removeAllElements();
            if (data != null) {
                for (Object o : data) {
                    model.addElement(o);
                }
            }
            list.setSelectedValue(select, true);
        } else {
            throw new IllegalArgumentException("this method need a DefaultListModel for this model but was " + listModel.getClass());
        }
    }

    @Deprecated
    public static void fillComboBox(JAXXComboBox combo, Collection<?> data, Object select, boolean firstNull) {
        ArrayList<Item> items = new ArrayList<Item>();
        if (firstNull) {
            items.add(new Item("null", " ", null, false));
        }
        if (data != null) {
            for (Object d : data) {
                Item item = new Item(d.toString(), d.toString(), d, d.equals(select));
                items.add(item);
            }
        }
        combo.setItems(items);
    }

    public static <O extends Container> O getParentContainer(Object top, Class<O> clazz) {
        return (O)((Container)SwingUtil.getParent(top, clazz));
    }

    public static <O> O getParent(Object top, Class<O> clazz) {
        if (top == null) {
            throw new IllegalArgumentException("top parameter can not be null");
        }
        if (!Container.class.isAssignableFrom(top.getClass())) {
            throw new IllegalArgumentException("top parameter " + top + " is not a " + Container.class);
        }
        Container parent = ((Container)top).getParent();
        if (parent != null && !clazz.isAssignableFrom(parent.getClass())) {
            parent = (Container)SwingUtil.getParent(parent, clazz);
        }
        return (O)parent;
    }

    public static int computeTableColumnWidth(JTable table, Font font, int columnIndex, String suffix) {
        int width = 0;
        if (font == null) {
            font = table.getFont();
        }
        FontMetrics fontMetrics = table.getFontMetrics(font);
        int rowCount = table.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            String key = (String)table.getModel().getValueAt(i, 0);
            int w = fontMetrics.stringWidth(key + suffix);
            if (w <= width) continue;
            width = w;
        }
        return width;
    }

    public static void fixTableColumnWidth(JTable table, int columnIndex, int width) {
        TableColumn column = table.getColumnModel().getColumn(columnIndex);
        column.setMaxWidth(width);
        column.setMinWidth(width);
        column.setWidth(width);
        column.setPreferredWidth(width);
    }

    public static void setTableColumnEditor(JTable table, int columnIndex, TableCellEditor editor) {
        TableColumn column = table.getColumnModel().getColumn(columnIndex);
        column.setCellEditor(editor);
    }

    public static void setTableColumnRenderer(JTable table, int columnIndex, TableCellRenderer editor) {
        TableColumn column = table.getColumnModel().getColumn(columnIndex);
        column.setCellRenderer(editor);
    }

    public static void setI18nTableHeaderRenderer(JTable table, String ... libelles) {
        I18nTableCellRenderer defaultRenderer = new I18nTableCellRenderer(table.getTableHeader().getDefaultRenderer(), libelles);
        table.getTableHeader().setDefaultRenderer(defaultRenderer);
    }

    public static TableCellRenderer newStringTableCellRenderer(final DefaultTableCellRenderer renderer, final int length, final boolean tooltip) {
        return new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                String val;
                renderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                String val2 = val = renderer.getText();
                if (val.length() > length) {
                    val2 = val.substring(0, length - 3) + "...";
                }
                JComponent comp = (JComponent)super.getTableCellRendererComponent(table, val2, isSelected, hasFocus, row, column);
                if (tooltip) {
                    comp.setToolTipText(val);
                }
                return comp;
            }
        };
    }

    public static <V extends JComponent> JXLayer<V> boxComponentWithJxLayer(V component) {
        JXLayer layer = SwingUtil.getLayer(component);
        if (layer != null) {
            return layer;
        }
        layer = new JXLayer();
        layer.setView(component);
        return layer;
    }

    public static List<JComponent> getLayeredComponents(JAXXObject object) {
        ArrayList<JComponent> result = new ArrayList<JComponent>();
        for (Map.Entry<String, Object> child : object.get$objectMap().entrySet()) {
            JComponent comp;
            if (child.getValue() == null) {
                log.warn((Object)("find a null object in $objectMap " + child.getKey()));
                continue;
            }
            if (!JComponent.class.isAssignableFrom(child.getValue().getClass()) || !SwingUtil.isLayered(comp = (JComponent)child.getValue())) continue;
            result.add(comp);
        }
        return result;
    }

    public static <V extends JComponent> JXLayer<V> getLayer(V comp) {
        if (!SwingUtil.isLayered(comp)) {
            return null;
        }
        return (JXLayer)comp.getParent();
    }

    public static void setLayerUI(JComponent comp, LayerUI<JComponent> ui) {
        JXLayer<JComponent> layer = SwingUtil.getLayer(comp);
        layer.setUI(ui);
    }

    public static boolean isLayered(JComponent comp) {
        Container parent = comp.getParent();
        return parent != null && parent instanceof JXLayer;
    }

    public static Map<String, JComponent> lookingForEditor(Class<?> clazz, Container container) {
        HashMap<String, JComponent> result = new HashMap<String, JComponent>();
        try {
            String name;
            HashMap<String, JComponent> allNamedComponent = new HashMap<String, JComponent>();
            LinkedList<Container> todo = new LinkedList<Container>();
            todo.add(container);
            while (todo.size() > 0) {
                ListIterator<Container> i = todo.listIterator();
                while (i.hasNext()) {
                    Container parent = (Container)i.next();
                    i.remove();
                    for (Component c : parent.getComponents()) {
                        if (!(c instanceof Container)) continue;
                        i.add((Container)c);
                        name = c.getName();
                        if (!(c instanceof JComponent) || name == null || "".equals(name)) continue;
                        allNamedComponent.put(name, (JComponent)c);
                    }
                }
            }
            BeanInfo info = Introspector.getBeanInfo(clazz);
            PropertyDescriptor[] props = info.getPropertyDescriptors();
            for (PropertyDescriptor prop : props) {
                name = prop.getName();
                if (!allNamedComponent.containsKey(name)) continue;
                result.put(name, (JComponent)allNamedComponent.get(name));
            }
        }
        catch (IntrospectionException eee) {
            log.warn((Object)"Can't introspect bean", (Throwable)eee);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Result: " + result));
        }
        return result;
    }

    public static void center(Component parent, Component component) {
        if (parent == null) {
            return;
        }
        Rectangle r = parent.getBounds();
        int x = r.x + (r.width - component.getSize().width) / 2;
        int y = r.y + (r.height - component.getSize().height) / 2;
        component.setLocation(x, y);
    }

    public static void initNimbusLoookAndFeel() throws UnsupportedLookAndFeelException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        for (UIManager.LookAndFeelInfo laf : UIManager.getInstalledLookAndFeels()) {
            if (!"Nimbus".equals(laf.getName())) continue;
            UIManager.setLookAndFeel(laf.getClassName());
        }
    }

    public static void loadUIConfig(String defaultUIConfig, String extraUIConfig) throws IOException {
        Properties p = new Properties();
        log.info((Object)("loading default UI config " + defaultUIConfig));
        p.load(SwingUtil.class.getResourceAsStream(defaultUIConfig));
        if (log.isDebugEnabled()) {
            log.debug((Object)p.toString());
        }
        if (extraUIConfig != null) {
            InputStream extraStream = SwingUtil.class.getResourceAsStream(extraUIConfig);
            if (extraStream == null) {
                log.warn((Object)("could not find extraUIConfig : " + extraUIConfig));
            } else {
                log.info((Object)("loading extra UI config " + extraUIConfig));
                Properties p2 = new Properties(p);
                p2.load(extraStream);
                if (log.isDebugEnabled()) {
                    log.debug((Object)p2.toString());
                }
                p.putAll((Map<?, ?>)p2);
            }
        }
        for (Map.Entry<Object, Object> entry : p.entrySet()) {
            String key = (String)entry.getKey();
            if (key.startsWith(ICON_PREFIX)) {
                try {
                    ImageIcon icon = SwingUtil.createImageIcon((String)entry.getValue());
                    UIManager.put(key.substring(ICON_PREFIX.length()), icon);
                }
                catch (Exception e) {
                    log.warn((Object)("could not load icon " + entry.getValue()));
                }
                continue;
            }
            if (!key.startsWith(COLOR_PREFIX)) continue;
            String value = (String)entry.getValue();
            String[] rgb = value.split(",");
            UIManager.put(key.substring(COLOR_PREFIX.length()), new Color(Integer.valueOf(rgb[0]), Integer.valueOf(rgb[1]), Integer.valueOf(rgb[2])));
        }
    }

    public static void loadUIConfig(Properties incoming) {
        for (Map.Entry<Object, Object> entry : incoming.entrySet()) {
            String key = (String)entry.getKey();
            if (key.startsWith(ICON_PREFIX)) {
                try {
                    ImageIcon icon = SwingUtil.createImageIcon((String)entry.getValue());
                    UIManager.put(key.substring(ICON_PREFIX.length()), icon);
                }
                catch (Exception e) {
                    log.warn((Object)("could not load icon " + entry.getValue()));
                }
                continue;
            }
            if (!key.startsWith(COLOR_PREFIX)) continue;
            String value = (String)entry.getValue();
            String[] rgb = value.split(",");
            UIManager.put(key.substring(COLOR_PREFIX.length()), new Color(Integer.valueOf(rgb[0]), Integer.valueOf(rgb[1]), Integer.valueOf(rgb[2])));
        }
    }

    public static TabbedPaneIterator<Component> newTabbedPaneIterator(JTabbedPane tabs) {
        return new TabbedPaneIterator<Component>(false, tabs){

            @Override
            protected Component get(int index, Component comp) {
                return comp;
            }
        };
    }

    public static int[] getSelectedModelRows(JTable table) {
        int[] selectedRows = table.getSelectedRows();
        int length = selectedRows.length;
        int[] result = new int[length];
        for (int i = 0; i < length; ++i) {
            int selectedRow = selectedRows[i];
            result[i] = table.convertRowIndexToModel(selectedRow);
        }
        return result;
    }

    public static int getSelectedModelRow(JTable table) {
        int result = table.getSelectedRow();
        if (result != -1) {
            result = table.convertRowIndexToModel(result);
        }
        return result;
    }

    public static int getSelectedModelColumn(JTable table) {
        int result = table.getSelectedColumn();
        if (result != -1) {
            result = table.convertColumnIndexToModel(result);
        }
        return result;
    }

    public static void setSelectionInterval(JTable table, int rowIndex) {
        int rowViewIndex = table.convertRowIndexToView(rowIndex);
        table.getSelectionModel().setSelectionInterval(rowViewIndex, rowViewIndex);
    }

    public static void addRowSelectionInterval(JTable table, int rowIndex) {
        int rowViewIndex = table.convertRowIndexToView(rowIndex);
        table.getSelectionModel().addSelectionInterval(rowViewIndex, rowViewIndex);
    }

    public static JLabel newLabel(String text, Object iconKey, int aligment) {
        Icon icon = null;
        if (iconKey instanceof Icon) {
            icon = (Icon)iconKey;
        } else if (iconKey instanceof String) {
            icon = SwingUtil.getUIManagerActionIcon((String)iconKey);
        }
        JLabel result = icon == null ? new JLabel(text, aligment) : new JLabel(text, icon, aligment);
        return result;
    }

    public static Component getDeepestObjectAt(Component parent, int x, int y) {
        Container cont;
        Component child;
        if (parent instanceof Container && (child = SwingUtil.findComponentAt(cont = (Container)parent, cont.getWidth(), cont.getHeight(), x, y)) != null && child != cont) {
            if (child instanceof JRootPane) {
                JLayeredPane lp = ((JRootPane)child).getLayeredPane();
                Rectangle b = lp.getBounds();
                child = SwingUtil.getDeepestObjectAt(lp, x - b.x, y - b.y);
            }
            if (child != null) {
                return child;
            }
        }
        return parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Component findComponentAt(Container cont, int width, int height, int x, int y) {
        Object object = cont.getTreeLock();
        synchronized (object) {
            JXLayer layer;
            Rectangle rect;
            Component comp;
            int i;
            if (x < 0 || x >= width || y < 0 || y >= height || !cont.isVisible() || !cont.isEnabled()) {
                return null;
            }
            Component[] component = cont.getComponents();
            int ncomponents = cont.getComponentCount();
            for (i = 0; i < ncomponents; ++i) {
                comp = component[i];
                rect = null;
                if (comp == null || comp.isLightweight()) continue;
                if (rect == null || rect.width == 0 || rect.height == 0) {
                    rect = comp.getBounds();
                }
                if (comp instanceof JXLayer) {
                    layer = (JXLayer)comp;
                    comp = layer.getView();
                }
                if ((comp = comp instanceof Container ? SwingUtil.findComponentAt((Container)comp, rect.width, rect.height, x - rect.x, y - rect.y) : comp.getComponentAt(x - rect.x, y - rect.y)) == null || !comp.isVisible() || !comp.isEnabled()) continue;
                return comp;
            }
            for (i = 0; i < ncomponents; ++i) {
                comp = component[i];
                rect = null;
                if (comp == null || !comp.isLightweight()) continue;
                if (rect == null || rect.width == 0 || rect.height == 0) {
                    rect = comp.getBounds();
                }
                if (comp instanceof JXLayer) {
                    layer = (JXLayer)comp;
                    comp = layer.getView();
                }
                if ((comp = comp instanceof Container ? SwingUtil.findComponentAt((Container)comp, rect.width, rect.height, x - rect.x, y - rect.y) : comp.getComponentAt(x - rect.x, y - rect.y)) == null || !comp.isVisible() || !comp.isEnabled()) continue;
                return comp;
            }
            return cont;
        }
    }

    public static TableCellRenderer newDeleteCellRenderer(DefaultTableCellRenderer renderer) {
        Icon icon = UIManager.getIcon("Table.removeIcon");
        if (icon == null) {
            icon = SwingUtil.createActionIcon("delete");
        }
        return new BooleanCellEditor(renderer, icon);
    }

    public static TableCellRenderer newBooleanTableCellRenderer(TableCellRenderer renderer) {
        return new BooleanCellRenderer(renderer);
    }

    public static TableCellRenderer newBooleanTableCellEditorAndRenderer(TableCellRenderer renderer) {
        return new BooleanCellEditor(renderer);
    }

    public static BooleanCellEditor newBooleanTableCellEditor(TableCellRenderer renderer) {
        return new BooleanCellEditor(renderer);
    }

    public static EmptyNumberTableCellRenderer newEmptyNumberTableCellRenderer(TableCellRenderer renderer) {
        return new EmptyNumberTableCellRenderer(renderer);
    }

    public static <E extends Enum<E>> EnumTableCellRenderer<E> newEnumTableCellRenderer(TableCellRenderer renderer, Class<E> enumClass) {
        return new EnumTableCellRenderer<E>(renderer, enumClass);
    }

    public static void openLink(HyperlinkEvent he) {
        block6: {
            if (he.getEventType() == HyperlinkEvent.EventType.ACTIVATED && Desktop.isDesktopSupported()) {
                try {
                    URL u = he.getURL();
                    if (u.getProtocol().equalsIgnoreCase("mailto") || u.getProtocol().equalsIgnoreCase("http") || u.getProtocol().equalsIgnoreCase("ftp")) {
                        Desktop.getDesktop().browse(u.toURI());
                    }
                }
                catch (IOException e) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"Error while opening link", (Throwable)e);
                    }
                }
                catch (URISyntaxException e) {
                    if (!log.isErrorEnabled()) break block6;
                    log.error((Object)"Error while opening link", (Throwable)e);
                }
            }
        }
    }

    public static void openLink(String url) {
        block4: {
            try {
                if (!Desktop.isDesktopSupported()) {
                    throw new IllegalStateException(I18n._((String)"swing.error.desktop.not.supported", (Object[])new Object[0]));
                }
                Desktop desktop = Desktop.getDesktop();
                if (!desktop.isSupported(Desktop.Action.BROWSE)) {
                    throw new IllegalStateException(I18n._((String)"swing.error.desktop.browse.not.supported", (Object[])new Object[0]));
                }
                URI uri = new URI(url);
                desktop.browse(uri);
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)"Error while opening link", (Throwable)e);
            }
        }
    }

    public static void expandTree(final JTree tree) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int i = 0;
                while (i < tree.getRowCount()) {
                    tree.expandRow(i++);
                }
            }
        });
    }

    public static void expandTreeTable(final JXTreeTable treeTable) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int i = 0;
                while (i < treeTable.getRowCount()) {
                    treeTable.expandRow(i++);
                }
            }
        });
    }

    public static void addExpandOnClickListener(final JTree tree) {
        tree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(final TreeSelectionEvent e) {
                TreeNode node = (TreeNode)e.getPath().getLastPathComponent();
                if (node != null && !node.isLeaf()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            for (TreePath path : e.getPaths()) {
                                if (!e.isAddedPath(path) || tree.isExpanded(path)) continue;
                                log.info((Object)("expand node [" + path + "]"));
                                tree.expandPath(path);
                            }
                        }
                    });
                }
            }
        });
    }

    public static void addExpandOnClickListener(final JXTreeTable treeTable) {
        treeTable.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(final TreeSelectionEvent e) {
                TreeNode node = (TreeNode)e.getPath().getLastPathComponent();
                if (node != null && !node.isLeaf()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            for (TreePath path : e.getPaths()) {
                                if (!e.isAddedPath(path) || treeTable.isExpanded(path)) continue;
                                log.info((Object)("expand node [" + path + "]"));
                                treeTable.expandPath(path);
                            }
                        }
                    });
                }
            }
        });
    }

    public static void setComponentWidth(Component component, int width) {
        component.setSize(width, component.getHeight());
        if (component instanceof JComponent) {
            JComponent jcomponent = (JComponent)component;
            jcomponent.setPreferredSize(new Dimension(width, jcomponent.getPreferredSize().height));
            jcomponent.setMinimumSize(new Dimension(width, jcomponent.getPreferredSize().height));
            if (jcomponent.isDisplayable()) {
                jcomponent.revalidate();
            }
        }
    }

    public static void setComponentHeight(Component component, int height) {
        component.setSize(component.getWidth(), height);
        if (component instanceof JComponent) {
            JComponent jcomponent = (JComponent)component;
            jcomponent.setPreferredSize(new Dimension(jcomponent.getPreferredSize().width, height));
            jcomponent.setMinimumSize(new Dimension(jcomponent.getPreferredSize().width, height));
            if (jcomponent.isDisplayable()) {
                jcomponent.revalidate();
            }
        }
    }

    public static ImageIcon createIcon(String path) {
        URL imgURL = JAXXUtil.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        throw new IllegalArgumentException("could not find icon " + path);
    }

    public static ImageIcon createImageIcon(String path) {
        String iconPath = SwingUtil.getIconPath();
        return SwingUtil.createIcon(iconPath + path);
    }

    public static Icon getUIManagerIcon(String key) {
        return UIManager.getIcon(key);
    }

    public static Icon getUIManagerActionIcon(String key) {
        return SwingUtil.getUIManagerIcon("action." + key);
    }

    public static ImageIcon createActionIcon(String name) {
        String iconPath = SwingUtil.getIconPath();
        return SwingUtil.createIcon(iconPath + "action-" + name + ".png");
    }

    public static ImageIcon createI18nIcon(String name) {
        String iconPath = SwingUtil.getIconPath();
        return SwingUtil.createIcon(iconPath + "i18n/" + name + ".png");
    }

    private static String getIconPath() {
        String iconPath = UIManager.getString(DEFAULT_ICON_PATH_PROPERTY);
        if (iconPath == null) {
            iconPath = DEFAULT_ICON_PATH;
        } else if (!iconPath.endsWith("/")) {
            iconPath = iconPath + "/";
        }
        return iconPath;
    }

    public static void makeTableTabFocusable(final JTable table) {
        table.setCellSelectionEnabled(true);
        table.setSurrendersFocusOnKeystroke(true);
        table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 9) {
                    int selectedColumn = table.getSelectedColumn();
                    int selectedRow = table.getSelectedRow();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Selected was row[" + selectedRow + "] column[" + selectedColumn + "]"));
                    }
                    int columnCount = table.getColumnCount();
                    int rowCount = table.getRowCount();
                    for (int toSelectColumn = selectedColumn; toSelectColumn < columnCount; ++toSelectColumn) {
                        if (!SwingUtil.editCell(table, selectedRow, toSelectColumn)) continue;
                        return;
                    }
                    for (int toSelectRow = selectedRow; toSelectRow < rowCount; ++toSelectRow) {
                        for (int toSelectColumn = 0; toSelectColumn < columnCount; ++toSelectColumn) {
                            if (!SwingUtil.editCell(table, toSelectRow, toSelectColumn)) continue;
                            return;
                        }
                    }
                }
            }
        });
    }

    public static boolean editCell(JTable table, int row, int colummn) {
        boolean result = false;
        if (table.isCellEditable(row, colummn)) {
            if (table.isEditing()) {
                int editingRow = table.getEditingRow();
                int editingColumn = table.getEditingColumn();
                TableCellEditor cellEditor = table.getCellEditor(editingRow, editingColumn);
                cellEditor.stopCellEditing();
            }
            table.setColumnSelectionInterval(colummn, colummn);
            table.setRowSelectionInterval(row, row);
            result = table.editCellAt(row, colummn, new EventObject(table));
            Component component = table.getEditorComponent();
            component.requestFocus();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Select row[" + row + "] column[" + colummn + "] return : " + result));
            }
        }
        return result;
    }

    public static void ensureRowIndex(TableModel model, int rowIndex) throws ArrayIndexOutOfBoundsException {
        if (rowIndex < -1 || rowIndex >= model.getRowCount()) {
            throw new ArrayIndexOutOfBoundsException("the rowIndex was " + rowIndex + ", but should be int [0," + (model.getRowCount() - 1) + "]");
        }
    }

    public static void ensureColumnIndex(TableModel model, int index) throws ArrayIndexOutOfBoundsException {
        if (index < -1 || index >= model.getColumnCount()) {
            throw new ArrayIndexOutOfBoundsException("the columnIndex was " + index + ", but should be int [0," + (model.getColumnCount() - 1) + "]");
        }
    }

    public static void scrollToTableSelection(final JTable table) {
        table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)e.getSource();
                int firstIndex = e.getFirstIndex();
                int lastIndex = e.getLastIndex();
                Integer newSelectedRow = null;
                if (!listSelectionModel.isSelectionEmpty()) {
                    if (listSelectionModel.isSelectedIndex(firstIndex)) {
                        newSelectedRow = firstIndex;
                    } else if (listSelectionModel.isSelectedIndex(lastIndex)) {
                        newSelectedRow = lastIndex;
                    }
                }
                if (newSelectedRow != null) {
                    Rectangle rect = table.getCellRect(newSelectedRow, 0, true);
                    table.scrollRectToVisible(rect);
                }
            }
        });
    }

    public static char getFirstCharAt(String text, char defaultValue) {
        return text == null || text.trim().length() == 0 ? defaultValue : text.charAt(0);
    }

    public static void openLink(URI uri) {
        Desktop desktop = SwingUtil.getDesktopForBrowse();
        try {
            desktop.browse(uri);
        }
        catch (Exception e) {
            throw new RuntimeException(I18n._((String)"application.error.cannot.open.link", (Object[])new Object[]{uri}), e);
        }
    }

    public static Desktop getDesktopForBrowse() {
        if (!Desktop.isDesktopSupported()) {
            throw new RuntimeException(I18n._((String)"application.error.desktop.not.supported", (Object[])new Object[0]));
        }
        Desktop desktop = Desktop.getDesktop();
        if (!desktop.isSupported(Desktop.Action.BROWSE)) {
            throw new RuntimeException(I18n._((String)"application.error.desktop.browse.not.supported", (Object[])new Object[0]));
        }
        return desktop;
    }

    public static abstract class TabbedPaneIterator<O>
    implements Iterator<O> {
        final JTabbedPane tabs;
        boolean reverse;
        int index;
        int increment;

        protected abstract O get(int var1, Component var2);

        public TabbedPaneIterator(boolean reverse, JTabbedPane tabs) {
            this.tabs = tabs;
            this.setReverse(reverse);
        }

        public void reset() {
            this.setReverse(this.reverse);
        }

        public int size() {
            return this.tabs.getTabCount();
        }

        public TabbedPaneIterator<O> reverse() {
            this.setReverse(!this.reverse);
            return this;
        }

        @Override
        public boolean hasNext() {
            return this.reverse ? this.index > 0 : this.index < this.tabs.getTabCount();
        }

        public int getIndex() {
            return this.index;
        }

        @Override
        public O next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Component next = this.tabs.getComponentAt(this.index);
            O result = this.get(this.index, next);
            this.index += this.increment;
            return result;
        }

        @Override
        public void remove() {
            throw new IllegalStateException("not implemented for " + this);
        }

        public String toString() {
            return super.toString() + "< reverse:" + this.reverse + ", index:" + this.index + ", size:" + this.tabs.getTabCount() + " >";
        }

        protected void setReverse(boolean reverse) {
            if (reverse) {
                this.index = this.tabs.getTabCount() - 1;
                this.increment = -1;
            } else {
                this.index = 0;
                this.increment = 1;
            }
            this.reverse = reverse;
        }
    }
}

