// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.data.operation;

/**
 * <p>
 * Opération de peche durant laquelle un prélèvement peut etre
 * effectué, au cours d'une sortie en mer (marée observée en mer,
 * marée enquetée au débarquement, sortie lors d'une campagne à la
 * mer, etc.).
 * </p>
 * <p>
 * Il peut également s'agir d'une séquence de peche, lorsque les
 * dates début/fin ne sont pas connus, et si la zone de peche est
 * unique.
 * </p>
 * <p>
 * Les dates/heures et lat/long de début/fin caractérisent le
 * début/fin de la capture réalisée (hors temps d'établissement de
 * l'engin).
 * </p>
 * <p>
 * REMARQUE : les caractéristiques "indicateur jour/nuit" et
 * "Trajectoire rectiligne ou non" sont présent à ce niveau dans
 * Harmonie, mais gérés dans Allegro via les "cracatéristique
 * d'utilisation du navire" (VesselUseFeatures) rattachée à
 * l'opération parente.
 * </p>
 */
public abstract class FishingOperation
    extends fr.ifremer.adagio.core.dao.data.operation.OperationImpl
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = -5247889332101799215L;

    private java.util.Date fishingStartDateTime;

    /**
     * <p>
     * Date/heure au début du prélèvement.
     * </p>
     * <p>
     * Par exemple, pour le cas d'une opération avec un chalut, il
     * s'agit la date/heure à l'établissement du chalut (le temps de
     * descente n'est pas pris en compte).
     * </p>
     */
    public java.util.Date getFishingStartDateTime()
    {
        return this.fishingStartDateTime;
    }

    public void setFishingStartDateTime(java.util.Date fishingStartDateTime)
    {
        this.fishingStartDateTime = fishingStartDateTime;
    }

    private java.util.Date fishingEndDateTime;

    /**
     * <p>
     * Date/heure à la fin du prélèvement.
     * </p>
     * <p>
     * Par exemple, pour le cas d'une opération avec un chalut, le
     * temps de remontée n'est pas comptabilisé.
     * </p>
     */
    public java.util.Date getFishingEndDateTime()
    {
        return this.fishingEndDateTime;
    }

    public void setFishingEndDateTime(java.util.Date fishingEndDateTime)
    {
        this.fishingEndDateTime = fishingEndDateTime;
    }

    private java.lang.Boolean hasCatch;

    /**
     * <p>
     * Une capture a t elle été prélevée ?
     * </p>
     * <p>
     * Si non, il s'agit d'une opération de peche infructueuse.
     * </p>
     * <p>
     * A priori, si une capture avec quantification différente de 0 est
     * saisie, ou bien si des produits sont rattachés à l'opération,
     * alors hasCapture=true (HAS_CAPTURE=1).
     * </p>
     * <p>
     * Si on ne sait pas si une capture a été réalisée ou non, le champ
     * est laissé vide.
     * </p>
     * <p>
     * Champ utile pour les marées observées au débarquement, pour
     * lesquelles on ne peut pas saisir systématiquement de lot capture
     * ou bien des produits.
     * </p>
     */
    public java.lang.Boolean getHasCatch()
    {
        return this.hasCatch;
    }

    public void setHasCatch(java.lang.Boolean hasCatch)
    {
        this.hasCatch = hasCatch;
    }


    private java.util.Collection<fr.ifremer.adagio.core.dao.data.sample.Sample> samples = new java.util.HashSet<fr.ifremer.adagio.core.dao.data.sample.Sample>();

    /**
     * 
     */
    public java.util.Collection<fr.ifremer.adagio.core.dao.data.sample.Sample> getSamples()
    {
        return this.samples;
    }

    public void setSamples(java.util.Collection<fr.ifremer.adagio.core.dao.data.sample.Sample> samples)
    {
        this.samples = samples;
    }


    private java.util.Collection<fr.ifremer.adagio.core.dao.data.produce.Produce> produces = new java.util.HashSet<fr.ifremer.adagio.core.dao.data.produce.Produce>();

    /**
     * 
     */
    public java.util.Collection<fr.ifremer.adagio.core.dao.data.produce.Produce> getProduces()
    {
        return this.produces;
    }

    public void setProduces(java.util.Collection<fr.ifremer.adagio.core.dao.data.produce.Produce> produces)
    {
        this.produces = produces;
    }


    private fr.ifremer.adagio.core.dao.data.batch.CatchBatch catchBatch;

    /**
     * 
     */
    public fr.ifremer.adagio.core.dao.data.batch.CatchBatch getCatchBatch()
    {
        return this.catchBatch;
    }

    public void setCatchBatch(fr.ifremer.adagio.core.dao.data.batch.CatchBatch catchBatch)
    {
        this.catchBatch = catchBatch;
    }

    /**
     * This entity does not have any identifiers
     * but since it extends the <code>fr.ifremer.adagio.core.dao.data.operation.OperationImpl</code> class
     * it will simply delegate the call up there.
     *
     * @see fr.ifremer.adagio.core.dao.data.operation.Operation#equals(Object)
     */
    public boolean equals(Object object)
    {
        return super.equals(object);
    }

    /**
     * This entity does not have any identifiers
     * but since it extends the <code>fr.ifremer.adagio.core.dao.data.operation.OperationImpl</code> class
     * it will simply delegate the call up there.
     *
     * @see fr.ifremer.adagio.core.dao.data.operation.Operation#hashCode()
     */
    public int hashCode()
    {
        return super.hashCode();
    }

    /**
     * Constructs new instances of {@link fr.ifremer.adagio.core.dao.data.operation.FishingOperation}.
     */
    public static final class Factory
    {
        /**
         * Constructs a new instance of {@link fr.ifremer.adagio.core.dao.data.operation.FishingOperation}.
         */
        public static fr.ifremer.adagio.core.dao.data.operation.FishingOperation newInstance()
        {
            final fr.ifremer.adagio.core.dao.data.operation.FishingOperation entity = new fr.ifremer.adagio.core.dao.data.operation.FishingOperationImpl();
			return entity;
        }

        /**
         * Constructs a new instance of {@link fr.ifremer.adagio.core.dao.data.operation.FishingOperation}, taking all required and/or
         * read-only properties as arguments.
         */
        public static fr.ifremer.adagio.core.dao.data.operation.FishingOperation newInstance(fr.ifremer.adagio.core.dao.referential.QualityFlag qualityFlag, fr.ifremer.adagio.core.dao.data.vessel.Vessel vessel)
        {
            final fr.ifremer.adagio.core.dao.data.operation.FishingOperation entity = newInstance();
            entity.setQualityFlag(qualityFlag);
            entity.setVessel(vessel);
            return entity;
        }

        /**
         * Constructs a new instance of {@link fr.ifremer.adagio.core.dao.data.operation.FishingOperation}, taking all possible properties
         * (except the identifier(s))as arguments.
         */
        public static fr.ifremer.adagio.core.dao.data.operation.FishingOperation newInstance(java.lang.String name, java.lang.Short rankOrderOnPeriod, java.util.Date startDateTime, java.util.Date endDateTime, java.lang.Boolean isMainOperation, java.lang.String position, java.lang.String comments, java.util.Date controlDate, java.util.Date validationDate, java.util.Date qualificationDate, java.lang.String qualificationComments, fr.ifremer.adagio.core.dao.referential.QualityFlag qualityFlag, fr.ifremer.adagio.core.dao.data.vessel.Vessel vessel, java.util.Collection<fr.ifremer.adagio.core.dao.data.operation.OperationVesselAssociation> operationVesselAssociations, java.util.Collection<fr.ifremer.adagio.core.dao.data.vessel.position.VesselPosition> vesselPositions, fr.ifremer.adagio.core.dao.data.vessel.feature.physical.GearPhysicalFeatures gearPhysicalFeatures, java.util.Collection<fr.ifremer.adagio.core.dao.data.vessel.feature.person.VesselPersonFeatures> vesselPersonFeatures, java.util.Collection<fr.ifremer.adagio.core.dao.data.vessel.feature.use.GearUseFeatures> gearUseFeatures, java.util.Collection<fr.ifremer.adagio.core.dao.data.vessel.feature.use.VesselUseFeatures> vesselUseFeatures, fr.ifremer.adagio.core.dao.data.survey.fishingTrip.FishingTrip fishingTrip, java.util.Date fishingStartDateTime, java.util.Date fishingEndDateTime, java.lang.Boolean hasCatch, java.util.Collection<fr.ifremer.adagio.core.dao.data.sample.Sample> samples, java.util.Collection<fr.ifremer.adagio.core.dao.data.produce.Produce> produces, fr.ifremer.adagio.core.dao.data.batch.CatchBatch catchBatch)
        {
            final fr.ifremer.adagio.core.dao.data.operation.FishingOperation entity = newInstance();
            entity.setName(name);
            entity.setRankOrderOnPeriod(rankOrderOnPeriod);
            entity.setStartDateTime(startDateTime);
            entity.setEndDateTime(endDateTime);
            entity.setIsMainOperation(isMainOperation);
            entity.setPosition(position);
            entity.setComments(comments);
            entity.setControlDate(controlDate);
            entity.setValidationDate(validationDate);
            entity.setQualificationDate(qualificationDate);
            entity.setQualificationComments(qualificationComments);
            entity.setQualityFlag(qualityFlag);
            entity.setVessel(vessel);
            entity.setOperationVesselAssociations(operationVesselAssociations);
            entity.setVesselPositions(vesselPositions);
            entity.setGearPhysicalFeatures(gearPhysicalFeatures);
            entity.setVesselPersonFeatures(vesselPersonFeatures);
            entity.setGearUseFeatures(gearUseFeatures);
            entity.setVesselUseFeatures(vesselUseFeatures);
            entity.setFishingTrip(fishingTrip);
            entity.setFishingStartDateTime(fishingStartDateTime);
            entity.setFishingEndDateTime(fishingEndDateTime);
            entity.setHasCatch(hasCatch);
            entity.setSamples(samples);
            entity.setProduces(produces);
            entity.setCatchBatch(catchBatch);
            return entity;
        }
    }
    
// FishingOperation.java merge-point
}