/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.utils.beans.comparators;

import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Comparator;
import java.util.Properties;
import org.andromda.core.common.ClassUtils;
import org.andromda.core.common.ExceptionUtils;
import org.andromda.core.common.Introspector;
import org.andromda.utils.beans.SortCriteria;
import org.andromda.utils.beans.comparators.BeanComparatorException;
import org.andromda.utils.beans.comparators.ComparatorException;
import org.apache.commons.lang.StringUtils;

public class BeanComparator
implements Comparator,
Serializable {
    private static final Properties comparators = new Properties();
    private Comparator comparator = null;
    private SortCriteria sortCriteria;
    private boolean areSameType = false;
    static /* synthetic */ Class class$org$andromda$utils$beans$comparators$BeanComparator;

    public BeanComparator(SortCriteria sortCriteria) {
        ExceptionUtils.checkNull((String)"sortCriteria", (Object)sortCriteria);
        this.sortCriteria = sortCriteria;
    }

    public int compare(Object objectA, Object objectB) {
        String methodName = "BeanComparator.compare";
        ExceptionUtils.checkNull((String)"objectA", (Object)objectA);
        ExceptionUtils.checkNull((String)"objectB", (Object)objectB);
        if (!this.areSameType) {
            if (objectA.getClass() != objectB.getClass()) {
                String errMsg = "BeanComparator.compare - objectA '" + objectA + "' and objectB '" + objectB + " must be of the same type";
                throw new ClassCastException(errMsg);
            }
            this.areSameType = true;
        }
        try {
            Object bValue;
            Object aValue;
            if (this.sortCriteria.getOrdering().equals(SortCriteria.Ordering.DESCENDING)) {
                aValue = this.getProperty(objectB, this.sortCriteria.getSortBy());
                bValue = this.getProperty(objectA, this.sortCriteria.getSortBy());
            } else {
                aValue = this.getProperty(objectA, this.sortCriteria.getSortBy());
                bValue = this.getProperty(objectB, this.sortCriteria.getSortBy());
            }
            int result = 0;
            if (aValue != null || bValue != null) {
                result = aValue == null ? (this.sortCriteria.isNullsFirst() ? -1 : 1) : (bValue == null ? (this.sortCriteria.isNullsFirst() ? 1 : -1) : this.getComparator(aValue.getClass()).compare(aValue, bValue));
            }
            return result;
        }
        catch (Throwable throwable) {
            throw new ComparatorException(throwable);
        }
    }

    private Object getProperty(Object bean, String propertyName) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object value = null;
        if (bean != null && StringUtils.isNotEmpty((String)propertyName)) {
            int index = this.getNestedIndex(propertyName);
            if (index != -1) {
                String simpleProp = propertyName.substring(0, index);
                value = Introspector.instance().getProperty(bean, simpleProp);
                if (value != null && this.getNestedIndex(propertyName) != -1) {
                    propertyName = propertyName.substring(index + 1, propertyName.length());
                    value = this.getProperty(value, propertyName);
                }
            } else {
                value = Introspector.instance().getProperty(bean, propertyName);
            }
        }
        return value;
    }

    private final int getNestedIndex(String propertyName) {
        int index = -1;
        if (StringUtils.isNotEmpty((String)propertyName)) {
            index = propertyName.indexOf(46);
        }
        return index;
    }

    private final Comparator getComparator(Class type) {
        try {
            if (this.comparator == null) {
                String comparatorName = this.findComparatorName(type);
                if (comparatorName != null && comparatorName.length() > 0) {
                    this.comparator = (Comparator)ClassUtils.loadClass((String)comparatorName).newInstance();
                } else {
                    throw new ComparatorException("No comparator defined for the given type '" + type.getName() + "'");
                }
            }
            return this.comparator;
        }
        catch (Throwable throwable) {
            throw new ComparatorException(throwable);
        }
    }

    private String findComparatorName(Class type) {
        String comparatorName = comparators.getProperty(type.getName());
        if ((comparatorName == null || comparatorName.length() == 0) && type.getSuperclass() != null) {
            comparatorName = this.findComparatorName(type.getSuperclass());
        }
        return comparatorName;
    }

    public SortCriteria getSortCriteria() {
        return this.sortCriteria;
    }

    public void setSortCriteria(SortCriteria sortCriteria) {
        ExceptionUtils.checkNull((String)"sortCriteria", (Object)sortCriteria);
        this.sortCriteria = sortCriteria;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            String comparatorsFile = "Comparators.properties";
            URL comparatorsUri = (class$org$andromda$utils$beans$comparators$BeanComparator == null ? (class$org$andromda$utils$beans$comparators$BeanComparator = BeanComparator.class$("org.andromda.utils.beans.comparators.BeanComparator")) : class$org$andromda$utils$beans$comparators$BeanComparator).getResource("Comparators.properties");
            if (comparatorsUri == null) {
                throw new BeanComparatorException("The comparators resource 'Comparators.properties could not be loaded");
            }
            InputStream stream = comparatorsUri.openStream();
            comparators.load(stream);
            stream.close();
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }
}

