/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.validator.bean.list;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.nuiton.i18n.I18n;
import org.nuiton.validator.NuitonValidatorScope;
import org.nuiton.validator.bean.list.BeanListValidator;

public class BeanListValidatorMessage<E extends BeanListValidatorMessage<?>>
implements Comparable<E>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected BeanListValidator<?> validator;
    protected Object bean;
    protected String field;
    protected String message;
    protected NuitonValidatorScope scope;

    public BeanListValidatorMessage(BeanListValidator<?> validator, Object bean, String field, String message, NuitonValidatorScope scope) {
        this.field = field;
        this.bean = bean;
        this.validator = validator;
        this.message = message == null ? null : message.trim();
        this.scope = scope;
    }

    public BeanListValidator<?> getValidator() {
        return this.validator;
    }

    public String getField() {
        return this.field;
    }

    public NuitonValidatorScope getScope() {
        return this.scope;
    }

    public String getMessage() {
        return this.message;
    }

    public Object getBean() {
        return this.bean;
    }

    @Override
    public int compareTo(E o) {
        int result = this.getScope().compareTo(((BeanListValidatorMessage)o).getScope());
        if (result == 0 && (result = this.field.compareTo(((BeanListValidatorMessage)o).field)) == 0) {
            result = this.message.compareTo(((BeanListValidatorMessage)o).message);
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BeanListValidatorMessage)) {
            return false;
        }
        BeanListValidatorMessage that = (BeanListValidatorMessage)o;
        return this.field.equals(that.field) && (this.message != null ? !this.message.equals(that.message) : that.message == null) && this.scope == that.scope;
    }

    public int hashCode() {
        int result = this.field.hashCode();
        result = 31 * result + (this.bean != null ? this.bean.hashCode() : 0);
        result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
        result = 31 * result + (this.scope != null ? this.scope.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.bean + "[" + (Object)((Object)this.scope) + "] - " + this.getI18nError(this.message);
    }

    public String getI18nError(String error) {
        String text;
        if (!error.contains("##")) {
            text = I18n._((String)error, (Object[])new Object[0]);
        } else {
            StringTokenizer stk = new StringTokenizer(error, "##");
            String errorName = stk.nextToken();
            ArrayList<String> args = new ArrayList<String>();
            while (stk.hasMoreTokens()) {
                args.add(stk.nextToken());
            }
            text = I18n._((String)errorName, (Object[])args.toArray());
        }
        return text;
    }
}

