/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.awt.visitor;

import com.google.common.collect.Lists;
import java.awt.Component;
import java.awt.Point;
import java.util.List;
import jaxx.runtime.awt.visitor.ComponentTreeNode;
import jaxx.runtime.awt.visitor.ComponentTreeNodeVisitor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GetCompopentAtPointVisitor
implements ComponentTreeNodeVisitor {
    private static final Log log = LogFactory.getLog(GetCompopentAtPointVisitor.class);
    int currentX;
    int currentY;
    final List<ComponentTreeNode> components = Lists.newArrayList();

    public static Component get(ComponentTreeNode node, Point p) {
        GetCompopentAtPointVisitor v = new GetCompopentAtPointVisitor(p);
        node.visit(v);
        Component result = v.getLastComponent();
        v.components.clear();
        return result;
    }

    public GetCompopentAtPointVisitor(Point p) {
        this.currentX = (int)p.getX();
        this.currentY = (int)p.getY();
    }

    public Component getLastComponent() {
        Component result = null;
        if (!this.components.isEmpty()) {
            ComponentTreeNode node = this.components.get(this.components.size() - 1);
            result = node.getUserObject();
        }
        return result;
    }

    @Override
    public void startNode(ComponentTreeNode node) {
        boolean containsPoint;
        Component component = node.getUserObject();
        Point point = component.getLocation();
        this.currentX -= point.x;
        this.currentY -= point.y;
        if ((node.isRoot() || this.components.contains(node.getParent())) && (containsPoint = component.contains(this.currentX, this.currentY))) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Accept component: " + component));
            }
            this.components.add(node);
        }
    }

    @Override
    public void endNode(ComponentTreeNode componentTree) {
        Point point = componentTree.getUserObject().getLocation();
        this.currentX += point.x;
        this.currentY += point.y;
    }
}

