/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.catches;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.ifremer.tutti.TuttiBusinessException;
import fr.ifremer.tutti.TuttiTechnicalException;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatch;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.AbstractTuttiService;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiServiceContext;
import fr.ifremer.tutti.service.catches.TuttiWeightComputingService;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.xhtmlrenderer.pdf.ITextRenderer;

public class ExportCatchesReportService
extends AbstractTuttiService {
    private static final Log log = LogFactory.getLog(ExportCatchesReportService.class);
    protected Configuration freemarkerConfiguration = new Configuration();
    protected PersistenceService persistenceService;
    protected TuttiWeightComputingService tuttiWeightComputingService;

    public ExportCatchesReportService() {
        this.freemarkerConfiguration.setEncoding(Locale.getDefault(), "UTF-8");
        ClassTemplateLoader templateLoader = new ClassTemplateLoader(ExportCatchesReportService.class, "/ftl");
        this.freemarkerConfiguration.setTemplateLoader((TemplateLoader)templateLoader);
        this.freemarkerConfiguration.setObjectWrapper((ObjectWrapper)new BeansWrapper());
    }

    @Override
    public void setServiceContext(TuttiServiceContext context) {
        super.setServiceContext(context);
        this.persistenceService = this.getService(PersistenceService.class);
        this.tuttiWeightComputingService = this.getService(TuttiWeightComputingService.class);
    }

    public File generatePDFFile(File targetFile, String cruiseId, Locale locale) throws TuttiBusinessException {
        File result = null;
        FileOutputStream os = null;
        HashMap data = Maps.newHashMap();
        List<FishingOperation> allFishingOperation = this.persistenceService.getAllFishingOperation(cruiseId);
        ArrayList operations = Lists.newArrayList();
        for (FishingOperation fishingOperation : allFishingOperation) {
            Map<String, Object> inertLivingNotItemizedCatch;
            String fishingOperationId = fishingOperation.getId();
            boolean withCatchBatch = this.persistenceService.isFishingOperationWithCatchBatch(fishingOperationId);
            if (!withCatchBatch) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)("Skip fishing operation " + fishingOperation + " since no catchBatch associated."));
                continue;
            }
            CatchBatch catchBatch = this.persistenceService.getCatchBatchFromFishingOperation(fishingOperationId);
            BatchContainer<SpeciesBatch> rootSpeciesBatch = this.tuttiWeightComputingService.getComputedSpeciesBatches(fishingOperation);
            BatchContainer<BenthosBatch> rootBenthosBatch = this.tuttiWeightComputingService.getComputedBenthosBatches(fishingOperation);
            this.tuttiWeightComputingService.computeCatchBatchWeights(catchBatch, rootSpeciesBatch, rootBenthosBatch, null);
            Map<String, Object> op = this.createOperation(fishingOperation);
            Float totalWeight = catchBatch.getCatchTotalWeight();
            if (totalWeight == null) {
                totalWeight = catchBatch.getCatchTotalComputedWeight();
            }
            op.put("totalWeight", totalWeight);
            op.put("totalSortedWeight", Float.valueOf(catchBatch.getSpeciesTotalSampleSortedComputedWeight().floatValue() + catchBatch.getBenthosTotalSampleSortedComputedWeight().floatValue()));
            HashMap catches = Maps.newHashMap();
            Float ratio = Float.valueOf((totalWeight.floatValue() - catchBatch.getCatchTotalUnsortedComputedWeight().floatValue()) / catchBatch.getCatchTotalSortedComputedWeight().floatValue());
            Float speciesTotalSortedWeight = catchBatch.getSpeciesTotalSortedWeight();
            if (speciesTotalSortedWeight == null) {
                speciesTotalSortedWeight = catchBatch.getSpeciesTotalSortedComputedWeight();
            }
            Float speciesRatio = Float.valueOf(speciesTotalSortedWeight.floatValue() / catchBatch.getSpeciesTotalSampleSortedComputedWeight().floatValue());
            if (rootSpeciesBatch != null) {
                List speciesBatches = rootSpeciesBatch.getChildren();
                for (SpeciesBatch batch : speciesBatches) {
                    this.createSpeciesCatch(batch, catches, speciesRatio.floatValue() * ratio.floatValue(), totalWeight.floatValue());
                }
            }
            ArrayList catchList = Lists.newArrayList(catches.values());
            Float benthosTotalSortedWeight = catchBatch.getBenthosTotalSortedWeight();
            if (benthosTotalSortedWeight == null) {
                benthosTotalSortedWeight = catchBatch.getBenthosTotalSortedComputedWeight();
            }
            Float benthosRatio = Float.valueOf(benthosTotalSortedWeight.floatValue() / catchBatch.getBenthosTotalSampleSortedComputedWeight().floatValue());
            if (rootBenthosBatch != null && CollectionUtils.isNotEmpty((Collection)rootBenthosBatch.getChildren())) {
                Map<String, Object> benthosCatch = this.createBenthosCatch(rootBenthosBatch, ratio.floatValue() * benthosRatio.floatValue(), totalWeight.floatValue());
                catchList.add(benthosCatch);
            }
            if (((Float)(inertLivingNotItemizedCatch = this.createInertAndLivingNotItemizedCatch(catchBatch, ratio.floatValue() * speciesRatio.floatValue(), ratio.floatValue() * benthosRatio.floatValue(), totalWeight.floatValue())).get("sortedWeight")).floatValue() > 0.0f) {
                catchList.add(inertLivingNotItemizedCatch);
            }
            op.put("catches", catchList);
            operations.add(op);
        }
        data.put("operations", operations);
        try {
            Template mapTemplate = this.freemarkerConfiguration.getTemplate("catchesReport.ftl", locale);
            StringWriter out = new StringWriter();
            mapTemplate.process((Object)data, (Writer)out);
            ((Writer)out).flush();
            os = new FileOutputStream(targetFile);
            ITextRenderer renderer = new ITextRenderer();
            renderer.setDocumentFromString(((Object)out).toString());
            renderer.layout();
            renderer.createPDF((OutputStream)os);
            ((OutputStream)os).close();
        }
        catch (Exception ex) {
            try {
                throw new TuttiTechnicalException(I18n._((String)"tutti.service.operations.exportCatchesReport.error", (Object[])new Object[0]), (Throwable)ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(os);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)os);
        return result;
    }

    protected Map<String, Object> createOperation(FishingOperation fishingOperation) {
        HashMap op = Maps.newHashMap();
        op.put("number", fishingOperation.getFishingOperationNumber());
        op.put("station", fishingOperation.getStationNumber());
        op.put("rigNumber", fishingOperation.getMultirigAggregation());
        op.put("startDate", fishingOperation.getGearShootingStartDate());
        op.put("endDate", fishingOperation.getGearShootingEndDate());
        return op;
    }

    protected void createSpeciesCatch(SpeciesBatch batch, Map<Species, Map<String, Object>> catches, float ratio, float totalWeight) {
        Float existingTotalWeight;
        Float existingSortedWeight;
        Species species = batch.getSpecies();
        HashMap ktch = catches.get(species);
        if (ktch == null) {
            ktch = Maps.newHashMap();
            ktch.put("code", species.getRefTaxCode());
            ktch.put("scientificName", species.getName());
            Species speciesWithVerncularCode = this.persistenceService.getSpeciesByReferenceTaxonIdWithVernacularCode(species.getReferenceTaxonId());
            ktch.put("commonName", speciesWithVerncularCode.getVernacularCode());
            existingSortedWeight = Float.valueOf(0.0f);
            existingTotalWeight = Float.valueOf(0.0f);
        } else {
            existingSortedWeight = (Float)ktch.get("sortedWeight");
            existingTotalWeight = (Float)ktch.get("totalWeight");
        }
        Float weight = batch.getSampleCategoryWeight();
        if (weight == null) {
            weight = batch.getSampleCategoryComputedWeight();
        }
        ktch.put("sortedWeight", Float.valueOf(weight.floatValue() + existingSortedWeight.floatValue()));
        if (this.persistenceService.isVracSpeciesBatch(batch)) {
            weight = Float.valueOf(weight.floatValue() * ratio);
        }
        weight = Float.valueOf(weight.floatValue() + existingTotalWeight.floatValue());
        ktch.put("totalWeight", weight);
        ktch.put("percentage", Float.valueOf(100.0f * weight.floatValue() / totalWeight));
        catches.put(species, ktch);
    }

    protected Map<String, Object> createBenthosCatch(BatchContainer<BenthosBatch> rootBenthosBatch, float ratio, float totalWeight) {
        HashMap ktch = Maps.newHashMap();
        ktch.put("code", I18n._((String)"tutti.service.operations.exportCatchesReport.specialRows.benthos.code", (Object[])new Object[0]));
        ktch.put("scientificName", "");
        ktch.put("commonName", I18n._((String)"tutti.service.operations.exportCatchesReport.specialRows.benthos.name", (Object[])new Object[0]));
        Float sortedWeight = Float.valueOf(0.0f);
        Float benthosTotalWeight = Float.valueOf(0.0f);
        List benthosBatches = rootBenthosBatch.getChildren();
        for (BenthosBatch batch : benthosBatches) {
            Float batchWeight = batch.getSampleCategoryWeight();
            if (batchWeight == null) {
                batchWeight = batch.getSampleCategoryComputedWeight();
            }
            sortedWeight = Float.valueOf(sortedWeight.floatValue() + batchWeight.floatValue());
            if (this.persistenceService.isVracBenthosBatch(batch)) {
                batchWeight = Float.valueOf(batchWeight.floatValue() * ratio);
            }
            benthosTotalWeight = Float.valueOf(benthosTotalWeight.floatValue() + batchWeight.floatValue());
        }
        ktch.put("sortedWeight", sortedWeight);
        ktch.put("totalWeight", benthosTotalWeight);
        ktch.put("percentage", Float.valueOf(100.0f * benthosTotalWeight.floatValue() / totalWeight));
        return ktch;
    }

    protected Map<String, Object> createInertAndLivingNotItemizedCatch(CatchBatch catchBatch, float speciesRatio, float benthosRatio, float totalWeight) {
        Float benthosLivingNotItemizedWeight;
        Float benthosInterWeight;
        Float speciesLivingNotItemizedWeigth;
        HashMap inertLivingNotItemizedCatch = Maps.newHashMap();
        inertLivingNotItemizedCatch.put("code", I18n._((String)"tutti.service.operations.exportCatchesReport.specialRows.inertAndLivinngNotItemized.code", (Object[])new Object[0]));
        inertLivingNotItemizedCatch.put("scientificName", "");
        inertLivingNotItemizedCatch.put("commonName", I18n._((String)"tutti.service.operations.exportCatchesReport.specialRows.inertAndLivinngNotItemized.name", (Object[])new Object[0]));
        Float inertLivingNotItemizedSortedWeight = Float.valueOf(0.0f);
        Float inertLivingNotItemizedTotalWeight = Float.valueOf(0.0f);
        Float speciesInterWeight = catchBatch.getSpeciesTotalInertWeight();
        if (speciesInterWeight == null) {
            speciesInterWeight = catchBatch.getSpeciesTotalInertComputedWeight();
        }
        if (speciesInterWeight != null) {
            inertLivingNotItemizedSortedWeight = Float.valueOf(inertLivingNotItemizedSortedWeight.floatValue() + speciesInterWeight.floatValue());
            inertLivingNotItemizedTotalWeight = Float.valueOf(inertLivingNotItemizedTotalWeight.floatValue() + speciesInterWeight.floatValue() * speciesRatio);
        }
        if ((speciesLivingNotItemizedWeigth = catchBatch.getSpeciesTotalLivingNotItemizedWeight()) == null) {
            speciesLivingNotItemizedWeigth = catchBatch.getSpeciesTotalLivingNotItemizedComputedWeight();
        }
        if (speciesLivingNotItemizedWeigth != null) {
            inertLivingNotItemizedSortedWeight = Float.valueOf(inertLivingNotItemizedSortedWeight.floatValue() + speciesLivingNotItemizedWeigth.floatValue());
            inertLivingNotItemizedTotalWeight = Float.valueOf(inertLivingNotItemizedTotalWeight.floatValue() + speciesLivingNotItemizedWeigth.floatValue() * speciesRatio);
        }
        if ((benthosInterWeight = catchBatch.getBenthosTotalInertWeight()) == null) {
            benthosInterWeight = catchBatch.getBenthosTotalInertComputedWeight();
        }
        if (benthosInterWeight != null) {
            inertLivingNotItemizedSortedWeight = Float.valueOf(inertLivingNotItemizedSortedWeight.floatValue() + benthosInterWeight.floatValue());
            inertLivingNotItemizedTotalWeight = Float.valueOf(inertLivingNotItemizedTotalWeight.floatValue() + benthosInterWeight.floatValue() * benthosRatio);
        }
        if ((benthosLivingNotItemizedWeight = catchBatch.getBenthosTotalLivingNotItemizedWeight()) == null) {
            benthosLivingNotItemizedWeight = catchBatch.getBenthosTotalLivingNotItemizedComputedWeight();
        }
        if (benthosLivingNotItemizedWeight != null) {
            inertLivingNotItemizedSortedWeight = Float.valueOf(inertLivingNotItemizedSortedWeight.floatValue() + benthosLivingNotItemizedWeight.floatValue());
            inertLivingNotItemizedTotalWeight = Float.valueOf(inertLivingNotItemizedTotalWeight.floatValue() + benthosLivingNotItemizedWeight.floatValue() * benthosRatio);
        }
        inertLivingNotItemizedCatch.put("sortedWeight", inertLivingNotItemizedSortedWeight);
        inertLivingNotItemizedCatch.put("totalWeight", inertLivingNotItemizedTotalWeight);
        inertLivingNotItemizedCatch.put("percentage", Float.valueOf(100.0f * inertLivingNotItemizedTotalWeight.floatValue() / totalWeight));
        return inertLivingNotItemizedCatch;
    }
}

