package fr.ifremer.tutti.ui.swing.content.referential;

/*
 * #%L
 * Tutti :: UI
 * $Id: ImportTemporaryPersonAction.java 954 2013-05-16 16:00:37Z kmorin $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-2.3.2/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/referential/ImportTemporaryPersonAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.service.referential.TuttiReferentialImportExportService;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.io.File;

import static org.nuiton.i18n.I18n._;

/**
 * Import temporary person referential.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0
 */
public class ImportTemporaryPersonAction extends AbstractTuttiAction<TuttiUIContext, ManageTemporaryReferentialUI, ManageTemporaryReferentialUIHandler> {

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(ImportTemporaryPersonAction.class);

    private File file;

    public ImportTemporaryPersonAction(ManageTemporaryReferentialUIHandler handler) {
        super(handler, true);
    }

    @Override
    protected boolean prepareAction() throws Exception {

        boolean doAction = super.prepareAction();

        if (doAction) {

            // choose file to import
            file = TuttiUIUtil.chooseFile(
                    getContext().getMainUI(),
                    _("tutti.manageTemporaryReferential.title.choose.importTemporaryPersonFile"),
                    _("tutti.manageTemporaryReferential.action.chooseReferentialPersonFile.import"),
                    "^.*\\.csv", _("tutti.common.file.csv"));

            doAction = file != null;
        }
        return doAction;
    }

    @Override
    protected void releaseAction() {
        file = null;
        super.releaseAction();
    }

    @Override
    protected void doAction() throws Exception {
        Preconditions.checkNotNull(file);
        if (log.isInfoEnabled()) {
            log.info("Will import person temporary " +
                     "referential from file: " + file);
        }

        TuttiReferentialImportExportService service =
                getContext().getTuttiReferentialImportExportService();

        service.importTemporaryPerson(file);

        // reset ui cache
        getDataContext().resetPersons();

    }

    @Override
    public void postSuccessAction() {
        super.postSuccessAction();
        sendMessage(_("tutti.manageTemporaryReferential.action.chooseReferentialPersonFile.import.success", file));
    }
}