/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.config;

import com.opensymphony.xwork2.FileManager;
import com.opensymphony.xwork2.FileManagerFactory;
import com.opensymphony.xwork2.config.Configuration;
import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.config.ContainerProvider;
import com.opensymphony.xwork2.config.PackageProvider;
import com.opensymphony.xwork2.config.impl.DefaultConfiguration;
import com.opensymphony.xwork2.config.providers.XWorkConfigurationProvider;
import com.opensymphony.xwork2.config.providers.XmlConfigurationProvider;
import com.opensymphony.xwork2.inject.Container;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationManager {
    protected static final Logger LOG = LoggerFactory.getLogger(ConfigurationManager.class);
    protected Configuration configuration;
    protected Lock providerLock = new ReentrantLock();
    private List<ContainerProvider> containerProviders = new CopyOnWriteArrayList<ContainerProvider>();
    private List<PackageProvider> packageProviders = new CopyOnWriteArrayList<PackageProvider>();
    protected String defaultFrameworkBeanName;
    private boolean providersChanged = false;

    public ConfigurationManager() {
        this("xwork");
    }

    public ConfigurationManager(String name) {
        this.defaultFrameworkBeanName = name;
    }

    public synchronized Configuration getConfiguration() {
        if (this.configuration == null) {
            this.setConfiguration(this.createConfiguration(this.defaultFrameworkBeanName));
            try {
                this.configuration.reloadContainer(this.getContainerProviders());
            }
            catch (ConfigurationException e) {
                this.setConfiguration(null);
                throw new ConfigurationException("Unable to load configuration.", e);
            }
        } else {
            this.conditionalReload(this.configuration.getContainer());
        }
        return this.configuration;
    }

    protected Configuration createConfiguration(String beanName) {
        return new DefaultConfiguration(beanName);
    }

    public synchronized void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ContainerProvider> getContainerProviders() {
        this.providerLock.lock();
        try {
            if (this.containerProviders.size() == 0) {
                this.containerProviders.add(new XWorkConfigurationProvider());
                this.containerProviders.add(new XmlConfigurationProvider("xwork.xml", false));
            }
            List<ContainerProvider> list = this.containerProviders;
            return list;
        }
        finally {
            this.providerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContainerProviders(List<ContainerProvider> containerProviders) {
        this.providerLock.lock();
        try {
            this.containerProviders = new CopyOnWriteArrayList<ContainerProvider>(containerProviders);
            this.providersChanged = true;
        }
        finally {
            this.providerLock.unlock();
        }
    }

    public void addContainerProvider(ContainerProvider provider) {
        if (!this.containerProviders.contains(provider)) {
            this.containerProviders.add(provider);
            this.providersChanged = true;
        }
    }

    public void clearContainerProviders() {
        for (ContainerProvider containerProvider : this.containerProviders) {
            this.clearContainerProvider(containerProvider);
        }
        this.containerProviders.clear();
        this.providersChanged = true;
    }

    private void clearContainerProvider(ContainerProvider containerProvider) {
        block2: {
            try {
                containerProvider.destroy();
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) break block2;
                LOG.warn("Error while destroying container provider [" + containerProvider + "]", e, new String[0]);
            }
        }
    }

    public synchronized void destroyConfiguration() {
        this.clearContainerProviders();
        this.containerProviders = new CopyOnWriteArrayList<ContainerProvider>();
        if (this.configuration != null) {
            this.configuration.destroy();
        }
        this.configuration = null;
    }

    public synchronized void conditionalReload(Container container) {
        FileManager fileManager = container.getInstance(FileManagerFactory.class).getFileManager();
        if (fileManager.isReloadingConfigs() || this.providersChanged) {
            List<ContainerProvider> providers;
            boolean reload;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Checking ConfigurationProviders for reload.", new String[0]);
            }
            if (!(reload = this.needReloadContainerProviders(providers = this.getContainerProviders()))) {
                reload = this.needReloadPackageProviders();
            }
            if (reload) {
                this.reloadProviders(providers);
            }
            this.providersChanged = false;
        }
    }

    private boolean needReloadPackageProviders() {
        if (this.packageProviders != null) {
            for (PackageProvider provider : this.packageProviders) {
                if (!provider.needsReload()) continue;
                if (LOG.isInfoEnabled()) {
                    LOG.info("Detected package provider " + provider + " needs to be reloaded.  Reloading all providers.", new String[0]);
                }
                return true;
            }
        }
        return false;
    }

    private boolean needReloadContainerProviders(List<ContainerProvider> providers) {
        for (ContainerProvider provider : providers) {
            if (!provider.needsReload()) continue;
            if (LOG.isInfoEnabled()) {
                LOG.info("Detected container provider " + provider + " needs to be reloaded.  Reloading all providers.", new String[0]);
            }
            return true;
        }
        return false;
    }

    private void reloadProviders(List<ContainerProvider> providers) {
        for (ContainerProvider containerProvider : this.containerProviders) {
            try {
                containerProvider.destroy();
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn("error while destroying configuration provider [" + containerProvider + "]", e, new String[0]);
            }
        }
        this.packageProviders = this.configuration.reloadContainer(providers);
    }

    public synchronized void reload() {
        this.packageProviders = this.getConfiguration().reloadContainer(this.getContainerProviders());
    }
}

