/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.benthos;

import com.google.common.collect.Maps;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency.BenthosFrequencyRowModel;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.util.species.EnterMelagWeightDialog;
import java.awt.Component;
import java.awt.Frame;
import java.util.Map;
import javax.swing.JOptionPane;
import jaxx.runtime.SwingUtil;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.i18n.I18n;

public class CreateBenthosMelagAction
extends AbstractTuttiAction<BenthosBatchUIModel, BenthosBatchUI, BenthosBatchUIHandler> {
    protected Map<BenthosBatchRowModel, Float> selectedRows = Maps.newHashMap();
    protected Float melagWeight = null;
    protected Float sampleMelagWeight = null;
    protected Float sortedWeight = null;

    public CreateBenthosMelagAction(BenthosBatchUIHandler handler) {
        super(handler, false);
    }

    @Override
    protected boolean prepareAction() throws Exception {
        boolean result = super.prepareAction();
        int[] selectedRowIndexes = ((BenthosBatchUIHandler)this.handler).getTable().getSelectedRows();
        BenthosBatchTableModel tableModel = ((BenthosBatchUIHandler)this.handler).getTableModel();
        Float alreadyKnownWeights = Float.valueOf(0.0f);
        this.sortedWeight = Float.valueOf(0.0f);
        for (int selectedRowIndex : selectedRowIndexes) {
            BenthosBatchRowModel selectedRow = (BenthosBatchRowModel)tableModel.getEntry(selectedRowIndex);
            Float sampleWeight = null;
            if (selectedRow.getFinestCategory().getNotNullWeight() != null) {
                alreadyKnownWeights = Float.valueOf(alreadyKnownWeights.floatValue() + selectedRow.getFinestCategory().getNotNullWeight().floatValue());
            } else if (selectedRow.getWeight() != null) {
                sampleWeight = selectedRow.getWeight();
            } else {
                sampleWeight = Float.valueOf(0.0f);
                if (selectedRow.getFrequency() != null) {
                    for (BenthosFrequencyRowModel frequency : selectedRow.getFrequency()) {
                        if (frequency.getWeight() == null) {
                            sampleWeight = Float.valueOf(0.0f);
                            break;
                        }
                        sampleWeight = Float.valueOf(sampleWeight.floatValue() + frequency.getWeight().floatValue());
                    }
                }
            }
            if (sampleWeight != null) {
                if (sampleWeight.floatValue() == 0.0f) {
                    JOptionPane.showMessageDialog((Component)this.getUI(), I18n._((String)"tutti.createBenthosMelag.error.message", (Object[])new Object[]{selectedRowIndex + 1}), I18n._((String)"tutti.createBenthosMelag.error.title", (Object[])new Object[0]), 0);
                    ((BenthosBatchUIHandler)this.handler).getTable().getSelectionModel().setSelectionInterval(selectedRowIndex, selectedRowIndex);
                    result = false;
                    break;
                }
                this.sortedWeight = Float.valueOf(this.sortedWeight.floatValue() + sampleWeight.floatValue());
            }
            this.selectedRows.put(selectedRow, sampleWeight);
        }
        if (result) {
            this.melagWeight = this.openMelagWeightDialog();
            if (this.melagWeight != null) {
                this.sampleMelagWeight = Float.valueOf(this.melagWeight.floatValue() - alreadyKnownWeights.floatValue());
            }
        }
        return result && this.melagWeight != null;
    }

    protected Float openMelagWeightDialog() {
        Frame frame = (Frame)SwingUtil.getParentContainer(this.getUI(), Frame.class);
        EnterMelagWeightDialog dialog = new EnterMelagWeightDialog(frame, this.getConfig().getShortcutClosePopup());
        SwingUtil.center((Component)frame, (Component)dialog);
        dialog.pack();
        dialog.setVisible(true);
        Float result = null;
        if (dialog.getEditor().getModel() != null) {
            result = Float.valueOf(dialog.getEditor().getModel().floatValue());
        }
        return result;
    }

    @Override
    protected void doAction() throws Exception {
        for (BenthosBatchRowModel batch : this.selectedRows.keySet()) {
            String comment;
            Float sampleWeight = this.selectedRows.get(batch);
            if (sampleWeight != null) {
                Float weight = Float.valueOf(this.sampleMelagWeight.floatValue() * sampleWeight.floatValue() / this.sortedWeight.floatValue());
                batch.getFinestCategory().setCategoryWeight(weight);
            }
            comment = StringUtils.isBlank((CharSequence)(comment = batch.getComment())) ? "" : comment + "\n";
            comment = comment + "issu d'un MELAG de " + this.melagWeight + "kg";
            batch.setComment(comment);
        }
        ((BenthosBatchUIHandler)this.getHandler()).saveRows(this.selectedRows.keySet());
    }

    @Override
    protected void releaseAction() {
        super.releaseAction();
        this.selectedRows.clear();
        this.melagWeight = null;
        this.sortedWeight = null;
    }

    @Override
    public void postSuccessAction() {
        super.postSuccessAction();
        ((BenthosBatchUIHandler)this.getHandler()).getTable().repaint();
    }
}

