/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service.batch;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import fr.ifremer.adagio.core.dao.data.batch.Batch;
import fr.ifremer.adagio.core.dao.data.batch.CatchBatch;
import fr.ifremer.adagio.core.dao.data.batch.CatchBatchExtendDao;
import fr.ifremer.adagio.core.dao.data.batch.SortingBatch;
import fr.ifremer.adagio.core.dao.data.measure.Measurement;
import fr.ifremer.adagio.core.dao.data.measure.QuantificationMeasurement;
import fr.ifremer.adagio.core.dao.data.measure.SortingMeasurement;
import fr.ifremer.adagio.core.dao.referential.QualityFlag;
import fr.ifremer.adagio.core.dao.referential.QualityFlagImpl;
import fr.ifremer.adagio.core.dao.referential.pmfm.Pmfm;
import fr.ifremer.adagio.core.dao.referential.pmfm.QualitativeValue;
import fr.ifremer.adagio.core.dao.referential.pmfm.QualitativeValueImpl;
import fr.ifremer.adagio.core.dao.referential.taxon.ReferenceTaxon;
import fr.ifremer.adagio.core.dao.referential.taxon.ReferenceTaxonImpl;
import fr.ifremer.tutti.persistence.entities.TuttiBeanFactory;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryEnum;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequency;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicType;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.service.AbstractPersistenceService;
import fr.ifremer.tutti.persistence.service.ReferentialPersistenceService;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Component;

@Component(value="batchPersistenceHelper")
public class BatchPersistenceHelper
extends AbstractPersistenceService {
    private static final Log log = LogFactory.getLog(BatchPersistenceHelper.class);
    public static final String BATCH_PMFM_ID = "pmfmId";
    @Resource(name="referentialPersistenceService")
    protected ReferentialPersistenceService referentialService;
    @Resource(name="catchBatchDao")
    protected CatchBatchExtendDao catchBatchDao;

    public List<SortingBatch> getFrequencyChilds(SortingBatch sortingBatch) {
        ArrayList result = Lists.newArrayList();
        for (Batch batch : sortingBatch.getChildBatchs()) {
            SortingBatch child = (SortingBatch)batch;
            if (!this.isFrequencyBatch(child)) continue;
            result.add(child);
        }
        return result;
    }

    public List<SortingBatch> getNotFrequencyChilds(SortingBatch sortingBatch) {
        ArrayList result = Lists.newArrayList();
        for (Batch batch : sortingBatch.getChildBatchs()) {
            SortingBatch child = (SortingBatch)batch;
            if (!this.isFrequencyBatch(child)) continue;
            result.add(child);
        }
        return result;
    }

    protected boolean isFrequencyBatch(SortingBatch sortingBatch) {
        boolean result = false;
        if (sortingBatch.getSortingMeasurements().size() == 1) {
            SortingMeasurement sm = (SortingMeasurement)sortingBatch.getSortingMeasurements().iterator().next();
            Pmfm pmfm = sm.getPmfm();
            SampleCategoryEnum sampleCategoryByPmfmId = this.enumeration.getSampleCategoryByPmfmId(pmfm.getId());
            result = sampleCategoryByPmfmId == null;
        }
        return result;
    }

    public SpeciesBatch entityToSpeciesBatch(SortingBatch source, SpeciesBatch target) {
        QualityFlag qualityFlag;
        Integer referenceTaxonId;
        SampleCategoryEnum sampleCategory;
        target.setId(source.getId().toString());
        target.setNumber(source.getIndividualCount());
        if (source.getWeight() != null && source.getWeightBeforeSampling() == null) {
            target.setSampleCategoryWeight(source.getWeight());
        } else {
            target.setWeight(source.getWeight());
            target.setSampleCategoryWeight(source.getWeightBeforeSampling());
        }
        target.setComment(source.getComments());
        SortingMeasurement sm = null;
        if (source.getSortingMeasurements().size() == 1) {
            sm = (SortingMeasurement)source.getSortingMeasurements().iterator().next();
        } else if (source.getReferenceTaxon() != null && source.getReferenceTaxon().getId() != null) {
            sm = this.catchBatchDao.getInheritedSortingMeasurement(source, this.enumeration.PMFM_ID_SORTED_UNSORTED);
        }
        if (sm != null && (sampleCategory = this.enumeration.getSampleCategoryByPmfmId(sm.getPmfm().getId())) != null) {
            Integer qualitativeId = null;
            if (sm.getQualitativeValue() != null) {
                qualitativeId = sm.getQualitativeValue().getId();
            }
            this.setSampleCategoryQualitative(target, sm.getPmfm().getId(), sm.getNumericalValue(), sm.getAlphanumericalValue(), qualitativeId);
        }
        if ((referenceTaxonId = source.getInheritedReferenceTaxonId()) == null && source.getReferenceTaxon() != null) {
            referenceTaxonId = source.getReferenceTaxon().getId();
        }
        if (referenceTaxonId != null) {
            Species species = this.referentialService.getSpeciesByReferenceTaxonId(referenceTaxonId);
            target.setSpecies(species);
        }
        if (target.getSampleCategoryType() != null) {
            ArrayList targetChilds = Lists.newArrayList();
            for (Batch batch : source.getChildBatchs()) {
                SortingBatch sourceChild = (SortingBatch)batch;
                SpeciesBatch targetChild = TuttiBeanFactory.newSpeciesBatch();
                this.entityToSpeciesBatch(sourceChild, targetChild);
                if (log.isInfoEnabled()) {
                    log.info((Object)("Loaded CatchBatch Hors Vrac > (Species|Benthos) > " + target.getSpecies().getReferenceTaxonId() + " : " + target.getId()));
                }
                if (targetChild.getSampleCategoryValue() == null) continue;
                targetChilds.add(targetChild);
                targetChild.setParentBatch(target);
            }
            target.setChildBatchs(targetChilds);
        }
        target.setSpeciesToConfirm((qualityFlag = source.getQualityFlag()) != null && this.enumeration.QUALITY_FLAG_CODE_DOUBTFUL.equals(qualityFlag.getCode()));
        return target;
    }

    public void entityToSpeciesBatchFrequency(SortingBatch source, SpeciesBatchFrequency target) {
        target.setId(source.getId());
        target.setNumber(source.getIndividualCount());
        target.setWeight(source.getWeight());
        Preconditions.checkState((source.getSortingMeasurements().size() == 1 ? 1 : 0) != 0, (Object)("SortingBatch [" + source.getId() + "] need exactly one sortingMeasurement (to store the length step category), but had " + source.getSortingMeasurements().size()));
        SortingMeasurement sm = (SortingMeasurement)source.getSortingMeasurements().iterator().next();
        Preconditions.checkNotNull((Object)sm.getPmfm(), (Object)("SortingMeasurement [" + sm.getId() + "] can not have a null pmfm"));
        Preconditions.checkNotNull((Object)sm.getPmfm().getId(), (Object)("SortingMeasurement [" + sm.getId() + "] can not have a pmfm with null id"));
        Caracteristic lengthStepCaracteristic = this.referentialService.getCaracteristic(sm.getPmfm().getId());
        target.setLengthStepCaracteristic(lengthStepCaracteristic);
        target.setLengthStep(sm.getNumericalValue());
    }

    public void speciesBatchToEntity(SpeciesBatch source, SortingBatch target, String parentBatchId, CatchBatch catchBatch, Integer batchPmfm) {
        Integer pmfmId;
        Preconditions.checkNotNull((Object)source.getFishingOperation());
        Preconditions.checkNotNull((Object)source.getFishingOperation().getId());
        Integer recorderDepartmentId = this.getRecorderDepartmentId();
        Collection quantificationMeasurements = target.getQuantificationMeasurements();
        Collection sortingMeasurements = target.getSortingMeasurements();
        HashSet notChangedQuantificationMeasurements = Sets.newHashSet();
        if (quantificationMeasurements != null) {
            notChangedQuantificationMeasurements.addAll(quantificationMeasurements);
        }
        HashSet notChangedSortingMeasurements = Sets.newHashSet();
        if (sortingMeasurements != null) {
            notChangedSortingMeasurements.addAll(sortingMeasurements);
        }
        if (target.getId() == null || target.getRootBatch() == null || target.getParentBatch() != null && !target.getParentBatch().getId().toString().equals(parentBatchId)) {
            this.setBatchParents(source, target, parentBatchId, catchBatch, batchPmfm);
        }
        if (target.getRankOrder() == null) {
            short rankOrder = 1;
            if (source.getParentBatch() != null && source.getParentBatch().getChildBatchs() != null) {
                rankOrder = (short)(rankOrder + (short)source.getParentBatch().getChildBatchs().size());
            } else if (target.getParentBatch() != null && target.getParentBatch().getChildBatchs() != null) {
                rankOrder = (short)(rankOrder + (short)target.getParentBatch().getChildBatchs().size());
            }
            target.setRankOrder(Short.valueOf(rankOrder));
        }
        target.setSubgroupCount(Float.valueOf(1.0f));
        if (source.getWeight() != null || source.getSampleCategoryWeight() != null) {
            if (source.getSampleCategoryWeight() != null && source.getWeight() == null) {
                QuantificationMeasurement quantificationMeasurement = this.catchBatchDao.setQuantificationMeasurement((Batch)target, this.enumeration.PMFM_ID_WEIGHT_MEASURED, recorderDepartmentId, source.getSampleCategoryWeight(), true);
                notChangedQuantificationMeasurements.remove(quantificationMeasurement);
            } else if (source.getWeight() != null && source.getSampleCategoryWeight() == null) {
                QuantificationMeasurement quantificationMeasurement = this.catchBatchDao.setQuantificationMeasurement((Batch)target, this.enumeration.PMFM_ID_WEIGHT_MEASURED, recorderDepartmentId, source.getWeight(), true);
                notChangedQuantificationMeasurements.remove(quantificationMeasurement);
            }
        }
        if (source.getSampleCategoryWeight() == null || source.getWeight() == null) {
            target.setSamplingRatio(null);
            target.setSamplingRatioText(null);
        } else {
            String samplingRatioText = source.getWeight() + "/" + source.getSampleCategoryWeight();
            samplingRatioText = samplingRatioText.replaceAll(",", ".");
            target.setSamplingRatioText(samplingRatioText);
            target.setSamplingRatio(Float.valueOf(source.getWeight().floatValue() / source.getSampleCategoryWeight().floatValue()));
            QuantificationMeasurement quantificationMeasurement = this.catchBatchDao.setQuantificationMeasurement((Batch)target, this.enumeration.PMFM_ID_WEIGHT_MEASURED, recorderDepartmentId, source.getWeight(), true);
            notChangedQuantificationMeasurements.remove(quantificationMeasurement);
        }
        if (source.getSampleCategoryType() != null && source.getSampleCategoryValue() != null && !(pmfmId = source.getSampleCategoryType().getFieldValue()).equals(this.enumeration.PMFM_ID_SORTED_UNSORTED)) {
            SortingMeasurement sortingMeasurement = this.setSortingMeasurement(target, recorderDepartmentId, source.getSampleCategoryType(), source.getSampleCategoryValue());
            notChangedSortingMeasurements.remove(sortingMeasurement);
        }
        target.setIndividualCount(source.getNumber());
        ReferenceTaxon referenceTaxon = source.getSpecies() == null || parentBatchId != null ? null : (ReferenceTaxon)this.load(ReferenceTaxonImpl.class, source.getSpecies().getReferenceTaxonId());
        target.setReferenceTaxon(referenceTaxon);
        String qualityFlag = source.isSpeciesToConfirm() ? this.enumeration.QUALITY_FLAG_CODE_DOUBTFUL : this.enumeration.QUALITY_FLAG_CODE_NOT_QUALIFIED;
        target.setQualityFlag((QualityFlag)this.load(QualityFlagImpl.class, (Serializable)((Object)qualityFlag)));
        target.setComments(source.getComment());
        target.setExhaustiveInventory(Boolean.valueOf(true));
        if (quantificationMeasurements != null) {
            quantificationMeasurements.removeAll(notChangedQuantificationMeasurements);
        }
        if (sortingMeasurements != null) {
            sortingMeasurements.removeAll(notChangedSortingMeasurements);
        }
    }

    protected void setBatchParents(SpeciesBatch source, SortingBatch target, String parentBatchIdStr, CatchBatch catchBatch, Integer batchPmfmId) {
        SortingBatch parentBatch;
        Preconditions.checkNotNull((Object)target);
        Preconditions.checkNotNull((Object)source.getFishingOperation());
        Preconditions.checkNotNull((Object)source.getFishingOperation().getId());
        if (parentBatchIdStr != null) {
            parentBatch = this.catchBatchDao.getSortingBatchById(catchBatch, Integer.valueOf(parentBatchIdStr));
        } else {
            Integer pmfmId = source.getSampleCategoryType().getFieldValue();
            if (pmfmId == null || !pmfmId.equals(this.enumeration.PMFM_ID_SORTED_UNSORTED)) {
                throw new DataIntegrityViolationException(MessageFormat.format("A species batch with no parent should have a sampleCategoryType {0} (PMFM.ID={1})", SampleCategoryEnum.sortedUnsorted.name(), this.enumeration.PMFM_ID_SORTED_UNSORTED));
            }
            Integer qualitativeValueId = this.convertSampleCategoryValueIntoQualitativeId(source.getSampleCategoryValue());
            parentBatch = this.catchBatchDao.getSortingBatch(catchBatch.getChildBatchs(), new Object[]{BATCH_PMFM_ID, pmfmId, qualitativeValueId, BATCH_PMFM_ID, this.enumeration.PMFM_ID_SORTING_TYPE, batchPmfmId, BATCH_PMFM_ID, this.enumeration.PMFM_ID_SORTING_TYPE_2, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_2_ALIVE_ITEMIZED});
        }
        if (parentBatch == null) {
            throw new DataIntegrityViolationException("Could not retrieve parent batch, for a given speciesBatch : invalid batch tree structure. Please make sure CatchBatch has been saved before to create a SpeciesBatch.");
        }
        target.setParentBatch((Batch)parentBatch);
        target.setRootBatch(catchBatch);
    }

    public void speciesBatchFrequencyToEntity(SpeciesBatchFrequency source, SortingBatch target, SortingBatch parentBatch, short rankOrder) {
        Preconditions.checkNotNull((Object)source.getBatch());
        Preconditions.checkNotNull((Object)source.getBatch().getId());
        Integer recorderDepartmentId = this.getRecorderDepartmentId();
        Collection quantificationMeasurements = target.getQuantificationMeasurements();
        Collection sortingMeasurements = target.getSortingMeasurements();
        HashSet notChangedQuantificationMeasurements = Sets.newHashSet();
        if (quantificationMeasurements != null) {
            notChangedQuantificationMeasurements.addAll(quantificationMeasurements);
        }
        HashSet notChangedSortingMeasurements = Sets.newHashSet();
        if (sortingMeasurements != null) {
            notChangedSortingMeasurements.addAll(sortingMeasurements);
        }
        if (target.getId() == null || target.getRootBatch() == null || target.getParentBatch() != null && !target.getParentBatch().getId().equals(parentBatch.getId())) {
            target.setParentBatch((Batch)parentBatch);
            target.setRootBatch(parentBatch.getRootBatch());
        }
        target.setRankOrder(Short.valueOf(rankOrder));
        if (source.getWeight() != null) {
            QuantificationMeasurement quantificationMeasurement = this.catchBatchDao.setQuantificationMeasurement((Batch)target, this.enumeration.PMFM_ID_WEIGHT_MEASURED, recorderDepartmentId, source.getWeight(), true);
            notChangedQuantificationMeasurements.remove(quantificationMeasurement);
        }
        if (source.getLengthStepCaracteristic() != null && source.getLengthStep() != null) {
            Integer pmfmId = source.getLengthStepCaracteristic().getIdAsInt();
            SortingMeasurement sortingMeasurement = this.setSortingMeasurement(target, recorderDepartmentId, pmfmId, (Serializable)source.getLengthStep());
            notChangedSortingMeasurements.remove(sortingMeasurement);
        }
        target.setIndividualCount(source.getNumber());
        target.setReferenceTaxon(null);
        target.setQualityFlag(parentBatch.getQualityFlag());
        target.setExhaustiveInventory(Boolean.valueOf(true));
        if (quantificationMeasurements != null) {
            quantificationMeasurements.removeAll(notChangedQuantificationMeasurements);
        }
        if (sortingMeasurements != null) {
            sortingMeasurements.removeAll(notChangedSortingMeasurements);
        }
    }

    protected Integer convertSampleCategoryValueIntoQualitativeId(Serializable value) {
        if (value == null) {
            return null;
        }
        Integer qualitativeValueId = null;
        if (value instanceof CaracteristicQualitativeValue) {
            CaracteristicQualitativeValue cqValue = (CaracteristicQualitativeValue)value;
            qualitativeValueId = cqValue.getIdAsInt();
        } else if (value instanceof String) {
            qualitativeValueId = Integer.valueOf((String)((Object)value));
        }
        return qualitativeValueId;
    }

    protected void setSampleCategoryQualitative(SpeciesBatch target, Integer pmfmId, Float numericalvalue, String alphanumericalValue, Integer qualitativeValueId) {
        if (pmfmId == null || pmfmId.equals(this.enumeration.PMFM_ID_SORTING_TYPE)) {
            return;
        }
        SampleCategoryEnum sampleCategory = this.enumeration.getSampleCategoryByPmfmId(pmfmId);
        Preconditions.checkNotNull((Object)sampleCategory, (Object)("Unable to find corresponding SampleCategoryEnum for PMFM.ID : " + pmfmId));
        target.setSampleCategoryType(sampleCategory);
        if (numericalvalue != null) {
            target.setSampleCategoryValue(numericalvalue);
            return;
        }
        if (alphanumericalValue != null) {
            target.setSampleCategoryValue((Serializable)((Object)alphanumericalValue));
            return;
        }
        Caracteristic caracteristic = this.referentialService.getCaracteristic(pmfmId);
        if (caracteristic == null || caracteristic.getCaracteristicType() != CaracteristicType.QUALITATIVE) {
            return;
        }
        CaracteristicQualitativeValue value = null;
        for (CaracteristicQualitativeValue qv : caracteristic.getQualitativeValue()) {
            if (!qualitativeValueId.equals(qv.getIdAsInt())) continue;
            value = qv;
            break;
        }
        target.setSampleCategoryValue(value);
    }

    public Integer getRecorderDepartmentId() {
        return this.enumeration.DEPARTMENT_ID_UNKNOWN_RECORDER_DEPARTMENT;
    }

    public void setMeasurement(Measurement measurement, Caracteristic caracteristic, Serializable value) {
        if (caracteristic.getCaracteristicType() == CaracteristicType.TEXT) {
            measurement.setAlphanumericalValue((String)((Object)value));
        } else if (caracteristic.getCaracteristicType() == CaracteristicType.NUMBER) {
            measurement.setNumericalValue((Float)value);
        } else if (caracteristic.getCaracteristicType() == CaracteristicType.QUALITATIVE) {
            Integer qvId = value instanceof CaracteristicQualitativeValue ? ((CaracteristicQualitativeValue)value).getIdAsInt() : (value instanceof Integer ? (Integer)value : Integer.valueOf(value.toString()));
            QualitativeValue qv = (QualitativeValue)this.load(QualitativeValueImpl.class, qvId);
            measurement.setQualitativeValue(qv);
        }
    }

    public SortingMeasurement setSortingMeasurement(SortingBatch sortingBatch, Integer recorderDepartmentId, SampleCategoryEnum sampleCategory, Serializable value) {
        Preconditions.checkNotNull((Object)sampleCategory);
        Preconditions.checkNotNull((Object)value);
        Integer pmfmId = sampleCategory.getFieldValue();
        Caracteristic caracteristic = this.referentialService.getCaracteristic(pmfmId);
        SortingMeasurement sortingMeasurement = this.catchBatchDao.getSortingMeasurement(sortingBatch, pmfmId, recorderDepartmentId, true);
        this.setMeasurement((Measurement)sortingMeasurement, caracteristic, value);
        return sortingMeasurement;
    }

    public SortingMeasurement setSortingMeasurement(SortingBatch sortingBatch, Integer recorderDepartmentId, Integer pmfmId, Serializable value) {
        Preconditions.checkNotNull((Object)pmfmId);
        Preconditions.checkNotNull((Object)value);
        Caracteristic caracteristic = this.referentialService.getCaracteristic(pmfmId);
        SortingMeasurement sortingMeasurement = this.catchBatchDao.getSortingMeasurement(sortingBatch, pmfmId, recorderDepartmentId, true);
        this.setMeasurement((Measurement)sortingMeasurement, caracteristic, value);
        return sortingMeasurement;
    }
}

