/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.referential.location;

import fr.ifremer.adagio.core.dao.referential.location.LocationDaoBase;
import fr.ifremer.adagio.core.dao.referential.location.LocationExtendDao;
import java.util.ArrayList;
import java.util.Iterator;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.stereotype.Repository;

@Repository(value="locationDao")
public class LocationDaoImpl
extends LocationDaoBase
implements LocationExtendDao {
    private static final String QUERY_LOCATION_ID_BY_LABEL_AND_LOCATION_LEVEL_IDS = "selectLocationIdByLabelAndLocationLevel";

    @Autowired
    public LocationDaoImpl(SessionFactory sessionFactory) {
        this.setSessionFactory(sessionFactory);
    }

    @Override
    public String getLocationLabelByLatLong(Float latitude, Float longitude) {
        if (longitude == null || latitude == null) {
            return null;
        }
        String locationLabel = null;
        if (longitude.floatValue() >= 0.0f && longitude.floatValue() < 42.0f && latitude.floatValue() >= 30.0f && (double)latitude.floatValue() < 47.5 || longitude.floatValue() >= -6.0f && longitude.floatValue() < 0.0f && latitude.floatValue() >= 35.0f && latitude.floatValue() < 40.0f) {
            double nbdemidegreeLat = Math.floor(latitude.floatValue() - 30.0f) * 2.0;
            double nbdemidegreeLong = Math.floor(longitude.floatValue() + 6.0f) * 2.0;
            char letter = new Character((char)(Math.floor(nbdemidegreeLong / 10.0) + 65.0)).charValue();
            int rest = (int)(nbdemidegreeLong % 10.0);
            locationLabel = "M" + String.valueOf((int)nbdemidegreeLat) + letter + String.valueOf(rest);
        } else if (longitude.floatValue() >= -50.0f && longitude.floatValue() <= 70.0f && latitude.floatValue() >= 36.0f && latitude.floatValue() <= 89.0f) {
            int halfDegreesNb = (int)Math.floor((latitude.floatValue() - 36.0f) * 2.0f) + 1;
            double degreesNb = Math.floor(longitude.floatValue() + 50.0f);
            char letter = new Character((char)(Math.floor(degreesNb / 10.0) + 65.0)).charValue();
            int rest = (int)(degreesNb % 10.0);
            locationLabel = String.valueOf(halfDegreesNb) + letter + String.valueOf(rest);
        }
        return locationLabel;
    }

    @Override
    public Integer getLocationIdByLabelAndLocationLevel(String locationLabel, Integer[] locationLevelIds) {
        this.logger.debug((Object)"call getLocationIdByLabelAndLocationLevel()");
        try {
            Query query = null;
            query = this.getSession(false).getNamedQuery(QUERY_LOCATION_ID_BY_LABEL_AND_LOCATION_LEVEL_IDS);
            query.setString("locationLabel", locationLabel);
            query.setParameterList("locationLevelIds", (Object[])locationLevelIds);
            ArrayList<Integer> locationIds = new ArrayList<Integer>();
            Iterator iterator = query.iterate();
            while (iterator.hasNext()) {
                Integer locationId = (Integer)iterator.next();
                locationIds.add(locationId);
            }
            if (locationIds.size() == 0) {
                return null;
            }
            if (locationIds.size() > 1) {
                throw new DataRetrievalFailureException("Too many locations found, for label : " + locationLabel);
            }
            return (Integer)locationIds.get(0);
        }
        catch (RuntimeException re) {
            this.logger.error((Object)"getLocationIdByLabelAndLocationLevel failed", (Throwable)re);
            throw re;
        }
    }
}

