package fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency;

/*
 * #%L
 * Tutti :: UI
 * $Id: SpeciesFrequencyUIModel.java 715 2013-04-01 20:46:21Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.3/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/catches/species/frequency/SpeciesFrequencyUIModel.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableUIModel;

import java.util.List;

/**
 * @author tchemit <chemit@codelutin.com>
 * @since 0.2
 */
public class SpeciesFrequencyUIModel extends AbstractTuttiTableUIModel<SpeciesBatchRowModel, SpeciesFrequencyRowModel, SpeciesFrequencyUIModel> {

    private static final long serialVersionUID = 1L;

    public static final String PROPERTY_CONFIGURATION_MODE = "configurationMode";

    public static final String PROPERTY_STEP = "step";

    private static final String PROPERTY_MIN_STEP = "minStep";

    private static final String PROPERTY_MAX_STEP = "maxStep";

    public static final String PROPERTY_CAN_GENERATE = "canGenerate";

    public static final String PROPERTY_SIMPLE_MODE = "simpleMode";

    public static final String PROPERTY_AUTO_GEN_MODE = "autoGenMode";

    public static final String PROPERTY_RAFALE_MODE = "rafaleMode";

    public static final String PROPERTY_SIMPLE_COUNTING_MODE = "simpleCountingMode";

    public static final String PROPERTY_SIMPLE_COUNT = "simpleCount";

    public static final String PROPERTY_LENGHT_STEP_CARACTERISTIC = "lengthStepCaracteristic";

    public static enum ConfigurationMode {
        SIMPLE,
        AUTO_GEN,
        RAFALE,
        SIMPLE_COUNTING
    }

    /**
     * Fill mode.
     *
     * @since 0.2
     */
    protected ConfigurationMode configurationMode;

    /**
     * Batch that contains frequencies.
     *
     * @since 0.2
     */
    protected SpeciesBatchRowModel batch;

    /**
     * Default step to increment length step.
     *
     * @since 0.2
     */
    protected float step;

    /**
     * Min step to auto generate length steps.
     *
     * @since 0.2
     */
    protected Float minStep;

    /**
     * Max step to auto generate length steps.
     *
     * @since 0.2
     */
    protected Float maxStep;

    /**
     * Length step caracteristic.
     *
     * @since 0.3
     */
    protected Caracteristic lengthStepCaracteristic;

    /**
     * Number in case of simple counting mode
     *
     * @since 1.0
     */
    protected Integer simpleCount;

    public SpeciesFrequencyUIModel() {
        super(SpeciesBatchRowModel.class, null, null);
    }

    public ConfigurationMode getConfigurationMode() {
        return configurationMode;
    }

    public void setConfigurationMode(ConfigurationMode configurationMode) {
        Object oldValue = getConfigurationMode();
        this.configurationMode = configurationMode;
        firePropertyChange(PROPERTY_CONFIGURATION_MODE, oldValue, configurationMode);
        firePropertyChange(PROPERTY_SIMPLE_MODE, null, isSimpleMode());
        firePropertyChange(PROPERTY_AUTO_GEN_MODE, null, isAutoGenMode());
        firePropertyChange(PROPERTY_RAFALE_MODE, null, isRafaleMode());
        firePropertyChange(PROPERTY_SIMPLE_COUNTING_MODE, null, isSimpleCountingMode());
    }

    public float getStep() {
        return step;
    }

    public void setStep(float step) {
        Object oldValue = getStep();
        this.step = step;
        firePropertyChange(PROPERTY_STEP, oldValue, step);
    }

    public Caracteristic getLengthStepCaracteristic() {
        return lengthStepCaracteristic;
    }

    public void setLengthStepCaracteristic(Caracteristic lengthStepCaracteristic) {
        Object oldValue = getLengthStepCaracteristic();
        this.lengthStepCaracteristic = lengthStepCaracteristic;
        firePropertyChange(PROPERTY_LENGHT_STEP_CARACTERISTIC, oldValue, lengthStepCaracteristic);
        firePropertyChange(PROPERTY_CAN_GENERATE, null, isCanGenerate());
    }

    public Float getMinStep() {
        return minStep;
    }

    public void setMinStep(Float minStep) {
        Object oldValue = getMinStep();
        this.minStep = minStep;
        firePropertyChange(PROPERTY_MIN_STEP, oldValue, minStep);
        firePropertyChange(PROPERTY_CAN_GENERATE, null, isCanGenerate());
    }

    public Float getMaxStep() {
        return maxStep;
    }

    public void setMaxStep(Float maxStep) {
        Object oldValue = getMaxStep();
        this.maxStep = maxStep;
        firePropertyChange(PROPERTY_MAX_STEP, oldValue, maxStep);
        firePropertyChange(PROPERTY_CAN_GENERATE, null, isCanGenerate());
    }

    public Integer getSimpleCount() {
        return simpleCount;
    }

    public void setSimpleCount(Integer simpleCount) {
        Object oldValue = getSimpleCount();
        this.simpleCount = simpleCount;
        firePropertyChange(PROPERTY_SIMPLE_COUNT, oldValue, simpleCount);
    }

    public boolean isSimpleMode() {
        return ConfigurationMode.SIMPLE == configurationMode;
    }

    public boolean isAutoGenMode() {
        return ConfigurationMode.AUTO_GEN == configurationMode;
    }

    public boolean isRafaleMode() {
        return ConfigurationMode.RAFALE == configurationMode;
    }

    public boolean isSimpleCountingMode() {
        return ConfigurationMode.SIMPLE_COUNTING == configurationMode;
    }

    public boolean isCanGenerate() {
        return minStep != null && maxStep != null && maxStep > minStep && lengthStepCaracteristic != null;
    }

    public SpeciesBatchRowModel getBatch() {
        return batch;
    }

    public void setBatch(SpeciesBatchRowModel batch) {
        this.batch = batch;
    }

    public float getLengthStep(float lengthStep) {
        int intValue = (int) (lengthStep * 10);
        int intStep = (int) (step * 10);
        int correctIntStep = intValue - (intValue % intStep);
        float result = correctIntStep / 10f;
        return result;
    }

    public boolean isOneRowValid() {
        boolean result = getRowCount() > 0;
        if (result) {
            result = false;
            for (SpeciesFrequencyRowModel row : rows) {
                if (row.isValid()) {
                    result = true;
                    break;
                }
            }
        }
        return result;
    }

    // method with an argument for the binding
    public boolean isOneRowValid(List<SpeciesFrequencyRowModel> frequencies) {
        return isOneRowValid();
    }

    @Override
    protected SpeciesBatchRowModel newEntity() {
        return new SpeciesBatchRowModel();
    }
}
