package fr.ifremer.tutti.ui.swing.content.db;

/*
 * #%L
 * Tutti :: UI
 * $Id: CloseDbAction.java 629 2013-03-15 09:48:31Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.3/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/db/CloseDbAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.TuttiIOUtil;
import fr.ifremer.tutti.persistence.config.TuttiPersistenceConfig;
import fr.ifremer.tutti.ui.swing.TuttiScreen;
import fr.ifremer.tutti.ui.swing.content.AbstractChangeScreenAction;
import fr.ifremer.tutti.ui.swing.content.MainUIHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import static org.nuiton.i18n.I18n._;

/**
 * To close db attached to Tutti.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0
 */
public class CloseDbAction extends AbstractChangeScreenAction {

    /** Logger. */
    private static final Log log = LogFactory.getLog(CloseDbAction.class);

    public CloseDbAction(MainUIHandler handler) {
        super(handler, true, TuttiScreen.MANAGE_DB);
    }

    String jdbcUrl;

    @Override
    protected void doAction() {

        if (log.isInfoEnabled()) {
            log.info("Will close db...");
        }

        jdbcUrl = TuttiPersistenceConfig.getInstance().getJdbcUrl();

        // clear all caches
        getContext().getPersistenceService().clearAllCaches();

        // set to not reload a real db
        getContext().setDbLoaded(false);

        // close services + repon a fake persistence service
        getHandler().reloadPersistenceService();

        // clean db context
        getContext().clearDbContext();

        TuttiIOUtil.deleteDirectory(
                getConfig().getServiceConfig().getPersistenceConfig().getCacheDirectory(),
                "Could not delete cache directory");
    }

    @Override
    public void postSuccessAction() {

        sendMessage(_("tutti.flash.info.db.closed", jdbcUrl));

        // make sure title is reloaded
        getUI().getHandler().changeTitle();
    }
}