/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util.csv;

import java.util.LinkedList;
import java.util.List;
import org.nuiton.util.csv.Column;
import org.nuiton.util.csv.Common;
import org.nuiton.util.csv.CsvModel;
import org.nuiton.util.csv.ExportableColumn;
import org.nuiton.util.csv.ImportableColumn;
import org.nuiton.util.csv.ValueFormatter;
import org.nuiton.util.csv.ValueGetter;
import org.nuiton.util.csv.ValueParser;
import org.nuiton.util.csv.ValueSetter;

public class MyModelBuilder<E> {
    protected char separator;
    protected List<ImportableColumn<E, Object>> columnsForImport = new LinkedList<ImportableColumn<E, Object>>();
    protected List<ExportableColumn<E, Object>> columnsForExport = new LinkedList<ExportableColumn<E, Object>>();

    public BuildOrAddColumnStep newEmptyModel(char separator) {
        this.separator = separator;
        return new BuildOrAddColumnStep();
    }

    public class AddColumnStep<E> {
        protected ImportableColumn<E, Object> importableColumn;
        protected ExportableColumn<E, Object> exportableColumn;

        public AddColumnStep(ImportableColumn<E, Object> importableColumn, ExportableColumn<E, Object> exportableColumn) {
            this.importableColumn = importableColumn;
            this.exportableColumn = exportableColumn;
        }

        public BuildOrAddColumnStep<E> add() {
            return this.addIf(true);
        }

        public BuildOrAddColumnStep<E> addIf(boolean condition) {
            if (condition) {
                MyModelBuilder.this.columnsForImport.add(this.importableColumn);
                MyModelBuilder.this.columnsForExport.add(this.exportableColumn);
            }
            return new BuildOrAddColumnStep();
        }
    }

    public class ChooseExportStrategyForColumnStep<E> {
        protected String columnName;
        protected Column<E, Object> importableColumn;

        public ChooseExportStrategyForColumnStep(String columnName, Column<E, Object> importableColumn) {
            this.columnName = columnName;
            this.importableColumn = importableColumn;
        }

        public AddColumnStep<E> ignoredAtExport() {
            Column exportableColumn = Column.newExportableColumn(this.columnName, null, null, true);
            return new AddColumnStep<E>(this.importableColumn, exportableColumn);
        }

        public AddColumnStep<E> writeAtExport(String propertyName) {
            return this.writeAtExport(propertyName, Common.STRING);
        }

        public AddColumnStep<E> writeAtExport(ValueGetter<E, String> valueGetter) {
            return this.writeAtExport(valueGetter, Common.STRING);
        }

        public <T> AddColumnStep<E> writeAtExport(String propertyName, ValueFormatter<T> valueFormatter) {
            return this.writeAtExport(new Common.BeanProperty(propertyName), valueFormatter);
        }

        public <T> AddColumnStep<E> writeAtExport(ValueGetter<E, T> valueGetter, ValueFormatter<T> valueFormatter) {
            Column<E, T> exportableColumn = Column.newExportableColumn(this.columnName, valueGetter, valueFormatter, false);
            return new AddColumnStep<E>(this.importableColumn, exportableColumn);
        }
    }

    public class ChooseImportStrategyForColumnStep<E> {
        protected String columnName;

        public ChooseImportStrategyForColumnStep(String columnName) {
            this.columnName = columnName;
        }

        public ChooseExportStrategyForColumnStep<E> ignoreAtImport() {
            Column importableColumn = Column.newImportableColumn(this.columnName, null, null, true);
            return new ChooseExportStrategyForColumnStep(this.columnName, importableColumn);
        }

        public ChooseExportStrategyForColumnStep<E> mandatoryAtImport(String propertyName) {
            return this.mandatoryAtImport(propertyName, Common.STRING);
        }

        public <T> ChooseExportStrategyForColumnStep<E> mandatoryAtImport(String propertyName, ValueParser<T> valueParser) {
            return this.mandatoryAtImport(valueParser, new Common.BeanProperty(propertyName));
        }

        public ChooseExportStrategyForColumnStep<E> mandatoryAtImport(ValueSetter<E, String> valueSetter) {
            return this.mandatoryAtImport(Common.STRING, valueSetter);
        }

        public <T> ChooseExportStrategyForColumnStep<E> mandatoryAtImport(ValueParser<T> valueParser, ValueSetter<E, T> valueSetter) {
            Column<E, T> importableColumn = Column.newImportableColumn(this.columnName, valueParser, valueSetter, false);
            return new ChooseExportStrategyForColumnStep<E>(this.columnName, importableColumn);
        }

        public ChooseExportStrategyForColumnStep<E> optionalAtImport(String propertyName) {
            return this.optionalAtImport(propertyName, Common.STRING);
        }

        public <T> ChooseExportStrategyForColumnStep<E> optionalAtImport(String propertyName, ValueParser<T> valueParser) {
            return this.optionalAtImport(valueParser, new Common.BeanProperty(propertyName));
        }

        public ChooseExportStrategyForColumnStep<E> optionalAtImport(ValueSetter<E, String> valueSetter) {
            return this.optionalAtImport(Common.STRING, valueSetter);
        }

        public <T> ChooseExportStrategyForColumnStep<E> optionalAtImport(ValueParser<T> valueParser, ValueSetter<E, T> valueSetter) {
            Column<E, T> importableColumn = Column.newImportableColumn(this.columnName, valueParser, valueSetter, false);
            return new ChooseExportStrategyForColumnStep<E>(this.columnName, importableColumn);
        }
    }

    public class BuildOrAddColumnStep<E> {
        public ChooseImportStrategyForColumnStep<E> addColumn(String columnName) {
            return new ChooseImportStrategyForColumnStep(columnName);
        }

        public CsvModel<E> buildModelForExport() {
            return new CsvModel(MyModelBuilder.this.separator, MyModelBuilder.this.columnsForImport, MyModelBuilder.this.columnsForExport, null);
        }

        public CsvModel<E> buildModelForImport(CsvModel.Factory<E> emptyEFactory) {
            return new CsvModel(MyModelBuilder.this.separator, MyModelBuilder.this.columnsForImport, MyModelBuilder.this.columnsForExport, emptyEFactory);
        }
    }
}

