/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.program;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.TuttiScreen;
import fr.ifremer.tutti.ui.swing.TuttiUI;
import fr.ifremer.tutti.ui.swing.content.program.EditProgramUI;
import fr.ifremer.tutti.ui.swing.content.program.EditProgramUIModel;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;

public class EditProgramUIHandler
extends AbstractTuttiUIHandler<EditProgramUIModel, EditProgramUI> {
    private static final Log log = LogFactory.getLog(EditProgramUIHandler.class);
    private final PersistenceService persistenceService;

    public EditProgramUIHandler(TuttiUI parentUi, EditProgramUI ui) {
        super(((AbstractTuttiUIHandler)parentUi.getHandler()).getContext(), ui);
        this.persistenceService = this.context.getService(PersistenceService.class);
    }

    @Override
    public void beforeInitUI() {
        EditProgramUIModel model = new EditProgramUIModel();
        List programs = this.persistenceService.getAllProgram();
        ArrayList loadedPrograms = Lists.newArrayListWithCapacity((int)programs.size());
        for (Program program : programs) {
            loadedPrograms.add(this.persistenceService.getProgram(program.getId()));
        }
        model.setExistingPrograms(loadedPrograms);
        String surveyId = this.context.getProgramId();
        if (surveyId == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Edit new program");
            }
        } else {
            Program program;
            if (log.isInfoEnabled()) {
                log.info((Object)("Edit existing program " + surveyId));
            }
            program = this.persistenceService.getProgram(surveyId);
            model.fromBean(program);
            model.getExistingPrograms().remove(program);
        }
        this.listModelIsModify(model);
        ((EditProgramUI)this.ui).setContextValue(model);
    }

    @Override
    public void afterInitUI() {
        this.initUI(this.ui);
        EditProgramUIModel model = (EditProgramUIModel)this.getModel();
        this.initBeanComboBox(((EditProgramUI)this.ui).getZoneComboBox(), this.persistenceService.getAllProgramZone(), model.getZone());
        SwingValidator<EditProgramUIModel> validator = ((EditProgramUI)this.ui).getValidator();
        this.listenValidatorValid((SimpleBeanValidator)validator, model);
        this.registerValidators(validator);
        model.setModify(model.isCreate());
    }

    @Override
    public void onCloseUI() {
        if (log.isInfoEnabled()) {
            log.info((Object)("closing: " + this.ui));
        }
        this.clearValidators();
    }

    @Override
    public boolean canCloseUI(TuttiScreen nextScreen) {
        boolean result = true;
        if (((EditProgramUIModel)this.getModel()).isModify()) {
            int answer = this.askSaveBeforeLeaving(I18n._((String)"tutti.dialog.askSaveBeforeLeaving.saveProgram", (Object[])new Object[0]));
            boolean bl = result = answer == 1;
            if (answer == 0) {
                ActionEvent event = new ActionEvent((Object)nextScreen, nextScreen.ordinal(), null);
                this.doAction(((EditProgramUI)this.ui).getSaveButton(), event);
            }
        }
        return result;
    }

    @Override
    public SwingValidator<EditProgramUIModel> getValidator() {
        return ((EditProgramUI)this.ui).getValidator();
    }
}

