/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species.split;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.TuttiPersistence;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.split.CreateSpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.split.CreateSpeciesBatchUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.split.CreateSpeciesBatchUIModel;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class AddSpeciesAction
extends AbstractTuttiAction<CreateSpeciesBatchUIModel, CreateSpeciesBatchUI, CreateSpeciesBatchUIHandler> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(AddSpeciesAction.class);
    protected List<Species> allSpecies;
    protected Species selectedSpecies;

    public AddSpeciesAction(CreateSpeciesBatchUIHandler handler) {
        super(handler, "addSpecies", "add", null, I18n._((String)"tutti.action.addSpecies.tip", (Object[])new Object[0]), false);
        TuttiPersistence persistenceService = (TuttiPersistence)this.getContext().getService(PersistenceService.class);
        this.allSpecies = persistenceService.getAllSpecies();
    }

    @Override
    protected boolean prepareAction(ActionEvent event) {
        boolean result = super.prepareAction(event);
        CreateSpeciesBatchUIHandler handler = (CreateSpeciesBatchUIHandler)this.getHandler();
        List<Species> availableSpecies = ((CreateSpeciesBatchUIModel)handler.getModel()).getAvailableSpecies();
        ArrayList species = Lists.newArrayList(this.allSpecies);
        species.removeAll(availableSpecies);
        this.selectedSpecies = ((CreateSpeciesBatchUIHandler)this.getHandler()).openAddSpeciesDialog(I18n._((String)"tutti.title.selectSpecies", (Object[])new Object[0]), species);
        return result &= this.selectedSpecies != null;
    }

    @Override
    protected void doAction(ActionEvent event) {
        CreateSpeciesBatchUIHandler handler = (CreateSpeciesBatchUIHandler)this.getHandler();
        CreateSpeciesBatchUIModel model = (CreateSpeciesBatchUIModel)handler.getModel();
        ArrayList availableSpecies = Lists.newArrayList(model.getAvailableSpecies());
        availableSpecies.add(this.selectedSpecies);
        model.setAvailableSpecies(availableSpecies);
        model.setSpecies(this.selectedSpecies);
    }
}

