/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.TuttiPersistence;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUIModel;
import fr.ifremer.tutti.ui.swing.util.table.AbstractSelectTableAction;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import javax.swing.JTable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.nuiton.i18n.I18n;

public class RemoveSpeciesSubBatchAction
extends AbstractTuttiAction<SpeciesBatchUIModel, SpeciesBatchUI, SpeciesBatchUIHandler> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(RemoveSpeciesSubBatchAction.class);

    public RemoveSpeciesSubBatchAction(SpeciesBatchUIHandler handler) {
        super(handler, "removeSpeciesSubBatch", "batch-delete", I18n._((String)"tutti.action.removeSpeciesSubBatch", (Object[])new Object[0]), I18n._((String)"tutti.action.removeSpeciesSubBatch.tip", (Object[])new Object[0]), false);
    }

    @Override
    protected void doAction(ActionEvent event) {
        TuttiPersistence persistenceService = (TuttiPersistence)this.getContext().getService(PersistenceService.class);
        SpeciesBatchUIHandler handler = (SpeciesBatchUIHandler)this.getHandler();
        JXTable table = handler.getTable();
        int rowIndex = table.getSelectedRow();
        Preconditions.checkState((rowIndex != -1 ? 1 : 0) != 0, (Object)"Cant remove sub batch if no batch selected");
        SpeciesBatchRowModel parentBatch = (SpeciesBatchRowModel)handler.getTableModel().getEntry(rowIndex);
        Preconditions.checkState((!TuttiEntities.isNew(parentBatch) ? 1 : 0) != 0, (Object)"Can't remove sub batch if batch is not persisted");
        persistenceService.deleteSpeciesSubBatch(parentBatch.getId());
        if (parentBatch.isBatchRoot()) {
            handler.removeFromSpeciesUsed(parentBatch);
        }
        HashSet rowToRemove = Sets.newHashSet();
        handler.collectChilds(parentBatch, rowToRemove);
        ((SpeciesBatchUIModel)this.getModel()).getRows().removeAll(rowToRemove);
        parentBatch.setChildBatch(null);
        handler.getTableModel().fireTableDataChanged();
        AbstractSelectTableAction.doSelectCell((JTable)table, rowIndex, 0);
        if (table.isEditing()) {
            table.getCellEditor().stopCellEditing();
        }
    }
}

