/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.config;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.config.TuttiPersistenceConfig;
import fr.ifremer.tutti.service.config.TuttiServiceConfigOption;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.Version;

public class TuttiServiceConfig {
    private static final Log log = LogFactory.getLog(TuttiServiceConfig.class);
    protected final ApplicationConfig applicationConfig;
    protected final TuttiPersistenceConfig persistenceConfig;

    public TuttiServiceConfig(ApplicationConfig applicationConfig) {
        this.applicationConfig = applicationConfig;
        this.persistenceConfig = new TuttiPersistenceConfig(applicationConfig);
    }

    public ApplicationConfig getApplicationConfig() {
        return this.applicationConfig;
    }

    public TuttiPersistenceConfig getPersistenceConfig() {
        return this.persistenceConfig;
    }

    public Version getVersion() {
        return this.applicationConfig.getOptionAsVersion(TuttiServiceConfigOption.VERSION.getKey());
    }

    public URL getSiteUrl() {
        return this.applicationConfig.getOptionAsURL(TuttiServiceConfigOption.SITE_URL.getKey());
    }

    public String getOrganizationName() {
        return this.applicationConfig.getOption(TuttiServiceConfigOption.ORGANIZATION_NAME.getKey());
    }

    public int getInceptionYear() {
        return this.applicationConfig.getOptionAsInt(TuttiServiceConfigOption.INCEPTION_YEAR.getKey());
    }

    public File getBasedir() {
        File result = this.applicationConfig.getOptionAsFile(TuttiServiceConfigOption.BASEDIR.getKey());
        return result;
    }

    public File getDataDirectory() {
        File result = this.applicationConfig.getOptionAsFile(TuttiServiceConfigOption.DATA_DIRECTORY.getKey());
        return result;
    }

    public File getTmpDirectory() {
        File result = this.applicationConfig.getOptionAsFile(TuttiServiceConfigOption.TMP_DIRECTORY.getKey());
        return result;
    }

    public char getCsvSeparator() {
        return this.applicationConfig.getOption(TuttiServiceConfigOption.CSV_SEPARATOR.getKey()).charAt(0);
    }

    public void prepareDirectories() throws IOException {
        this.getOrCreateDirectory(TuttiServiceConfigOption.DATA_DIRECTORY);
        File tmpDir = this.getOrCreateDirectory(TuttiServiceConfigOption.TMP_DIRECTORY);
        FileUtils.deleteDirectory((File)tmpDir);
        FileUtils.forceMkdir((File)tmpDir);
    }

    protected File getOrCreateDirectory(TuttiServiceConfigOption option) throws IOException {
        File directory = this.applicationConfig.getOptionAsFile(option.getKey());
        Preconditions.checkNotNull((Object)directory, (Object)("Could not find directory " + directory + " (key " + option.getKey() + "in your configuration file named" + " sammoa.properties)"));
        if (log.isDebugEnabled()) {
            log.debug((Object)((Object)((Object)option) + " = " + directory));
        }
        FileUtils.forceMkdir((File)directory);
        return directory;
    }
}

