/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.validator;

import java.io.File;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.nuiton.validator.NuitonValidator;
import org.nuiton.validator.NuitonValidatorModel;
import org.nuiton.validator.NuitonValidatorResult;
import org.nuiton.validator.NuitonValidatorScope;
import org.nuiton.validator.model.Person;
import org.nuiton.validator.model.Pet;

public class ValidatorTestHelper {
    public static File getBasedir() {
        String basedirPath = System.getenv("basedir");
        if (basedirPath == null) {
            basedirPath = new File("").getAbsolutePath();
        }
        return new File(basedirPath);
    }

    public static void assertValidatorModel(NuitonValidator<?> validator, String expectedContext, Class<?> expectedType, NuitonValidatorScope ... expectedScopes) {
        Assert.assertNotNull(validator);
        NuitonValidatorModel model = validator.getModel();
        Assert.assertNotNull((Object)model);
        Assert.assertEquals((Object)expectedContext, (Object)model.getContext());
        Assert.assertEquals(expectedType, (Object)model.getType());
        Set scopes = model.getScopes();
        for (NuitonValidatorScope expectedScope : expectedScopes) {
            Assert.assertTrue((boolean)scopes.contains(expectedScope));
        }
    }

    public static void assertValidatorEffectiveScopes(NuitonValidator<?> validator, NuitonValidatorScope ... expectedScopes) {
        Assert.assertNotNull(validator);
        Set effectiveScopes = validator.getEffectiveScopes();
        Assert.assertEquals((long)expectedScopes.length, (long)effectiveScopes.size());
        for (NuitonValidatorScope expectedScope : expectedScopes) {
            Assert.assertTrue((boolean)effectiveScopes.contains(expectedScope));
        }
    }

    public static void assertValidatorEffectiveFields(NuitonValidator<?> validator, String ... expectedFields) {
        Assert.assertNotNull(validator);
        Set effectiveFields = validator.getEffectiveFields();
        Assert.assertEquals((long)expectedFields.length, (long)effectiveFields.size());
        for (String expectedField : expectedFields) {
            Assert.assertTrue((boolean)effectiveFields.contains(expectedField));
        }
    }

    public static void assertValidatorEffectiveFields(NuitonValidator<?> validator, NuitonValidatorScope scope, String ... expectedFields) {
        Assert.assertNotNull(validator);
        Set effectiveFields = validator.getEffectiveFields(scope);
        Assert.assertEquals((long)expectedFields.length, (long)effectiveFields.size());
        for (String expectedField : expectedFields) {
            Assert.assertTrue((boolean)effectiveFields.contains(expectedField));
        }
    }

    public static void testPerson(NuitonValidator<Person> validator) {
        Assert.assertNotNull(validator);
        Person person = new Person();
        NuitonValidatorResult result = validator.validate((Object)person);
        Assert.assertFalse((boolean)result.isValid());
        ValidatorTestHelper.assertFieldMessages(result, NuitonValidatorScope.ERROR, "firstname", "person.firstname.required");
        ValidatorTestHelper.assertFieldMessages(result, NuitonValidatorScope.ERROR, "name", "person.name.required");
        ValidatorTestHelper.assertFieldMessages(result, NuitonValidatorScope.WARNING, "pet", "person.with.no.pet");
        person.setFirstname("Joe");
        result = validator.validate((Object)person);
        Assert.assertFalse((boolean)result.isValid());
        ValidatorTestHelper.assertFieldMessages(result, NuitonValidatorScope.ERROR, "firstname", new String[0]);
        ValidatorTestHelper.assertFieldMessages(result, NuitonValidatorScope.ERROR, "name", "person.name.required");
        ValidatorTestHelper.assertFieldMessages(result, NuitonValidatorScope.WARNING, "pet", "person.with.no.pet");
        person.setName("Black");
        result = validator.validate((Object)person);
        Assert.assertTrue((boolean)result.isValid());
        ValidatorTestHelper.assertFieldMessages(result, NuitonValidatorScope.ERROR, "firstname", new String[0]);
        ValidatorTestHelper.assertFieldMessages(result, NuitonValidatorScope.ERROR, "name", new String[0]);
        ValidatorTestHelper.assertFieldMessages(result, NuitonValidatorScope.WARNING, "pet", "person.with.no.pet");
        person.addPet(new Pet());
        result = validator.validate((Object)person);
        Assert.assertTrue((boolean)result.isValid());
        ValidatorTestHelper.assertFieldMessages(result, NuitonValidatorScope.ERROR, "firstname", new String[0]);
        ValidatorTestHelper.assertFieldMessages(result, NuitonValidatorScope.ERROR, "name", new String[0]);
        ValidatorTestHelper.assertFieldMessages(result, NuitonValidatorScope.WARNING, "pet", new String[0]);
    }

    public static void assertFieldMessages(NuitonValidatorResult result, NuitonValidatorScope scope, String field, String ... expectedMessages) {
        if (expectedMessages.length == 0) {
            boolean hasMessages = result.hasMessagesForScope(field, scope);
            Assert.assertFalse((boolean)hasMessages);
        } else {
            boolean hasMessages = result.hasMessagesForScope(field, scope);
            Assert.assertTrue((boolean)hasMessages);
            List messages = result.getMessagesForScope(field, scope);
            Assert.assertNotNull((Object)hasMessages);
            Assert.assertEquals((long)expectedMessages.length, (long)messages.size());
            for (String expectedMessage : expectedMessages) {
                Assert.assertTrue((boolean)messages.contains(expectedMessage));
            }
        }
    }
}

