/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.referential.regulation;

import fr.ifremer.adagio.core.dao.PaginationResult;
import fr.ifremer.adagio.core.dao.PrincipalStore;
import fr.ifremer.adagio.core.dao.PropertySearch;
import fr.ifremer.adagio.core.dao.Search;
import fr.ifremer.adagio.core.dao.referential.regulation.Corpus;
import fr.ifremer.adagio.core.dao.referential.regulation.CorpusDao;
import fr.ifremer.adagio.core.dao.referential.regulation.CorpusImpl;
import fr.ifremer.adagio.core.dao.referential.regulation.CorpusType;
import fr.ifremer.adagio.core.dao.referential.regulation.Fishery;
import fr.ifremer.adagio.core.dao.referential.regulation.MinimumSizeAllowed;
import fr.ifremer.adagio.core.dao.referential.regulation.RightToProduce;
import fr.ifremer.adagio.core.dao.technical.hibernate.HibernateDaoSupport;
import java.io.Serializable;
import java.security.Principal;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateCallback;

public abstract class CorpusDaoBase
extends HibernateDaoSupport
implements CorpusDao {
    @Override
    public Object load(int transform, Integer id) {
        if (id == null) {
            throw new IllegalArgumentException("Corpus.load - 'id' can not be null");
        }
        Integer entityPk = id;
        Object entity = this.getHibernateTemplate().get(CorpusImpl.class, (Serializable)entityPk);
        return this.transformEntity(transform, (Corpus)entity);
    }

    @Override
    public Corpus load(Integer id) {
        return (Corpus)this.load(0, id);
    }

    @Override
    public Collection<Corpus> loadAll() {
        return this.loadAll(0);
    }

    @Override
    public Collection<?> loadAll(int transform) {
        return this.loadAll(transform, -1, -1);
    }

    @Override
    public Collection<?> loadAll(int pageNumber, int pageSize) {
        return this.loadAll(0, pageNumber, pageSize);
    }

    @Override
    public Collection<?> loadAll(int transform, int pageNumber, int pageSize) {
        try {
            Criteria criteria = this.getSession(false).createCriteria(CorpusImpl.class);
            if (pageNumber > 0 && pageSize > 0) {
                criteria.setFirstResult(this.calculateFirstResult(pageNumber, pageSize));
                criteria.setMaxResults(pageSize);
            }
            List results = criteria.list();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    private int calculateFirstResult(int pageNumber, int pageSize) {
        int firstResult = 0;
        if (pageNumber > 0) {
            firstResult = (pageNumber - 1) * pageSize;
        }
        return firstResult;
    }

    @Override
    public Corpus create(Corpus corpus) {
        return (Corpus)this.create(0, corpus);
    }

    @Override
    public Object create(int transform, Corpus corpus) {
        if (corpus == null) {
            throw new IllegalArgumentException("Corpus.create - 'corpus' can not be null");
        }
        this.getHibernateTemplate().save((Object)corpus);
        return this.transformEntity(transform, corpus);
    }

    @Override
    public Collection<Corpus> create(Collection<Corpus> entities) {
        return this.create(0, entities);
    }

    @Override
    public Collection<?> create(final int transform, final Collection<Corpus> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("Corpus.create - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    CorpusDaoBase.this.create(transform, (Corpus)entityIterator.next());
                }
                return null;
            }
        });
        return entities;
    }

    @Override
    public Corpus create(String name, String description, Date startDate, Date endDate, Timestamp updateDate, CorpusType corpusType, RightToProduce rightToProduce, Collection<MinimumSizeAllowed> minimumSizeAlloweds, Collection<Fishery> fisheries) {
        return (Corpus)this.create(0, name, description, startDate, endDate, updateDate, corpusType, rightToProduce, minimumSizeAlloweds, fisheries);
    }

    @Override
    public Object create(int transform, String name, String description, Date startDate, Date endDate, Timestamp updateDate, CorpusType corpusType, RightToProduce rightToProduce, Collection<MinimumSizeAllowed> minimumSizeAlloweds, Collection<Fishery> fisheries) {
        CorpusImpl entity = new CorpusImpl();
        entity.setName(name);
        entity.setDescription(description);
        entity.setStartDate(startDate);
        entity.setEndDate(endDate);
        entity.setUpdateDate(updateDate);
        entity.setCorpusType(corpusType);
        entity.setRightToProduce(rightToProduce);
        entity.setMinimumSizeAlloweds(minimumSizeAlloweds);
        entity.setFisheries(fisheries);
        return this.create(transform, entity);
    }

    @Override
    public Corpus create(CorpusType corpusType, Collection<Fishery> fisheries, String name, Date startDate) {
        return (Corpus)this.create(0, corpusType, fisheries, name, startDate);
    }

    @Override
    public Object create(int transform, CorpusType corpusType, Collection<Fishery> fisheries, String name, Date startDate) {
        CorpusImpl entity = new CorpusImpl();
        entity.setCorpusType(corpusType);
        entity.setFisheries(fisheries);
        entity.setName(name);
        entity.setStartDate(startDate);
        return this.create(transform, entity);
    }

    @Override
    public void update(Corpus corpus) {
        if (corpus == null) {
            throw new IllegalArgumentException("Corpus.update - 'corpus' can not be null");
        }
        this.getHibernateTemplate().update((Object)corpus);
    }

    @Override
    public void update(final Collection<Corpus> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("Corpus.update - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    CorpusDaoBase.this.update((Corpus)entityIterator.next());
                }
                return null;
            }
        });
    }

    @Override
    public void remove(Corpus corpus) {
        if (corpus == null) {
            throw new IllegalArgumentException("Corpus.remove - 'corpus' can not be null");
        }
        this.getHibernateTemplate().delete((Object)corpus);
    }

    @Override
    public void remove(Integer id) {
        if (id == null) {
            throw new IllegalArgumentException("Corpus.remove - 'id' can not be null");
        }
        Integer entityPk = id;
        Corpus entity = this.load(id);
        if (entity != null) {
            this.remove(entity);
        }
    }

    @Override
    public void remove(Collection<Corpus> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("Corpus.remove - 'entities' can not be null");
        }
        this.getHibernateTemplate().deleteAll(entities);
    }

    protected Object transformEntity(int transform, Corpus entity) {
        Corpus target = null;
        if (entity != null) {
            switch (transform) {
                default: 
            }
            target = entity;
        }
        return target;
    }

    protected void transformEntities(int transform, Collection<?> entities) {
        switch (transform) {
            default: 
        }
    }

    protected Corpus toEntity(Object[] row) {
        Corpus target = null;
        if (row != null) {
            for (Object object : row) {
                if (!(object instanceof Corpus)) continue;
                target = (Corpus)object;
                break;
            }
        }
        return target;
    }

    protected Principal getPrincipal() {
        return PrincipalStore.get();
    }

    @Override
    public PaginationResult search(int transform, int pageNumber, int pageSize, Search search) {
        try {
            search.setPageNumber(pageNumber);
            search.setPageSize(pageSize);
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), CorpusImpl.class, search);
            List results = propertySearch.executeAsList();
            this.transformEntities(transform, results);
            return new PaginationResult(results.toArray(new Object[0]), propertySearch.getTotalCount());
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public PaginationResult search(int pageNumber, int pageSize, Search search) {
        return this.search(0, pageNumber, pageSize, search);
    }

    @Override
    public Set<?> search(int transform, Search search) {
        try {
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), CorpusImpl.class, search);
            Set results = propertySearch.executeAsSet();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public Set<Corpus> search(Search search) {
        return this.search(0, search);
    }
}

