/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.referential.pmfm;

import fr.ifremer.adagio.core.dao.PaginationResult;
import fr.ifremer.adagio.core.dao.PrincipalStore;
import fr.ifremer.adagio.core.dao.PropertySearch;
import fr.ifremer.adagio.core.dao.Search;
import fr.ifremer.adagio.core.dao.referential.Status;
import fr.ifremer.adagio.core.dao.referential.pmfm.Fraction;
import fr.ifremer.adagio.core.dao.referential.pmfm.Matrix;
import fr.ifremer.adagio.core.dao.referential.pmfm.MatrixDao;
import fr.ifremer.adagio.core.dao.referential.pmfm.MatrixImpl;
import fr.ifremer.adagio.core.dao.technical.hibernate.HibernateDaoSupport;
import java.io.Serializable;
import java.security.Principal;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateCallback;

public abstract class MatrixDaoBase
extends HibernateDaoSupport
implements MatrixDao {
    @Override
    public Object load(int transform, Integer id) {
        if (id == null) {
            throw new IllegalArgumentException("Matrix.load - 'id' can not be null");
        }
        Integer entityPk = id;
        Object entity = this.getHibernateTemplate().get(MatrixImpl.class, (Serializable)entityPk);
        return this.transformEntity(transform, (Matrix)entity);
    }

    @Override
    public Matrix load(Integer id) {
        return (Matrix)this.load(0, id);
    }

    @Override
    public Collection<Matrix> loadAll() {
        return this.loadAll(0);
    }

    @Override
    public Collection<?> loadAll(int transform) {
        return this.loadAll(transform, -1, -1);
    }

    @Override
    public Collection<?> loadAll(int pageNumber, int pageSize) {
        return this.loadAll(0, pageNumber, pageSize);
    }

    @Override
    public Collection<?> loadAll(int transform, int pageNumber, int pageSize) {
        try {
            Criteria criteria = this.getSession(false).createCriteria(MatrixImpl.class);
            if (pageNumber > 0 && pageSize > 0) {
                criteria.setFirstResult(this.calculateFirstResult(pageNumber, pageSize));
                criteria.setMaxResults(pageSize);
            }
            List results = criteria.list();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    private int calculateFirstResult(int pageNumber, int pageSize) {
        int firstResult = 0;
        if (pageNumber > 0) {
            firstResult = (pageNumber - 1) * pageSize;
        }
        return firstResult;
    }

    @Override
    public Matrix create(Matrix matrix) {
        return (Matrix)this.create(0, matrix);
    }

    @Override
    public Object create(int transform, Matrix matrix) {
        if (matrix == null) {
            throw new IllegalArgumentException("Matrix.create - 'matrix' can not be null");
        }
        this.getHibernateTemplate().save((Object)matrix);
        return this.transformEntity(transform, matrix);
    }

    @Override
    public Collection<Matrix> create(Collection<Matrix> entities) {
        return this.create(0, entities);
    }

    @Override
    public Collection<?> create(final int transform, final Collection<Matrix> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("Matrix.create - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    MatrixDaoBase.this.create(transform, (Matrix)entityIterator.next());
                }
                return null;
            }
        });
        return entities;
    }

    @Override
    public Matrix create(String name, String description, Date creationDate, Timestamp updateDate, Collection<Fraction> fractions, Status status) {
        return (Matrix)this.create(0, name, description, creationDate, updateDate, fractions, status);
    }

    @Override
    public Object create(int transform, String name, String description, Date creationDate, Timestamp updateDate, Collection<Fraction> fractions, Status status) {
        MatrixImpl entity = new MatrixImpl();
        entity.setName(name);
        entity.setDescription(description);
        entity.setCreationDate(creationDate);
        entity.setUpdateDate(updateDate);
        entity.setFractions(fractions);
        entity.setStatus(status);
        return this.create(transform, entity);
    }

    @Override
    public Matrix create(Date creationDate, Collection<Fraction> fractions, String name, Status status) {
        return (Matrix)this.create(0, creationDate, fractions, name, status);
    }

    @Override
    public Object create(int transform, Date creationDate, Collection<Fraction> fractions, String name, Status status) {
        MatrixImpl entity = new MatrixImpl();
        entity.setCreationDate(creationDate);
        entity.setFractions(fractions);
        entity.setName(name);
        entity.setStatus(status);
        return this.create(transform, entity);
    }

    @Override
    public void update(Matrix matrix) {
        if (matrix == null) {
            throw new IllegalArgumentException("Matrix.update - 'matrix' can not be null");
        }
        this.getHibernateTemplate().update((Object)matrix);
    }

    @Override
    public void update(final Collection<Matrix> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("Matrix.update - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    MatrixDaoBase.this.update((Matrix)entityIterator.next());
                }
                return null;
            }
        });
    }

    @Override
    public void remove(Matrix matrix) {
        if (matrix == null) {
            throw new IllegalArgumentException("Matrix.remove - 'matrix' can not be null");
        }
        this.getHibernateTemplate().delete((Object)matrix);
    }

    @Override
    public void remove(Integer id) {
        if (id == null) {
            throw new IllegalArgumentException("Matrix.remove - 'id' can not be null");
        }
        Integer entityPk = id;
        Matrix entity = this.load(id);
        if (entity != null) {
            this.remove(entity);
        }
    }

    @Override
    public void remove(Collection<Matrix> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("Matrix.remove - 'entities' can not be null");
        }
        this.getHibernateTemplate().deleteAll(entities);
    }

    protected Object transformEntity(int transform, Matrix entity) {
        Matrix target = null;
        if (entity != null) {
            switch (transform) {
                default: 
            }
            target = entity;
        }
        return target;
    }

    protected void transformEntities(int transform, Collection<?> entities) {
        switch (transform) {
            default: 
        }
    }

    protected Matrix toEntity(Object[] row) {
        Matrix target = null;
        if (row != null) {
            for (Object object : row) {
                if (!(object instanceof Matrix)) continue;
                target = (Matrix)object;
                break;
            }
        }
        return target;
    }

    protected Principal getPrincipal() {
        return PrincipalStore.get();
    }

    @Override
    public PaginationResult search(int transform, int pageNumber, int pageSize, Search search) {
        try {
            search.setPageNumber(pageNumber);
            search.setPageSize(pageSize);
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), MatrixImpl.class, search);
            List results = propertySearch.executeAsList();
            this.transformEntities(transform, results);
            return new PaginationResult(results.toArray(new Object[0]), propertySearch.getTotalCount());
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public PaginationResult search(int pageNumber, int pageSize, Search search) {
        return this.search(0, pageNumber, pageSize, search);
    }

    @Override
    public Set<?> search(int transform, Search search) {
        try {
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), MatrixImpl.class, search);
            Set results = propertySearch.executeAsSet();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public Set<Matrix> search(Search search) {
        return this.search(0, search);
    }
}

