/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service;

import fr.ifremer.tutti.persistence.TuttiPersistenceServiceImplementor;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryEnum;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Country;
import fr.ifremer.tutti.persistence.entities.referential.FishingOperationLocation;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.persistence.entities.referential.Zone;
import java.util.List;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public interface ReferentialPersistenceService
extends TuttiPersistenceServiceImplementor {
    public List<Zone> getAllProgramZone();

    public List<Country> getAllCountry();

    public List<FishingOperationLocation> getAllFishingOperationStrata(String var1);

    public List<FishingOperationLocation> getAllFishingOperationSubStrata(String var1, String var2);

    public List<FishingOperationLocation> getAllFishingOperationLocation(String var1, String var2, String var3);

    public FishingOperationLocation getFishingOperationLocation(String var1);

    public List<Vessel> getAllScientificVessel();

    public List<Vessel> getAllFishingVessel();

    public Vessel getVessel(String var1);

    public List<Species> getAllReferentSpecies();

    public List<Species> getAllSpecies();

    public Species getSpeciesByReferenceTaxonId(Integer var1);

    public List<Caracteristic> getAllCaracteristic();

    public Caracteristic getSizeCategoryCaracteristic();

    public Caracteristic getSexCaracteristic();

    public Caracteristic getSortedUnsortedCaracteristic();

    public Caracteristic getMaturityCaracteristic();

    public Caracteristic getMacroWasteCategoryCaracteristic();

    public Caracteristic getMacroWasteSizeCategoryCaracteristic();

    public List<Gear> getAllScientificGear();

    public List<Gear> getAllFishingGear();

    public List<Person> getAllPerson();

    public Person getPerson(Integer var1);

    public Gear getGear(Integer var1);

    public Caracteristic getCaracteristic(Integer var1);

    public boolean isSortedQualitativeValue(CaracteristicQualitativeValue var1);

    public List<Integer> getSampleCategoryIds();

    @Transactional(readOnly=false)
    public List<Species> importTemporarySpecies(List<Species> var1);

    @Transactional(readOnly=false)
    public List<Vessel> importTemporaryVessel(List<Vessel> var1);

    @Transactional(readOnly=false)
    public List<Person> importTemporaryPerson(List<Person> var1);

    @Transactional(readOnly=false)
    public List<Gear> importTemporaryGear(List<Gear> var1);

    public SampleCategoryEnum getSampleCategoryByPmfmId(Integer var1);
}

