/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocols;
import fr.ifremer.tutti.persistence.service.AbstractPersistenceService;
import fr.ifremer.tutti.persistence.service.ProtocolPersistenceService;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;
import org.springframework.stereotype.Service;

@Service(value="protocolPersistenceService")
public class ProtocolPersistenceServiceImpl
extends AbstractPersistenceService
implements ProtocolPersistenceService {
    private static final Log log = LogFactory.getLog(ProtocolPersistenceServiceImpl.class);
    public static final String TUTTI_PROTOCOL_EXTENSION = "tuttiProtocol";

    @Override
    public boolean isProtocolExist(String id) {
        return this.getAllProtocolId().contains(id);
    }

    @Override
    public List<String> getAllProtocolId() {
        File protocolDirectory = this.config.getProtocolDirectory();
        Collection files = FileUtils.listFiles((File)protocolDirectory, (String[])new String[]{TUTTI_PROTOCOL_EXTENSION}, (boolean)false);
        ArrayList result = Lists.newArrayListWithCapacity((int)files.size());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Found " + files.size() + " protocol(s)."));
        }
        int suffixLength = TUTTI_PROTOCOL_EXTENSION.length() + 1;
        for (File file : files) {
            String fileName = file.getName();
            result.add(fileName.substring(0, fileName.length() - suffixLength));
        }
        return result;
    }

    @Override
    public List<String> getAllProtocolNames() {
        ArrayList result = Lists.newArrayList();
        for (TuttiProtocol protocol : this.getAllProtocol()) {
            result.add(protocol.getName());
        }
        return result;
    }

    @Override
    public List<TuttiProtocol> getAllProtocol() {
        ArrayList result = Lists.newArrayList();
        for (String id : this.getAllProtocolId()) {
            TuttiProtocol protocol = this.getProtocol(id);
            result.add(protocol);
        }
        return result;
    }

    @Override
    public TuttiProtocol getProtocol(String id) {
        File file = this.getProtocolFile(id);
        try {
            TuttiProtocol result = TuttiProtocols.fromFile(file);
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read protocol " + id + " from file " + file, e);
        }
    }

    @Override
    public TuttiProtocol createProtocol(TuttiProtocol bean) {
        Binder protocolBinder = BinderFactory.newBinder(TuttiProtocol.class);
        TuttiProtocol result = new TuttiProtocol();
        protocolBinder.copy((Object)bean, (Object)result, new String[0]);
        result.setId(UUID.randomUUID().toString());
        result.setLengthClassesPmfmId(TuttiEntities.getList(bean.getLengthClassesPmfmId()));
        result.setEnvironmentPmfmId(TuttiEntities.getList(bean.getEnvironmentPmfmId()));
        result.setGearPmfmId(TuttiEntities.getList(bean.getGearPmfmId()));
        result.setHydrologyPmfmId(TuttiEntities.getList(bean.getHydrologyPmfmId()));
        Binder speciesProtocolBinder = BinderFactory.newBinder(SpeciesProtocol.class);
        ArrayList species = Lists.newArrayList();
        if (!bean.isSpeciesEmpty()) {
            for (SpeciesProtocol speciesProtocol : bean.getSpecies()) {
                SpeciesProtocol s = new SpeciesProtocol();
                speciesProtocolBinder.copy((Object)speciesProtocol, (Object)s, new String[0]);
                s.setId(UUID.randomUUID().toString());
                species.add(s);
            }
        }
        result.setSpecies(species);
        String id = result.getId();
        File file = this.getProtocolFile(id);
        try {
            TuttiProtocols.toFile(result, file);
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not write protocol " + id + " to file " + file, e);
        }
    }

    @Override
    public TuttiProtocol saveProtocol(TuttiProtocol bean) {
        String id = bean.getId();
        File file = this.getProtocolFile(id);
        try {
            TuttiProtocols.toFile(bean, file);
            return bean;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not write protocol " + id + " to file " + file, e);
        }
    }

    @Override
    public void deleteProtocol(String protocolId) {
        File file = this.getProtocolFile(protocolId);
        try {
            if (file.exists()) {
                FileUtils.forceDelete((File)file);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not delete protocol " + protocolId + " (file " + file + ")");
        }
    }

    protected File getProtocolFile(String id) {
        File protocolDirectory = this.config.getProtocolDirectory();
        File result = new File(protocolDirectory, id + "." + TUTTI_PROTOCOL_EXTENSION);
        return result;
    }
}

