/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.TuttiPersistenceServiceImplementor;
import fr.ifremer.tutti.persistence.config.TuttiPersistenceConfig;
import fr.ifremer.tutti.persistence.service.TuttiEnumerationFile;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.hibernate.type.Type;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;

public abstract class AbstractPersistenceService
implements TuttiPersistenceServiceImplementor {
    private static final Log log = LogFactory.getLog(AbstractPersistenceService.class);
    private boolean debug = false;
    @Autowired
    protected SessionFactory sessionFactory;
    @Autowired
    protected TuttiEnumerationFile enumeration;
    protected TuttiPersistenceConfig config;

    @Override
    public void init() {
        if (this.config == null) {
            this.config = TuttiPersistenceConfig.getInstance();
            Preconditions.checkNotNull((Object)this.config, (Object)("No config found in " + TuttiPersistenceConfig.class.getName()));
        }
    }

    @Override
    public void close() {
    }

    public void setConfig(TuttiPersistenceConfig config) {
        this.config = config;
    }

    protected final SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    protected final Session getCurrentSession() {
        return this.getSessionFactory().getCurrentSession();
    }

    protected Object[] queryUnique(String queryName, Object ... params) {
        Query query = this.createQuery(queryName, params);
        Object result = query.uniqueResult();
        return (Object[])result;
    }

    protected <T> T queryUniqueTyped(String queryName, Object ... params) {
        Query query = this.createQuery(queryName, params);
        Object result = query.uniqueResult();
        return (T)result;
    }

    protected Iterator<Object[]> queryList(String queryName, Object ... params) {
        Query query = this.createQuery(queryName, params);
        Iterator result = query.iterate();
        return result;
    }

    protected <T> Iterator<T> queryListTyped(String queryName, Object ... params) {
        Query query = this.createQuery(queryName, params);
        Iterator result = query.iterate();
        return result;
    }

    protected <T> List<T> queryList2Typed(String queryName, Object ... params) {
        Query query = this.createQuery(queryName, params);
        List result = query.list();
        return result;
    }

    protected Query createQuery(String queryName, Object ... params) {
        Query query = this.getCurrentSession().getNamedQuery(queryName);
        if (params.length > 0) {
            Preconditions.checkArgument((params.length % 3 == 0 ? 1 : 0) != 0, (Object)"Params must be tuple (paramName, paramType, paramValue)");
            int nbParams = params.length / 3;
            for (int i = 0; i < nbParams; ++i) {
                String paramName = (String)params[3 * i];
                Type paramType = (Type)params[3 * i + 1];
                Object paramValue = params[3 * i + 2];
                query.setParameter(paramName, paramValue, paramType);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("query [" + queryName + "] (param " + i + " [" + paramName + '=' + paramValue + "])"));
            }
        }
        return query;
    }

    protected <T extends Serializable> T load(Class<? extends T> clazz, Serializable id) {
        Serializable load;
        if (this.debug && (load = (Serializable)this.getCurrentSession().get(clazz, id)) == null) {
            throw new DataIntegrityViolationException("Unable to load entity " + clazz.getName() + " with id=" + id + " : not found in database.");
        }
        load = (Serializable)this.getCurrentSession().load(clazz, id);
        return (T)load;
    }

    protected <T extends Serializable> T get(Class<? extends T> clazz, Serializable id) {
        Serializable load = (Serializable)this.getCurrentSession().get(clazz, id);
        return (T)load;
    }

    protected int queryUpdate(String queryName, Object ... params) {
        Query query = this.createQuery(queryName, params);
        int result = query.executeUpdate();
        return result;
    }
}

