/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence;

import com.google.common.collect.Maps;
import fr.ifremer.tutti.persistence.TuttiPersistence;
import fr.ifremer.tutti.persistence.entities.data.AccidentalBatch;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatch;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.MacroWasteBatch;
import fr.ifremer.tutti.persistence.entities.data.PlanktonBatch;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequency;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Country;
import fr.ifremer.tutti.persistence.entities.referential.FishingOperationLocation;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.persistence.entities.referential.Zone;
import fr.ifremer.tutti.persistence.service.AccidentalBatchPersistenceService;
import fr.ifremer.tutti.persistence.service.BenthosBatchPersistenceService;
import fr.ifremer.tutti.persistence.service.CatchBatchPersistenceService;
import fr.ifremer.tutti.persistence.service.CruisePersistenceService;
import fr.ifremer.tutti.persistence.service.FishingOperationPersistenceService;
import fr.ifremer.tutti.persistence.service.MacroWasteBatchPersistenceService;
import fr.ifremer.tutti.persistence.service.PlanktonBatchPersistenceService;
import fr.ifremer.tutti.persistence.service.ProgramPersistenceService;
import fr.ifremer.tutti.persistence.service.ProtocolPersistenceService;
import fr.ifremer.tutti.persistence.service.ReferentialPersistenceService;
import fr.ifremer.tutti.persistence.service.SpeciesBatchPersistenceService;
import fr.ifremer.tutti.persistence.service.TuttiPersistenceServiceLocator;
import java.io.IOException;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class TuttiPersistenceImpl
implements TuttiPersistence {
    private static final Log log = LogFactory.getLog(TuttiPersistenceImpl.class);
    @Autowired
    protected ReferentialPersistenceService referentialService;
    @Autowired
    protected ProgramPersistenceService programService;
    @Autowired
    protected CruisePersistenceService cruiseService;
    @Autowired
    protected FishingOperationPersistenceService fishingOperationService;
    @Autowired
    protected CatchBatchPersistenceService catchBatchService;
    @Autowired
    protected SpeciesBatchPersistenceService speciesBatchService;
    @Autowired
    protected BenthosBatchPersistenceService benthosBatchService;
    @Autowired
    protected PlanktonBatchPersistenceService planktonBatchService;
    @Autowired
    protected MacroWasteBatchPersistenceService macroWasteBatchService;
    @Autowired
    protected AccidentalBatchPersistenceService accidentalBatchService;
    @Autowired
    protected ProtocolPersistenceService protocolService;

    @Override
    public String getImplementationName() {
        return "Persistence Adagio implementation";
    }

    @Override
    public void init() {
        if (log.isInfoEnabled()) {
            log.info((Object)("Open persistence driver " + this.getImplementationName()));
        }
        this.referentialService.init();
        this.programService.init();
        this.cruiseService.init();
        this.fishingOperationService.init();
        this.catchBatchService.init();
        this.speciesBatchService.init();
        this.benthosBatchService.init();
        this.benthosBatchService.init();
        this.planktonBatchService.init();
        this.macroWasteBatchService.init();
        this.accidentalBatchService.init();
        this.protocolService.init();
    }

    @Override
    public void close() throws IOException {
        if (log.isInfoEnabled()) {
            log.info((Object)("Close persistence driver " + this.getImplementationName()));
        }
        this.referentialService.close();
        this.programService.close();
        this.cruiseService.close();
        this.fishingOperationService.close();
        this.catchBatchService.close();
        this.speciesBatchService.close();
        this.benthosBatchService.close();
        this.benthosBatchService.close();
        this.planktonBatchService.close();
        this.macroWasteBatchService.close();
        this.accidentalBatchService.close();
        this.protocolService.close();
        TuttiPersistenceServiceLocator.close();
    }

    @Override
    public List<Zone> getAllProgramZone() {
        return this.referentialService.getAllProgramZone();
    }

    @Override
    public List<Country> getAllCountry() {
        return this.referentialService.getAllCountry();
    }

    @Override
    public List<FishingOperationLocation> getAllFishingOperationStrata(String zoneId) {
        return this.referentialService.getAllFishingOperationStrata(zoneId);
    }

    @Override
    public List<FishingOperationLocation> getAllFishingOperationSubStrata(String zoneId, String strataId) {
        return this.referentialService.getAllFishingOperationSubStrata(zoneId, strataId);
    }

    @Override
    public List<FishingOperationLocation> getAllFishingOperationLocation(String zoneId, String strataId, String subStrataId) {
        return this.referentialService.getAllFishingOperationLocation(zoneId, strataId, subStrataId);
    }

    @Override
    public List<Vessel> getAllScientificVessel() {
        return this.referentialService.getAllScientificVessel();
    }

    @Override
    public List<Vessel> getAllFishingVessel() {
        return this.referentialService.getAllFishingVessel();
    }

    @Override
    public List<Species> getAllSpecies() {
        return this.referentialService.getAllSpecies();
    }

    @Override
    public List<Species> getAllReferentSpecies() {
        return this.referentialService.getAllReferentSpecies();
    }

    @Override
    public List<Species> getAllSpecies(TuttiProtocol protocol) {
        List<Species> result = this.referentialService.getAllSpecies();
        if (protocol != null && !protocol.isSpeciesEmpty()) {
            TreeMap surveyCodeByTaxonId = Maps.newTreeMap();
            for (SpeciesProtocol speciesProtocol : protocol.getSpecies()) {
                String surveyCode = speciesProtocol.getSpeciesSurveyCode();
                if (!StringUtils.isNotBlank((CharSequence)surveyCode)) continue;
                Integer taxonId = speciesProtocol.getSpeciesReferenceTaxonId();
                surveyCodeByTaxonId.put(taxonId, surveyCode);
            }
            for (Species species : result) {
                Integer taxonId = species.getReferenceTaxonId();
                String surveyCode = (String)surveyCodeByTaxonId.get(taxonId);
                species.setSurveyCode(surveyCode);
            }
        }
        return result;
    }

    @Override
    public List<Caracteristic> getAllCaracteristic() {
        return this.referentialService.getAllCaracteristic();
    }

    @Override
    public Caracteristic getSizeCategoryCaracteristic() {
        return this.referentialService.getSizeCategoryCaracteristic();
    }

    @Override
    public Caracteristic getSexCaracteristic() {
        return this.referentialService.getSexCaracteristic();
    }

    @Override
    public Caracteristic getSortedUnsortedCaracteristic() {
        return this.referentialService.getSortedUnsortedCaracteristic();
    }

    @Override
    public Caracteristic getMaturityCaracteristic() {
        return this.referentialService.getMaturityCaracteristic();
    }

    @Override
    public Caracteristic getMacroWasteCategoryCaracteristic() {
        return this.referentialService.getMacroWasteCategoryCaracteristic();
    }

    @Override
    public Caracteristic getMacroWasteSizeCategoryCaracteristic() {
        return this.referentialService.getMacroWasteSizeCategoryCaracteristic();
    }

    @Override
    public List<Gear> getAllScientificGear() {
        return this.referentialService.getAllScientificGear();
    }

    @Override
    public List<Gear> getAllFishingGear() {
        return this.referentialService.getAllFishingGear();
    }

    @Override
    public List<Person> getAllPerson() {
        return this.referentialService.getAllPerson();
    }

    @Override
    public Vessel getVessel(String vesselCode) {
        return this.referentialService.getVessel(vesselCode);
    }

    @Override
    public boolean isSortedQualitativeValue(CaracteristicQualitativeValue value) {
        return this.referentialService.isSortedQualitativeValue(value);
    }

    @Override
    public Person getPerson(Integer personId) {
        return this.referentialService.getPerson(personId);
    }

    @Override
    public Gear getGear(Integer gearId) {
        return this.referentialService.getGear(gearId);
    }

    @Override
    public List<Species> importTemporarySpecies(List<Species> species) {
        return this.referentialService.importTemporarySpecies(species);
    }

    @Override
    public List<Vessel> importTemporaryVessel(List<Vessel> vessels) {
        return this.referentialService.importTemporaryVessel(vessels);
    }

    @Override
    public List<Person> importTemporaryPerson(List<Person> persons) {
        return this.referentialService.importTemporaryPerson(persons);
    }

    @Override
    public List<Gear> importTemporaryGear(List<Gear> gears) {
        return this.referentialService.importTemporaryGear(gears);
    }

    @Override
    public List<Program> getAllProgram() {
        return this.programService.getAllProgram();
    }

    @Override
    public Program getProgram(String id) {
        return this.programService.getProgram(id);
    }

    @Override
    public Program createProgram(Program bean) {
        return this.programService.createProgram(bean);
    }

    @Override
    public Program saveProgram(Program bean) {
        return this.programService.saveProgram(bean);
    }

    @Override
    public List<Cruise> getAllCruise(String programId) {
        return this.cruiseService.getAllCruise(programId);
    }

    @Override
    public Cruise getCruise(String id) {
        return this.cruiseService.getCruise(id);
    }

    @Override
    public Cruise createCruise(Cruise bean) {
        return this.cruiseService.createCruise(bean);
    }

    @Override
    public Cruise saveCruise(Cruise bean) {
        return this.cruiseService.saveCruise(bean);
    }

    @Override
    public boolean isProtocolExist(String id) {
        return this.protocolService.isProtocolExist(id);
    }

    @Override
    public List<String> getAllProtocolNames() {
        return this.protocolService.getAllProtocolId();
    }

    @Override
    public List<TuttiProtocol> getAllProtocol() {
        return this.protocolService.getAllProtocol();
    }

    @Override
    public TuttiProtocol saveProtocol(TuttiProtocol bean) {
        return this.protocolService.saveProtocol(bean);
    }

    @Override
    public void deleteProtocol(String id) {
        this.protocolService.deleteProtocol(id);
    }

    @Override
    public TuttiProtocol createProtocol(TuttiProtocol bean) {
        return this.protocolService.createProtocol(bean);
    }

    @Override
    public TuttiProtocol getProtocol(String id) {
        return this.protocolService.getProtocol(id);
    }

    @Override
    public List<FishingOperation> getAllFishingOperation(String cruiseId) {
        return this.fishingOperationService.getAllFishingOperation(cruiseId);
    }

    @Override
    public FishingOperation getFishingOperation(String id) {
        return this.fishingOperationService.getFishingOperation(id);
    }

    @Override
    public FishingOperation createFishingOperation(FishingOperation bean) {
        return this.fishingOperationService.createFishingOperation(bean);
    }

    @Override
    public FishingOperation saveFishingOperation(FishingOperation bean) {
        return this.fishingOperationService.saveFishingOperation(bean);
    }

    @Override
    public CatchBatch getCatchBatchFromFishingOperation(String id) {
        return this.catchBatchService.getCatchBatchFromFishingOperation(id);
    }

    @Override
    public CatchBatch createCatchBatch(CatchBatch bean) {
        return this.catchBatchService.createCatchBatch(bean);
    }

    @Override
    public CatchBatch saveCatchBatch(CatchBatch bean) {
        return this.catchBatchService.saveCatchBatch(bean);
    }

    @Override
    public List<SpeciesBatch> getAllRootSpeciesBatch(String fishingOperationId) {
        return this.speciesBatchService.getAllRootSpeciesBatch(fishingOperationId);
    }

    @Override
    public SpeciesBatch createSpeciesBatch(SpeciesBatch bean, String parentBatchId) {
        return this.speciesBatchService.createSpeciesBatch(bean, parentBatchId);
    }

    @Override
    public SpeciesBatch saveSpeciesBatch(SpeciesBatch bean) {
        return this.speciesBatchService.saveSpeciesBatch(bean);
    }

    @Override
    public void deleteSpeciesBatch(String id) {
        this.speciesBatchService.deleteSpeciesBatch(id);
    }

    @Override
    public void deleteSpeciesSubBatch(String id) {
        this.speciesBatchService.deleteSpeciesSubBatch(id);
    }

    @Override
    public void changeSpeciesBatchSpecies(String batchId, Species species) {
        this.speciesBatchService.changeSpeciesBatchSpecies(batchId, species);
    }

    @Override
    public List<SpeciesBatchFrequency> getAllSpeciesBatchFrequency(String speciesBatchId) {
        return this.speciesBatchService.getAllSpeciesBatchFrequency(speciesBatchId);
    }

    @Override
    public List<SpeciesBatchFrequency> saveSpeciesBatchFrequency(String speciesBatchId, List<SpeciesBatchFrequency> frequencies) {
        return this.speciesBatchService.saveSpeciesBatchFrequency(speciesBatchId, frequencies);
    }

    @Override
    public List<BenthosBatch> getAllBenthosBatch(String fishingOperationId) {
        return this.benthosBatchService.getAllBenthosBatch(fishingOperationId);
    }

    @Override
    public BenthosBatch getBenthosBatch(String id) {
        return this.benthosBatchService.getBenthosBatch(id);
    }

    @Override
    public BenthosBatch createBenthosBatch(BenthosBatch bean) {
        return this.benthosBatchService.createBenthosBatch(bean);
    }

    @Override
    public BenthosBatch saveBenthosBatch(BenthosBatch bean) {
        return this.benthosBatchService.saveBenthosBatch(bean);
    }

    @Override
    public void deleteBenthosBatch(String id) {
        this.benthosBatchService.deleteBenthosBatch(id);
    }

    @Override
    public List<PlanktonBatch> getAllPlanktonBatch(String fishingOperationId) {
        return this.planktonBatchService.getAllPlanktonBatch(fishingOperationId);
    }

    @Override
    public PlanktonBatch getPlanktonBatch(String id) {
        return this.planktonBatchService.getPlanktonBatch(id);
    }

    @Override
    public PlanktonBatch createPlanktonBatch(PlanktonBatch bean) {
        return this.planktonBatchService.createPlanktonBatch(bean);
    }

    @Override
    public PlanktonBatch savePlanktonBatch(PlanktonBatch bean) {
        return this.planktonBatchService.savePlanktonBatch(bean);
    }

    @Override
    public void deletePlanktonBatch(String id) {
        this.planktonBatchService.deletePlanktonBatch(id);
    }

    @Override
    public List<MacroWasteBatch> getAllMacroWasteBatch(String fishingOperationId) {
        return this.macroWasteBatchService.getAllMacroWasteBatch(fishingOperationId);
    }

    @Override
    public MacroWasteBatch getMacroWasteBatch(String id) {
        return this.macroWasteBatchService.getMacroWasteBatch(id);
    }

    @Override
    public MacroWasteBatch createMacroWasteBatch(MacroWasteBatch bean) {
        return this.macroWasteBatchService.createMacroWasteBatch(bean);
    }

    @Override
    public MacroWasteBatch saveMacroWasteBatch(MacroWasteBatch bean) {
        return this.macroWasteBatchService.saveMacroWasteBatch(bean);
    }

    @Override
    public void deleteMacroWasteBatch(String id) {
        this.macroWasteBatchService.deleteMacroWasteBatch(id);
    }

    @Override
    public List<AccidentalBatch> getAllAccidentalBatch(String fishingOperationId) {
        return this.accidentalBatchService.getAllAccidentalBatch(fishingOperationId);
    }

    @Override
    public AccidentalBatch getAccidentalBatch(String id) {
        return this.accidentalBatchService.getAccidentalBatch(id);
    }

    @Override
    public AccidentalBatch createAccidentalBatch(AccidentalBatch bean) {
        return this.accidentalBatchService.createAccidentalBatch(bean);
    }

    @Override
    public AccidentalBatch saveAccidentalBatch(AccidentalBatch bean) {
        return this.accidentalBatchService.saveAccidentalBatch(bean);
    }

    @Override
    public void deleteAccidentalBatch(String id) {
        this.accidentalBatchService.deleteAccidentalBatch(id);
    }
}

