package fr.ifremer.tutti.ui.swing.util.editor;

/*
 * #%L
 * Tutti :: UI
 * $Id: LongTextEditorUIHandler.java 77 2012-12-15 16:05:45Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.0/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/util/editor/LongTextEditorUIHandler.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import jaxx.runtime.SwingUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

/**
 * Handler of the LongTextEditorUI
 *
 * @author kmorin
 * @since 0.2
 */
public class LongTextEditorUIHandler {

    private static final Log log =
            LogFactory.getLog(LongTextEditorUIHandler.class);

    private final LongTextEditorUI ui;

    public LongTextEditorUIHandler(LongTextEditorUI longTextEditorUI) {
        ui = longTextEditorUI;

        ui.addPropertyChangeListener(new PropertyChangeListener() {

            public void propertyChange(PropertyChangeEvent evt) {
                Object bean = ui.getBean();
                String property = ui.getProperty();
                if (bean != null && !StringUtils.isEmpty(property)) {
                    Object value = TuttiUIUtil.getProperty(bean, property);
                    ui.getTextContent().setText(SwingUtil.getStringValue(value));
                }
            }
        });
    }

    /** pushes the typed text in the property of the bean */
    public void setText(String value) {
        Object bean = ui.getBean();
        String property = ui.getProperty();
        TuttiUIUtil.setProperty(bean, property, value);
    }

    /** closes the editor */
    public void close() {
        if (log.isInfoEnabled()) {
            log.info("Will close UI " + ui);
        }
        SwingUtil.getParentContainer(ui, Window.class).dispose();
    }

}
