package fr.ifremer.tutti.ui.swing.content.program;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.referential.Zone;
import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.getStringValue;
import static org.nuiton.i18n.I18n._;

public class EditProgramUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<EditProgramUIModel, EditProgramUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_COMMENT_FIELD_TEXT = "commentField.text";
    public static final String BINDING_NAME_FIELD_TEXT = "nameField.text";
    public static final String BINDING_SAVE_BUTTON_ENABLED = "saveButton.enabled";
    public static final String BINDING_ZONE_COMBO_BOX_SELECTED_ITEM = "zoneComboBox.selectedItem";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJ1WS28jRRBuO4nzJGE32pCFfQQTgi3CZANCgBKWTUJMEmUhWhu02hzC2NNOeul50NNOxlhB/AR+Aty5IHHjwooDZw57QfwFhDhwRVT1jGc89tiTbKSMku6qr6u+qvq6f/iLjLiCvPxY9zxNNCzJTKrtbTx8+En1Ma3JD6lbE8yRtiD+TyZLsodk0gjXXUleOdxH95XAfWXLNh3bolaH99o+mXBlk1P3hFIpyc24R811V8rh9prnNEQbNQwqCfW7f/7Ofmt8832WEM+B6GYglYU0ryiT4X2SZYYkV+GkU32F69YxhCGYdQzxPodrW1x33Y91k35Jviaj+yTn6ALAJMlfPGWFofw9R5JZajB5IOxjoZsV2znQLcoleacuNFYX1KRCkw0pmdZgmnsGkWg125IArDm+j7Yd+X+66zgKOSfJ6IluGZwKSe4+I9aODxBBjpi2gcGtPyPgfXSP4HJVYX+BARb741Xw3x3w2lS2kfP4qc6ZoQOvkrweq3C4EUCU8ftZezFCGK7bwpRkPuYcnKpXuarweHSeBUXf16uY/1XsBC+w3VOLaDUfNy4xyqGX5mLGFepJtdHl8BU0Swh0M745hZvQUFV70/YkeTshYOwhSLhKdUvbhE+JcUkFZtH2i0NO1mzThDpht0nyQizEck3YnONOVxiBT5DXtZ68NgTV0XYpdBlb3FP9fKebM7XaDa9bNco3oeDQQ2Q2Zu+vouVy6DDh6qc02lgNdgV5KUYQSIkWSUk065lDMiIasAwtcNirPg9gy9ed+S7dQUC1+9/c7NOf//yp1BabaTj7WqJph1aCCMBsOND2DI+e8ZWmIRlfua87a4dk3KUchFYJ6Y2EwMrBNgQH511Bdw3dtR3dPQGIkdE/nvw69/nvQyRbIhPc1o2Sjva7ZFyeCGDB5obnfHBPRTR1Ngbf5+F3CAYC2weEo6XG/BwYZqvvWgeC1hm03Yw/mUHwTQ2aFrDOHlAX9XtYigb1gK0bCWyFIVfHf/t3tvzjvTZjGcjgel/ziLWRRyTHLM5gRlCgA+1NFORJx6UNw440Nkl1CejuXPKcBPrwnvq+30NTBlTw6AT0SJJbrbyiBP/TOkRcw4X8uddAhG2VJf71EUnWeif9xFzVFgYK5Z3WpvrLr2hTq8HESVphklPD3ykU/PuqaDU4LyYGoXQv7dRhGF6OelRCgZ1shYJ2jrWGYYep8RtCWYV6j3ZgL22bV5hTUYaLyTTVEU45aBIuyJDXYj9eOxz6UxzpdFqK2TCTK37Ha8dUYicVipDkzFF4jwSqf7t1VMj3yzmfzHV0EaRFM9TN2muDSAik2CcubI/19PboSiHAyRcx5XYBlgcXoH12/xp03i4Xr8JiC/j3uxdu6wYthEXZ8uEKxeTCvNhdmDCrxOhi99jl5mC61XkVp4wCml5qFNDhUqOgHAaMQviouEDzTfnXDjV2JTVjI/EIUNRIjLW1H/L2k7vEkKBDv4J0kpoW6ihcUNRCxYY3yKtBlMyFpyWrNwvFhaWlhfaaevOpyONlgulgtqXh8yHgE3IzLWraFqtJktmGm8+32cXnLBlGSwjzSLlvqB1JrrfKEYC/qNXwjjnvLvpycg17w4gXf7Vf8RMc+zdBxyspjdpcSNStGFH+w6zjJR+na6OLrpxv30PY7dZWN9BA2t4cmH1PUHHy3kohz3dPpy/2Kr3IVc31pg3GZHodxkJfqDLLAEG724Odwe/EBRDH8FVWaTrqgfMkGWcxFQeXfxmA8AYg/A8+ELzE+w8AAA==";
    private static final Log log = LogFactory.getLog(EditProgramUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected TuttiHelpBroker broker;
    protected JButton cancelButton;
    protected JTextArea commentField;
    @ValidatorField( validatorId = "validator",  propertyName = "comment",  editorName = "commentPane")
    protected JScrollPane commentPane;
    protected EditProgramUI editProgramTopPanel = this;
    protected Table form;
    protected EditProgramUIHandler handler;
    protected EditProgramUIModel model;
    @ValidatorField( validatorId = "validator",  propertyName = "name",  editorName = "nameField")
    protected JTextField nameField;
    protected JLabel nameLabel;
    protected JButton saveButton;
    @Validator( validatorId = "validator")
    protected SwingValidator<EditProgramUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();
    @ValidatorField( validatorId = "validator",  propertyName = "zone",  editorName = "zoneComboBox")
    protected BeanFilterableComboBox<Zone> zoneComboBox;
    protected JLabel zoneLabel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
          protected void $afterCompleteSetup() {
              handler.afterInitUI();
          }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public EditProgramUI(TuttiUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
                  EditProgramUIHandler handler = new EditProgramUIHandler(parentUI, this);
                  setContextValue(handler);
                  handler.beforeInitUI();
            $initialize();
    }

    public EditProgramUI() {
        $initialize();
    }

    public EditProgramUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditProgramUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public EditProgramUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditProgramUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public EditProgramUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditProgramUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EditProgramUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doFocusGained__on__commentPane(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        commentField.requestFocus();
    }

    public void doKeyReleased__on__commentField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "comment");
    }

    public void doKeyReleased__on__nameField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "name");
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JButton getCancelButton() {
        return cancelButton;
    }

    public JTextArea getCommentField() {
        return commentField;
    }

    public JScrollPane getCommentPane() {
        return commentPane;
    }

    public Table getForm() {
        return form;
    }

    public EditProgramUIHandler getHandler() {
        return handler;
    }

    public EditProgramUIModel getModel() {
        return model;
    }

    public JTextField getNameField() {
        return nameField;
    }

    public JLabel getNameLabel() {
        return nameLabel;
    }

    public JButton getSaveButton() {
        return saveButton;
    }

    public SwingValidator<EditProgramUIModel> getValidator() {
        return validator;
    }

    public BeanFilterableComboBox<Zone> getZoneComboBox() {
        return zoneComboBox;
    }

    public JLabel getZoneLabel() {
        return zoneLabel;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToCommentPane() {
        if (!allComponentsCreated) {
            return;
        }
        commentPane.getViewport().add(commentField);
    }

    protected void addChildrenToEditProgramTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(form);
    }

    protected void addChildrenToForm() {
        if (!allComponentsCreated) {
            return;
        }
        form.add(nameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(SwingUtil.boxComponentWithJxLayer(nameField), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(zoneLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(SwingUtil.boxComponentWithJxLayer(zoneComboBox), new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(SwingUtil.boxComponentWithJxLayer(commentPane), new GridBagConstraints(0, 2, 2, 1, 0.0, 0.8, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add($JPanel0, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 15, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tuttihelp.editProgram.help"));
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(_("tutti.action.cancelEditProgram"));
        cancelButton.setMnemonic(65);
        cancelButton.setToolTipText(_("tuttihelp.editProgram.action.cancelEditProgram.tip"));
        cancelButton.putClientProperty("help", "tuttihelp.editProgram.action.cancelProgram.help");
        cancelButton.putClientProperty("tuttiAction", CancelEditProgramAction.class);
    }

    protected void createCommentField() {
        $objectMap.put("commentField", commentField = new JTextArea());
        
        commentField.setName("commentField");
        commentField.setColumns(15);
        commentField.setLineWrap(true);
        commentField.setWrapStyleWord(true);
        commentField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__commentField"));
        commentField.putClientProperty("validatorLabel", _("tutti.label.comment"));
    }

    protected void createCommentPane() {
        $objectMap.put("commentPane", commentPane = new JScrollPane());
        
        commentPane.setName("commentPane");
        commentPane.setToolTipText(_("tuttihelp.editProgram.field.comment.tip"));
        commentPane.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusGained", this, "doFocusGained__on__commentPane"));
        commentPane.putClientProperty("help", "tuttihelp.editProgram.field.comment.help");
    }

    protected void createForm() {
        $objectMap.put("form", form = new Table());
        
        form.setName("form");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(EditProgramUIHandler.class));
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(EditProgramUIModel.class));
    }

    protected void createNameField() {
        $objectMap.put("nameField", nameField = new JTextField());
        
        nameField.setName("nameField");
        nameField.setColumns(15);
        nameField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__nameField"));
        nameField.putClientProperty("validatorLabel", _("tutti.label.program.name"));
    }

    protected void createNameLabel() {
        $objectMap.put("nameLabel", nameLabel = new JLabel());
        
        nameLabel.setName("nameLabel");
        nameLabel.setText(_("tutti.label.program.name"));
        nameLabel.setToolTipText(_("tuttihelp.editProgram.field.name.tip"));
        nameLabel.putClientProperty("help", "tuttihelp.editProgram.field.name.help");
    }

    protected void createSaveButton() {
        $objectMap.put("saveButton", saveButton = new JButton());
        
        saveButton.setName("saveButton");
        saveButton.setText(_("tutti.action.saveProgram"));
        saveButton.setMnemonic(69);
        saveButton.setToolTipText(_("tuttihelp.editProgram.action.saveProgram.tip"));
        saveButton.putClientProperty("help", "tuttihelp.editProgram.action.saveProgram.help");
        saveButton.putClientProperty("tuttiAction", SaveProgramAction.class);
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(EditProgramUIModel.class, null));
    }

    protected void createZoneComboBox() {
        $objectMap.put("zoneComboBox", zoneComboBox = new BeanFilterableComboBox<Zone>(this));
        
        zoneComboBox.setName("zoneComboBox");
        zoneComboBox.setI18nPrefix("tutti.property.");
        zoneComboBox.setProperty("zone");
        zoneComboBox.setShowReset(true);
        zoneComboBox.putClientProperty("validatorLabel", _("tutti.label.program.zone"));
    }

    protected void createZoneLabel() {
        $objectMap.put("zoneLabel", zoneLabel = new JLabel());
        
        zoneLabel.setName("zoneLabel");
        zoneLabel.setText(_("tutti.label.program.zone"));
        zoneLabel.setToolTipText(_("tuttihelp.editProgram.field.zone.tip"));
        zoneLabel.putClientProperty("help", "tuttihelp.editProgram.field.zone.help");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToEditProgramTopPanel();
        addChildrenToValidator();
        addChildrenToForm();
        addChildrenToCommentPane();
        // inline complete setup of $JPanel0
        $JPanel0.add(cancelButton);
        $JPanel0.add(saveButton);
        
        // apply 4 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 10 property setters
        zoneComboBox.setBeanType(Zone.class);
        form.setBorder(BorderFactory.createTitledBorder((String)null));
        nameLabel.setLabelFor(nameField);
        zoneLabel.setLabelFor(zoneComboBox);
        zoneComboBox.setBean(model);
        commentPane.setBorder(BorderFactory.createTitledBorder(_("tutti.label.comment")));
        cancelButton.setIcon(SwingUtil.createActionIcon("cancel"));
        saveButton.setIcon(SwingUtil.createActionIcon("save"));
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, editProgramTopPanel, "tuttihelp.editProgram.help");
        registerHelpId(_broker, nameLabel, "tuttihelp.editProgram.field.name.help");
        registerHelpId(_broker, zoneLabel, "tuttihelp.editProgram.field.zone.help");
        registerHelpId(_broker, commentPane, "tuttihelp.editProgram.field.comment.help");
        registerHelpId(_broker, cancelButton, "tuttihelp.editProgram.action.cancelProgram.help");
        registerHelpId(_broker, saveButton, "tuttihelp.editProgram.action.saveProgram.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("editProgramTopPanel", editProgramTopPanel);
        createHandler();
        createModel();
        createBroker();
        createValidator();
        createForm();
        createNameLabel();
        createNameField();
        createZoneLabel();
        createZoneComboBox();
        createCommentPane();
        createCommentField();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1, 0));
        createCancelButton();
        createSaveButton();
        // inline creation of editProgramTopPanel
        setName("editProgramTopPanel");
        setLayout(new BorderLayout());
        editProgramTopPanel.putClientProperty("help", "tuttihelp.editProgram.help");
        
        // registers 4 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 4 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NAME_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("name", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(nameField, model.getName());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("name", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ZONE_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("zone", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    zoneComboBox.setSelectedItem(model.getZone());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("zone", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COMMENT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("comment", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(commentField, getStringValue(model.getComment()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("comment", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_BUTTON_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("modify", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveButton.setEnabled(model.isModify() && model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("modify", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
    }

}