package fr.ifremer.tutti.ui.swing.content.campaign;

/*
 * #%L
 * Tutti :: UI
 * $Id: EditCampaignUIHandler.java 18 2012-11-25 18:23:49Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-0.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/campaign/EditCampaignUIHandler.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.CampaignBean;
import fr.ifremer.tutti.persistence.entities.SurveyBean;
import fr.ifremer.tutti.persistence.entities.UserBean;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.TuttiScreen;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableRenderer;
import jaxx.runtime.validator.swing.SwingValidatorUtil;

import java.util.List;

/**
 * Handler of UI {@link EditCampaignUI}.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public class EditCampaignUIHandler extends AbstractTuttiUIHandler<EditCampaignUIModel> {

    private final EditCampaignUI ui;

    private final PersistenceService persistenceService;

    public EditCampaignUIHandler(TuttiUIContext context, EditCampaignUI ui) {
        super(context);
        this.ui = ui;
        persistenceService = context.getService(PersistenceService.class);
    }

    @Override
    public void beforeInitUI() {

        EditCampaignUIModel model = new EditCampaignUIModel();

        String campaignId = context.getCampaignId();
        if (campaignId == null) {

            SurveyBean survey =
                    persistenceService.getSurvey(context.getSurveyId());
            model.setSurvey(survey);
        } else {

            // load existing survey
            CampaignBean campaign = persistenceService.getCampaign(campaignId);

            model.fromBean(campaign);
        }
        listModelIsModify(model);
        ui.setContextValue(model);
    }

    @Override
    public void afterInitUI() {

        List<UserBean> users = persistenceService.getAllUsers();

        EditCampaignUIModel model = ui.getModel();

        initBeanComboBox(ui.getSurveyComboBox(),
                         persistenceService.getAllSurveys(),
                         model.getSurvey());

        initBeanComboBox(ui.getCountryComboBox(),
                         persistenceService.getAllCountries(),
                         model.getCountry());

        initBeanList(ui.getVesselHeader(),
                     persistenceService.getAllVessels(),
                     model.getVessel());

        initBeanList(ui.getGearHeader(),
                     persistenceService.getAllGears(),
                     model.getGear());

        initBeanList(ui.getHeadOfMissionHeader(),
                     users,
                     model.getHeadOfMission());

        initBeanList(ui.getHeadOfSortRoomHeader(),
                     users,
                     model.getHeadOfSortRoom());

        SwingValidatorUtil.installUI(ui.getErrorTable(),
                                     new SwingValidatorMessageTableRenderer());

        listenValidatorValid(ui.getValidator(), model);

        // if new trait can already cancel his creation
        model.setModify(model.isCreate());
    }

    @Override
    public void onCloseUI() {
    }

    @Override
    protected EditCampaignUIModel getModel() {
        return ui.getModel();
    }

    public void cancel() {

        context.setScreen(TuttiScreen.SELECT_CAMPAIGN);
    }

    public void save() {

        EditCampaignUIModel model = ui.getModel();

        CampaignBean bean = model.toBean();

        CampaignBean saved;
        if (model.isCreate()) {

            saved = persistenceService.createCampaign(bean);
        } else {
            saved = persistenceService.saveCampaign(bean);
        }

        context.setSurveyId(saved.getSurvey().getId());
        context.setCampaignId(saved.getId());

        context.setScreen(TuttiScreen.SELECT_CAMPAIGN);
    }

    public void importCasino() {

    }

}
