/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.executor.l18n;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.internal.executor.l18n.LocalizedReportExecutor;
import org.eclipse.birt.report.engine.internal.executor.wrap.WrappedReportItemExecutor;
import org.eclipse.birt.report.engine.presentation.LocalizedContentVisitor;

class LocalizedReportItemExecutor
extends WrappedReportItemExecutor {
    LocalizedContentVisitor l18nVisitor;

    LocalizedReportItemExecutor(LocalizedReportExecutor reportExecutor, IReportItemExecutor executor) {
        super(reportExecutor, executor);
        this.l18nVisitor = reportExecutor.l18nVisitor;
    }

    @Override
    public IContent execute() throws BirtException {
        IContent content = super.execute();
        if (content != null) {
            content = this.l18nVisitor.localize(content);
        }
        return content;
    }
}

