/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ichtyometer.tool;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.ichtyometer.IchtyometerClient;
import fr.ifremer.tutti.ichtyometer.RemoteDeviceChooser;
import fr.ifremer.tutti.ichtyometer.interactive.Command;
import fr.ifremer.tutti.ichtyometer.interactive.CommandEngine;
import java.io.Console;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SendCommandTool {
    private static final Log log = LogFactory.getLog(SendCommandTool.class);

    public static void main(String[] args) throws IOException {
        final Console console = System.console();
        final PrintWriter writer = console.writer();
        writer.println("CommandTool: to send command to the board and wait a result v1.0");
        RemoteDeviceChooser remoteDeviceChooser = new RemoteDeviceChooser(){

            @Override
            public String chooseRemoteDevice(Set<String> remoteDeviceNames) {
                ArrayList remoteDeviceNameList = Lists.newArrayList(remoteDeviceNames);
                writer.println("Choose you device");
                int i = 0;
                for (String remoteDeviceName : remoteDeviceNameList) {
                    writer.println(i++ + " for device " + remoteDeviceName);
                }
                writer.println("q (to quit)");
                writer.print("Your choice: ");
                writer.flush();
                String command = console.readLine();
                if ("q".equals(command)) {
                    System.exit(0);
                }
                String deviceName = (String)remoteDeviceNameList.get(Integer.valueOf(command));
                return deviceName;
            }
        };
        IchtyometerClient client = new IchtyometerClient();
        client.open(remoteDeviceChooser, true);
        CommandEngine reader = new CommandEngine();
        writer.println("client " + client + " is ready.open and wait for a command");
        reader.start(client);
        boolean quit = false;
        block7: while (!quit) {
            ConsoleCommand checkCommand;
            writer.print("new command: [a, b, c, d, e, f, g or q to quit]:");
            writer.flush();
            String command = console.readLine();
            try {
                checkCommand = ConsoleCommand.valueOf(command);
            }
            catch (IllegalArgumentException e) {
                writer.println("Command " + command + " not possible");
                continue;
            }
            switch (checkCommand) {
                case q: {
                    reader.stop();
                    quit = true;
                    continue block7;
                }
            }
            try {
                Command sendCommand = reader.sendCommand(checkCommand.name().charAt(0));
                writer.println(String.format("------------------------------------------------------------------------------\n%s\n------------------------------------------------------------------------------", sendCommand.getResponse()));
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) continue;
                log.error((Object)"Something wrong happen", (Throwable)e);
            }
        }
    }

    static enum ConsoleCommand {
        a,
        b,
        c,
        d,
        e,
        g,
        q;

    }
}

