/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.http;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import javax.servlet.GenericServlet;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public abstract class HttpServlet
extends GenericServlet
implements Serializable {
    static final String METHOD_DELETE = "DELETE";
    static final String METHOD_HEAD = "HEAD";
    static final String METHOD_GET = "GET";
    static final String METHOD_OPTIONS = "OPTIONS";
    static final String METHOD_POST = "POST";
    static final String METHOD_PUT = "PUT";
    static final String METHOD_TRACE = "TRACE";
    static final String HEADER_IFMODSINCE = "If-Modified-Since";
    static final String HEADER_LASTMOD = "Last-Modified";

    public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            throw new IllegalArgumentException("Not an Http servlet request - invalid types");
        }
        this.service((HttpServletRequest)request, (HttpServletResponse)response);
    }

    private void notAcceptedMethod(HttpServletRequest request, HttpServletResponse response, String method) throws ServletException, IOException {
        if (request.getProtocol().endsWith("1.1")) {
            response.sendError(405, method + " not allowed");
        } else {
            response.sendError(400, method + " not allowed");
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.notAcceptedMethod(req, resp, METHOD_GET);
    }

    protected long getLastModified(HttpServletRequest req) {
        return -1L;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.notAcceptedMethod(req, resp, METHOD_POST);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.notAcceptedMethod(req, resp, METHOD_PUT);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.notAcceptedMethod(req, resp, METHOD_DELETE);
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.notAcceptedMethod(req, resp, METHOD_OPTIONS);
    }

    protected void doTrace(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.notAcceptedMethod(req, resp, METHOD_TRACE);
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String method = request.getMethod();
        if (method.equals(METHOD_GET)) {
            long lastModified = this.getLastModified(request);
            if (lastModified == -1L) {
                this.doGet(request, response);
            } else {
                long ifModifiedSince = request.getDateHeader(HEADER_IFMODSINCE);
                if (ifModifiedSince < lastModified / 1000L * 1000L) {
                    if (!response.containsHeader(HEADER_LASTMOD) && lastModified >= 0L) {
                        response.setDateHeader(HEADER_LASTMOD, lastModified);
                    }
                    this.doGet(request, response);
                } else {
                    response.setStatus(304);
                }
            }
        } else if (method.equals(METHOD_HEAD)) {
            long lastModified = this.getLastModified(request);
            if (!response.containsHeader(HEADER_LASTMOD) && lastModified >= 0L) {
                response.setDateHeader(HEADER_LASTMOD, lastModified);
            }
            this.doHead(request, response);
        } else if (method.equals(METHOD_POST)) {
            this.doPost(request, response);
        } else if (method.equals(METHOD_PUT)) {
            this.doPut(request, response);
        } else if (method.equals(METHOD_DELETE)) {
            this.doDelete(request, response);
        } else if (method.equals(METHOD_OPTIONS)) {
            this.doOptions(request, response);
        } else if (method.equals(METHOD_TRACE)) {
            this.doTrace(request, response);
        } else {
            this.notAcceptedMethod(request, response, method);
        }
    }

    protected void doHead(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        NoBodyResponse response = new NoBodyResponse(resp);
        this.doGet(req, response);
        response.setContentLength();
    }

    class NoBodyOutputStream
    extends ServletOutputStream {
        private int contentLength = 0;

        NoBodyOutputStream() {
        }

        int getContentLength() {
            return this.contentLength;
        }

        public void write(int b) throws IOException {
            ++this.contentLength;
        }

        public void write(byte[] buf, int offset, int len) throws IOException {
            this.contentLength += len;
        }
    }

    class NoBodyResponse
    extends HttpServletResponseWrapper {
        private NoBodyOutputStream noBody;
        private PrintWriter writer;
        private boolean contentLengthSet;

        NoBodyResponse(HttpServletResponse mainResponse) {
            super(mainResponse);
            this.noBody = new NoBodyOutputStream();
        }

        void setContentLength() {
            if (!this.contentLengthSet) {
                this.setContentLength(this.noBody.getContentLength());
            }
        }

        public void setContentLength(int length) {
            super.setContentLength(length);
            this.contentLengthSet = true;
        }

        public void setContentType(String type) {
            this.getResponse().setContentType(type);
        }

        public ServletOutputStream getOutputStream() throws IOException {
            return this.noBody;
        }

        public String getCharacterEncoding() {
            return this.getResponse().getCharacterEncoding();
        }

        public PrintWriter getWriter() throws UnsupportedEncodingException {
            if (this.writer == null) {
                this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.noBody, this.getCharacterEncoding()));
            }
            return this.writer;
        }
    }
}

