/*
 * *##% 
 * SuiviObsmer :: Web Interface
 * Copyright (C) 2009 - 2010 Ifremer
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */

package fr.ifremer.suiviobsmer.ui.services;

import fr.ifremer.suiviobsmer.SuiviObsmerException;
import fr.ifremer.suiviobsmer.SuiviObsmerRunner;
import fr.ifremer.suiviobsmer.SuiviObsmerRunnerImpl;
import org.apache.tapestry5.ioc.services.RegistryShutdownListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * SuiviObsmerManager
 *
 * Created: 24 nov. 2009
 *
 * @author fdesbois
 * @version $Revision$
 *
 * Mise a jour: $Date$
 * par : $Author$
 */
public class SuiviObsmerManager implements Runnable, RegistryShutdownListener {

    private static final Logger log = LoggerFactory.getLogger(SuiviObsmerManager.class);

    private SuiviObsmerRunner runner;

    @Override
    public void run() {
        runner = new SuiviObsmerRunnerImpl();
        try {
            if (log.isInfoEnabled()) {
                log.info("Start SuiviObsmer");
            }
            runner.start();
        } catch (SuiviObsmerException eee) {
            if (log.isErrorEnabled()) {
                log.error("Error on start", eee);
            }
        }
    }

    @Override
    public void registryDidShutdown() {
        // No problem with reinstanciate the runner, all context is in SuiviObsmerContext which is static
        runner = new SuiviObsmerRunnerImpl();
        try {
            if (log.isInfoEnabled()) {
                log.info("Stop SuiviObsmer");
            }
            runner.stop();
        } catch (SuiviObsmerException eee) {
            if (log.isErrorEnabled()) {
                log.error("Error on stop", eee);
            }
        }
    }

}
