/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.suiviobsmer.ui.base;

import fr.ifremer.suiviobsmer.SuiviObsmerException;
import fr.ifremer.suiviobsmer.bean.BoatFilter;
import fr.ifremer.suiviobsmer.bean.SamplingFilter;
import fr.ifremer.suiviobsmer.entity.Company;
import fr.ifremer.suiviobsmer.entity.SampleRow;
import fr.ifremer.suiviobsmer.entity.WaoUser;
import fr.ifremer.suiviobsmer.services.ServiceBoat;
import fr.ifremer.suiviobsmer.services.ServiceReferential;
import fr.ifremer.suiviobsmer.services.ServiceSampling;
import fr.ifremer.suiviobsmer.services.ServiceUser;
import fr.ifremer.suiviobsmer.ui.base.GenericSelectModel;
import java.util.ArrayList;
import java.util.List;
import org.apache.tapestry5.SelectModel;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.internal.OptionModelImpl;
import org.apache.tapestry5.internal.SelectModelImpl;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.services.PropertyAccess;
import org.slf4j.Logger;

public abstract class AbstractFilteredPage {
    @Inject
    private Logger log;
    @SessionState
    private WaoUser user;
    @Inject
    private PropertyAccess propertyAccess;
    @Inject
    private ServiceReferential serviceReferential;
    @Inject
    private ServiceSampling serviceSampling;
    @Inject
    private ServiceBoat serviceBoat;
    @Inject
    private ServiceUser serviceUser;
    @Persist
    private GenericSelectModel<SampleRow> sampleRowSelectModel;
    @Property
    private String sampleRowId;
    @Persist
    private SelectModel facadeSelectModel;
    @Persist
    private SelectModel sectorSelectModel;
    @Persist
    private GenericSelectModel<Company> companySelectModel;
    @Property
    private String companyId;
    @Persist
    private GenericSelectModel<WaoUser> observerSelectModel;
    @Property
    private String observerId;
    private boolean edited;

    protected void initSelectFilters(boolean companySelect, boolean observerSelect) throws SuiviObsmerException {
        if (this.getFilter().getSampleRow() != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("SampleRow filtered : " + this.getFilter().getSampleRow());
            }
            this.sampleRowId = this.getFilter().getSampleRow().getTopiaId();
        }
        if (this.user.getAdmin() && companySelect) {
            this.companySelectModel = null;
            this.getCompanySelectModel();
            if (this.getFilter().getCompany() != null) {
                this.companyId = this.getFilter().getCompany().getTopiaId();
            }
        } else if (!this.user.getAdmin()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Company filtered : " + this.user.getCompany());
            }
            this.getFilter().setCompany(this.user.getCompany());
        }
        if (observerSelect) {
            this.observerSelectModel = null;
            this.getObserverSelectModel();
            if (this.getFilter().getObserver() != null) {
                this.observerId = this.getFilter().getObserver().getTopiaId();
            }
        }
        this.resetFacadeSelect();
        this.resetSectorSelect();
        this.resetSampleRowSelect();
    }

    protected void resetFacadeSelect() throws SuiviObsmerException {
        this.facadeSelectModel = null;
        this.getFacadeSelectModel();
    }

    protected void resetSectorSelect() throws SuiviObsmerException {
        this.sectorSelectModel = null;
        this.getSectorSelectModel();
    }

    protected void resetSampleRowSelect() throws SuiviObsmerException {
        this.sampleRowSelectModel = null;
        this.getSampleRowSelectModel();
    }

    public SelectModel getFacadeSelectModel() throws SuiviObsmerException {
        if (this.facadeSelectModel == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info("BUSINESS REQUEST [getFacades]");
            }
            ArrayList<OptionModelImpl> options = new ArrayList<OptionModelImpl>();
            for (String facadeName : this.serviceReferential.getFacades(this.getFilter().getCompany())) {
                options.add(new OptionModelImpl(facadeName, (Object)facadeName));
            }
            this.facadeSelectModel = new SelectModelImpl(null, options);
        }
        return this.facadeSelectModel;
    }

    public SelectModel getSectorSelectModel() throws SuiviObsmerException {
        if (this.sectorSelectModel == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info("BUSINESS REQUEST [getSectors]");
            }
            ArrayList<OptionModelImpl> options = new ArrayList<OptionModelImpl>();
            for (String sectorName : this.serviceReferential.getSectors(this.getFilter().getCompany(), this.getFilter().getFacadeName())) {
                options.add(new OptionModelImpl(sectorName, (Object)sectorName));
            }
            this.sectorSelectModel = new SelectModelImpl(null, options);
        }
        return this.sectorSelectModel;
    }

    public GenericSelectModel<SampleRow> getSampleRowSelectModel() throws SuiviObsmerException {
        if (this.sampleRowSelectModel == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info("BUSINESS REQUEST [getSampleRowsByFilter]");
            }
            SampleRow rowFiltered = this.getFilter().getSampleRow();
            this.getFilter().setSampleRow(null);
            List sampleRows = this.serviceSampling.getSampleRowsByFilter((SamplingFilter)this.getFilter());
            this.getFilter().setSampleRow(rowFiltered);
            this.sampleRowSelectModel = new GenericSelectModel(sampleRows, SampleRow.class, "code", "topiaId", this.propertyAccess);
        }
        return this.sampleRowSelectModel;
    }

    public GenericSelectModel<Company> getCompanySelectModel() throws SuiviObsmerException {
        if (this.companySelectModel == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("BUSINESS REQUEST [getCompanies]");
            }
            List companies = this.serviceUser.getCompanies(this.getAvailableDataForFiltersOnly());
            this.companySelectModel = new GenericSelectModel(companies, Company.class, "name", "topiaId", this.propertyAccess);
        }
        return this.companySelectModel;
    }

    public GenericSelectModel<WaoUser> getObserverSelectModel() throws SuiviObsmerException {
        if (this.observerSelectModel == null) {
            List observers = new ArrayList();
            if (this.getFilter().getCompany() != null) {
                observers = this.getFilter().getCompany().getWaoUser();
            } else if (this.user.getAdmin()) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("BUSINESS REQUEST [getObservers]");
                }
                observers = this.serviceUser.getObservers(this.getAvailableDataForFiltersOnly());
            }
            this.observerSelectModel = new GenericSelectModel(observers, WaoUser.class, "fullName", "topiaId", this.propertyAccess);
        }
        return this.observerSelectModel;
    }

    protected abstract BoatFilter getFilter() throws SuiviObsmerException;

    protected abstract boolean getAvailableDataForFiltersOnly();

    public String[] onProvideCompletionsFromBoatName(String input) throws SuiviObsmerException {
        if (this.log.isInfoEnabled()) {
            this.log.info("BUSINESS REQUEST [getBoatNamesStartWith]");
        }
        List results = this.serviceBoat.getBoatNamesStartWith(input);
        return results.toArray(new String[0]);
    }

    public void onSelectedFromSearch() throws SuiviObsmerException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("REFRESH FILTERS DATA");
        }
        SampleRow row = (SampleRow)this.getSampleRowSelectModel().findObject(this.sampleRowId);
        this.getFilter().setSampleRow(row);
        if (this.user.getAdmin()) {
            Company company = (Company)this.getCompanySelectModel().findObject(this.companyId);
            this.getFilter().setCompany(company);
        } else {
            this.getFilter().setCompany(this.user.getCompany());
        }
        WaoUser observer = (WaoUser)this.getObserverSelectModel().findObject(this.observerId);
        this.getFilter().setObserver(observer);
    }

    public void onSelectedFromRefreshByCompany() throws SuiviObsmerException {
        this.getFilter().setFacadeName(null);
        this.onSelectedFromRefreshByFacade();
        this.resetFacadeSelect();
        this.getFilter().setObserver(null);
        this.observerSelectModel = null;
        this.getObserverSelectModel();
        this.edited = true;
    }

    public void onSelectedFromRefreshByFacade() throws SuiviObsmerException {
        this.getFilter().setSectorName(null);
        this.onSelectedFromRefreshBySector();
        this.resetSectorSelect();
    }

    public void onSelectedFromRefreshBySector() throws SuiviObsmerException {
        this.onSelectedFromSearch();
        this.getFilter().setSampleRow(null);
        this.resetSampleRowSelect();
        this.edited = true;
    }

    protected boolean isEdited() {
        return this.edited;
    }
}

