/*
 * *##% 
 * SuiviObsmer :: Web Interface
 * Copyright (C) 2009 - 2010 Ifremer
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */

package fr.ifremer.suiviobsmer.ui.pages;

import fr.ifremer.suiviobsmer.SuiviObsmerContext;
import fr.ifremer.suiviobsmer.SuiviObsmerException;
import fr.ifremer.suiviobsmer.bean.BoatFilterImpl;
import fr.ifremer.suiviobsmer.entity.Boat;
import fr.ifremer.suiviobsmer.bean.BoatFilter;
import fr.ifremer.suiviobsmer.bean.CompanyBoatInfos;
import fr.ifremer.suiviobsmer.bean.SamplingFilter;
import fr.ifremer.suiviobsmer.bean.SamplingFilterImpl;
import fr.ifremer.suiviobsmer.entity.BoatInfos;
import fr.ifremer.suiviobsmer.entity.Company;
import fr.ifremer.suiviobsmer.entity.Contact;
import fr.ifremer.suiviobsmer.entity.ElligibleBoat;
import fr.ifremer.suiviobsmer.entity.FishingZone;
import fr.ifremer.suiviobsmer.entity.Profession;
import fr.ifremer.suiviobsmer.entity.SampleRow;
import fr.ifremer.suiviobsmer.entity.User;
import fr.ifremer.suiviobsmer.services.ServiceBoat;
import fr.ifremer.suiviobsmer.services.ServiceReferential;
import fr.ifremer.suiviobsmer.services.ServiceSampling;
import fr.ifremer.suiviobsmer.services.ServiceUser;
import fr.ifremer.suiviobsmer.ui.data.BusinessUtils;
import fr.ifremer.suiviobsmer.ui.base.GenericSelectModel;
import fr.ifremer.suiviobsmer.ui.base.SuiviObsmerPage;
import fr.ifremer.suiviobsmer.ui.components.FeedBack;
import fr.ifremer.suiviobsmer.ui.components.Layout;
import fr.ifremer.suiviobsmer.ui.data.BoatDataSource;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry5.Block;
import org.apache.tapestry5.EventContext;
import org.apache.tapestry5.StreamResponse;
import org.apache.tapestry5.annotations.IncludeStylesheet;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.InjectPage;
import org.apache.tapestry5.annotations.Log;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.corelib.components.Form;
import org.apache.tapestry5.corelib.components.Zone;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.services.PropertyAccess;
import org.apache.tapestry5.services.Response;
import org.apache.tapestry5.upload.services.UploadedFile;
import org.slf4j.Logger;

/**
 * Boats
 *
 * Created: 9 nov. 2009
 *
 * @author fdesbois
 * @version $Revision: 248 $
 *
 * Mise a jour: $Date: 2010-01-20 13:00:12 +0100 (mer., 20 janv. 2010) $
 * par : $Author: fdesbois $
 */
@IncludeStylesheet("context:css/boats.css")
public class Boats implements SuiviObsmerPage {

    @Override
    public boolean isOnlyForAdmin() {
        return false;
    }

    @Inject
    private Logger log;

    @InjectComponent
    private Layout layout;

    @SessionState
    @Property
    private User user;

    @Inject
    private ServiceReferential serviceReferential;

    @Inject
    private ServiceSampling serviceSampling;

    @Inject
    private ServiceBoat serviceBoat;

    @Inject
    private PropertyAccess propertyAccess;

    @Property
    private String sampleRowCode;

    @InjectComponent
    private FeedBack filterFeedback;

    void setupRender() throws SuiviObsmerException {
        sampleRow = null;
        getSampleRow();
        professionSelectModel = null;
        getProfessionSelectModel();
        fishingZoneSelectModel = null;
        getFishingZoneSelectModel();
        sampleRowSelectModel = null;
        getSampleRowSelectModel();

        // Suppress persistant boat informations for selected boat
        //boatInfos = null;
        companyBoatInfos = null;
        boatSelectedImmatriculation = null;
        if (isSampleRowExists()) {
            filtersHidden = false;
            boats = null;
            filterFeedback.addInfo("Vous êtes en cours de sélection d'un navire pour la ligne du plan " + sampleRow.getCode());
            professionId = getSampleRow().getProfession().getTopiaId();
            fishingZoneId = getSampleRow().getFirstFishingZone().getTopiaId();
            getBoatFilter().setSampleRowCode(getSampleRow().getCode());
        }
    }

    void onActivate(EventContext ec) {
        if (ec.getCount() > 0) {
            sampleRowCode = ec.get(String.class, 0);
        }
    }

    String onPassivate() {
        return sampleRowCode;
    }

    /**************************** Import Forms ********************************/

    /**
     * Fichier CSV contenant une liste de navires.
     */
    @Property
    private UploadedFile boatsCsvFile;

    @InjectComponent
    private Form importBoatsForm;

    /**
     * Récupération des exceptions du champs d'upload de fichier.
     */
    /*Object onUploadException(FileUploadException ex) {
        createListForm.recordError("Upload exception: " + ex.getMessage());
        return this;
    }*/

    @Log
    void onSuccessFromImportBoatsForm() {
        //importBoatsForm.clearErrors();
        try {
            int[] result = serviceBoat.importBoatCsv(boatsCsvFile.getStream());
            // Suppress persitant list of boats
            boats = null;
            layout.getFeedBack().addInfo(result[0] + " navires importés dont " + result[1] + " nouveaux");
        } catch (SuiviObsmerException eee) {
            layout.getFeedBack().addError(eee.getMessage());
        }
        //return importBoatsForm.getHasErrors() ? importBoatsForm : this;
    }

    @Property
    private UploadedFile activityCalendarsCsvFile;

    private InputStream activityCalendarLogFile;

    protected static String GZIP_MIMETYPE = "application/x-gzip";

    InputStream getActivityCalendarLogFile() throws FileNotFoundException {
        if (activityCalendarLogFile == null) {
            if (log.isInfoEnabled()) {
                log.info("BUSINESS REQUEST [getActivityCalendarLogFile]");
            }
            activityCalendarLogFile = serviceBoat.getActivityCalendarLogFile();
        }
        return activityCalendarLogFile;
    }

    public boolean isLogFileExists() {
        try {
            getActivityCalendarLogFile();
            return true;
        } catch (FileNotFoundException eee) {
            if (log.isInfoEnabled()) {
                log.info("Aucun fichier de log existant pour les calendriers d'activité");
            }
            return false;
        }
    }

    @Log
    void onSuccessFromImportActivityCalendarsForm() throws SuiviObsmerException, IOException {
        InputStream input = activityCalendarsCsvFile.getStream();
        if (log.isDebugEnabled()) {
            log.debug("Content type : " + activityCalendarsCsvFile.getContentType());
        }
        if (activityCalendarsCsvFile.getContentType().equals(GZIP_MIMETYPE)) {
            if (log.isDebugEnabled()) {
                log.debug("Gzip file");
            }
            input = new GZIPInputStream(input);
        }
        serviceBoat.importActivityCalendarCsv(input);
        companyBoatInfos = null;
    }
    
    public StreamResponse onActionFromShowActivityCalendarLogFile() {
        return new StreamResponse() {

            @Override
            public String getContentType() {
                return "text/plain;charset=utf-8";
            }

            @Override
            public InputStream getStream() throws IOException {
                return getActivityCalendarLogFile();
            }

            @Override
            public void prepareResponse(Response response) {
            }
        };
    }

    /**************************** Filters Form *****************************************/

    @Persist
    private BoatFilter boatFilter;

    @Persist
    private SampleRow sampleRow;

    @Persist
    private GenericSelectModel<SampleRow> sampleRowSelectModel;

    @Persist
    private GenericSelectModel<Profession> professionSelectModel;

    @Property
    private String professionId;

    @Persist
    private GenericSelectModel<FishingZone> fishingZoneSelectModel;

    @Property
    private String fishingZoneId;

    @Persist
    private boolean filtersHidden;

    @InjectComponent
    private Zone filtersZone;

    public BoatFilter getBoatFilter() throws SuiviObsmerException {
        if (boatFilter == null) {
            boatFilter = new BoatFilterImpl();
            if (log.isDebugEnabled()) {
                log.debug("new BoatFilter");
            }
            if (!user.getAdmin()) {
                if (log.isDebugEnabled()) {
                    log.debug("set company for boatFilter");
                }
                boatFilter.setCompany(user.getCompany());
            }
        }
        return boatFilter;
    }

    public SampleRow getSampleRow() throws SuiviObsmerException {
        if (sampleRow == null && !StringUtils.isEmpty(sampleRowCode)) {
            if (log.isInfoEnabled()) {
                log.info("BUSINESS REQUEST [getSampleRow]");
            }
            sampleRow = serviceSampling.getSampleRow(sampleRowCode);
        }
        return sampleRow;
    }

    public boolean isSampleRowExists() throws SuiviObsmerException {
        return getSampleRow() != null;
    }

    public GenericSelectModel<SampleRow> getSampleRowSelectModel() throws SuiviObsmerException {
        if (sampleRowSelectModel == null) {
            if (log.isInfoEnabled()) {
                log.info("BUSINESS REQUEST [getSampleRowsForUser]");
            }
            // FIXME-FD20100118 Refactor filter system using AbstractFilteredPage
            SamplingFilter filter = new SamplingFilterImpl();
            // Used to test if the rows are finished with a gap of 1 month (today - 1 month)
            filter.setNbMonthFinishedFromToday(-1);
            if (!user.getAdmin()) {
                filter.setCompany(user.getCompany());
            }
            List<SampleRow> sampleRows = serviceSampling.getSampleRowsByFilter(filter);
            sampleRowSelectModel = new GenericSelectModel<SampleRow>(sampleRows, SampleRow.class,
                "code", "code", propertyAccess);
        }
        return sampleRowSelectModel;
    }

    public GenericSelectModel<Profession> getProfessionSelectModel() throws SuiviObsmerException {
        if (professionSelectModel == null) {           
            if (log.isInfoEnabled()) {
                log.info("BUSINESS REQUEST [getProfessions]");
            }
            List<Profession> professions = serviceReferential.getProfessions();
            professionSelectModel = new GenericSelectModel<Profession>(professions, Profession.class,
                "code", "topiaId", propertyAccess);
        }
        return professionSelectModel;
    }

    public GenericSelectModel<FishingZone> getFishingZoneSelectModel() throws SuiviObsmerException {
        if (fishingZoneSelectModel == null) {
            if (log.isInfoEnabled()) {
                log.info("BUSINESS REQUEST [getFishingZones]");
            }
            List<FishingZone> fishingZones = null;
            if (isSampleRowExists()) {
                fishingZones = getSampleRow().getFishingZone();
            } else {
                fishingZones = serviceReferential.getFishingZones();
            }
            fishingZoneSelectModel = new GenericSelectModel<FishingZone>(fishingZones, FishingZone.class,
                "code", "topiaId", propertyAccess);
        }
        return fishingZoneSelectModel;
    }

    public boolean isFiltersHidden() {
        return filtersHidden;
    }

    public String getHiddenClass() {
        return isFiltersHidden() ? "hidden" : "";
    }

    Block onActionFromShowFilters() {
        filtersHidden = false;
        return filtersZone.getBody();
    }

    Block onActionFromHideFilters() {
        filtersHidden = true;
        return filtersZone.getBody();
    }
    
    void onSelectedFromReset() {
         // Suppress persistant boat filter
        boatFilter = null;
        sampleRowCode = null;
    }

    void onSelectedFromSearch() throws SuiviObsmerException {
        if (log.isDebugEnabled()) {
            //log.debug("SUBMIT : facadeChange=" + facadeChangeSelected);
            log.debug("FILTER : fishingZone=" + boatFilter.getFishingZone());
            log.debug("FILTER : sampleRowCode=" + boatFilter.getSampleRowCode());
            log.debug("FILTER : profession=" + boatFilter.getProfession());
            log.debug("FILTER : boatName=" + boatFilter.getBoatName());
            log.debug("FILTER : boatImmatriculation=" + boatFilter.getBoatImmatriculation());
            log.debug("FILTER : boatDistrictCode=" + boatFilter.getBoatDistrictCode());
            log.debug("FILTER : company=" + boatFilter.getCompany());
        }
        Profession profession = getProfessionSelectModel().findObject(professionId);
        FishingZone fishingZone = getFishingZoneSelectModel().findObject(fishingZoneId);
        boatFilter.setProfession(profession);
        boatFilter.setFishingZone(fishingZone);
    }

    void onSuccessFromFiltersForm() throws SuiviObsmerException {
        // Suppress persistant boats list to get new one with filter
        boats = null;
        // Suppress persistant immatriculation for boat selected
        boatSelectedImmatriculation = null;
        // Suppress persistant boat informations for boat selected
        //boatInfos = null;
        companyBoatInfos = null;
    }

    /**************************** Boats List *****************************************/
    
    @Persist
//    private Map<Integer, Boat> boats;
    private BoatDataSource boats;

    @Property
    @Persist
    private Integer boatSelectedImmatriculation;

    @Property
    private Boat boat;

    private boolean even = true;

    @InjectComponent
    private Zone boatsZone;

    public BoatDataSource getBoats() throws SuiviObsmerException {
        if (boats == null) {
            boats = new BoatDataSource(getBoatFilter(), serviceBoat);
        }
        return boats;
    }

//    public Map<Integer, Boat> getBoats() throws SuiviObsmerException {
//        if (boats == null) {
//            if (log.isInfoEnabled()) {
//                log.info("BUSINESS REQUEST [getBoatsByFilter]");
//            }
//            boats = serviceBoat.getBoatsByFilter(boatFilter);
//        }
//        return boats;
//    }
    
    public String getRowClass() {
        String result = "";
        even = !even;        
        if (boatSelectedImmatriculation != null &&
                boat.getImmatriculation() == boatSelectedImmatriculation) {
            result = "selected";
        } else if (!boat.getActive()) {
            result = "refused";
        } else {
            result = even ? "even" : "odd";
        }
        return result;
    }

    public DateFormat getDateFormat() {
        return new SimpleDateFormat("dd/MM/yyyy");
    }
    
    public boolean canCreateNewContactFromList() throws SuiviObsmerException {
        if (!user.getAdmin() && isSampleRowExists()) {
//            if (getSampleRow().isFinished()) {
//                return false;
//            }
            return boat.canCreateContact(user.getCompany());
        }
        return false;
    }

    Block onActionFromShowBoatInfos(Integer boatImma) {
        boatSelectedImmatriculation = boatImma;
        // Suppress persistant boat informations
        //boatInfos = null;
        companyBoatInfos = null;
        //companyId = null;

        // Initialize from Date for boarding calcul in BoatInfos
        Calendar calendar = new GregorianCalendar();
        calendar.add(Calendar.MONTH, -12);
        boardingFromDate = calendar.getTime();
        
        return boatsZone.getBody();
    }

    /**************************** Boat selected Infos *************************/

    @Persist
    private CompanyBoatInfos companyBoatInfos;

    @InjectComponent
    private Zone boatInfosZone;

    @Inject
    private Block displayBoatInfos;

    @Inject
    private Block editBoatInfos;

    @Property
    private ElligibleBoat elligibleBoat;

    @Property
    private String boatInfosSampleRowCode;

    private boolean boatInfosEditable;

    @Inject
    private ServiceUser serviceUser;

    private GenericSelectModel<Company> companySelectModel;

    @Property
    private String companyId;

    @Property
    private Date boardingFromDate;

    /*@Persist
    private SuiviObsmerPropertyChangeListener propertyChange;*/

    /** /////////////////////// GLOBAL TO THE BLOCK /////////////////////// **/

    public boolean isActivityCalendarImportRun() {
        return SuiviObsmerContext.isActivityCalendarImportRun();
    }

    public boolean canShowActiveBoatInfos() {
        return (user.getAdmin() && companyId != null) || !user.getAdmin();
    }

    public Block getActiveBoatInfosBlock() {
        if (boatInfosEditable) {
            return editBoatInfos;
        }
        return displayBoatInfos;
    }

    public Company getCompany() throws SuiviObsmerException {
        if (user.getAdmin() && companyId != null) {
            return getCompanySelectModel().findObject(companyId);
        }
        return user.getCompany();
    }

    public GenericSelectModel<Company> getCompanySelectModel() throws SuiviObsmerException {
        if (companySelectModel == null) {
            if (log.isDebugEnabled()) {
                log.debug("BUSINESS REQUEST [getCompanies]");
            }
            List<Company> companies = serviceUser.getCompanies(true);
            companySelectModel = new GenericSelectModel<Company>(companies,Company.class,
                    "name","topiaId",propertyAccess);
        }
        return companySelectModel;
    }

    public CompanyBoatInfos getCompanyBoatInfos() throws SuiviObsmerException {
        if (companyBoatInfos == null && boatSelectedImmatriculation != null) {
            if (log.isInfoEnabled()) {
                log.info("BUSINESS REQUEST [getElligibleBoats]");
            }
            companyBoatInfos =
                    serviceBoat.getCompanyBoatInfos(boatSelectedImmatriculation, getCompany());
        }
        return companyBoatInfos;
    }

    public String getBoatName() throws SuiviObsmerException {
        Boat boat = null;
        if (getBoatInfos() != null) {
            boat = getBoatInfos().getBoat();
        }
        boat = getBoats().get(boatSelectedImmatriculation);
        return boat.getName();
    }

    public BoatInfos getBoatInfos() throws SuiviObsmerException {
        return getCompanyBoatInfos().getBoatInfos();
    }

    public String getlastContactClass() throws SuiviObsmerException {
        Contact contact = getCompanyBoatInfos().getLastContact();
        return BusinessUtils.getCSSColorClassForContact(contact, user.getAdmin());
    }

    /** /////////////////////// FOR EACH ELLIGIBLEBOAT ROW ///////////////// **/

    public String getElligibleRowInfos() {
        return BusinessUtils.getTooltipSampleRow(elligibleBoat.getSampleRow());
    }

    public boolean isElligibleBoatCompanyActiveFalse() {
        return BooleanUtils.isFalse(elligibleBoat.getCompanyActive());
    }

    public boolean canCreateNewContactFromElligibleBoat() throws SuiviObsmerException {
        if (!user.getAdmin() && !isElligibleBoatCompanyActiveFalse()) {            
//            SampleRow row = elligibleBoat.getSampleRow();
//            if (row.isFinished()) {
//                return false;
//            }
            Boat boat = getBoatInfos().getBoat();
            return boat.canCreateContact(user.getCompany());
        }
        return false;
    }

    public String getElligibleRowClass() {
        boolean condition1 = elligibleBoat.getCompanyActive() == null && !elligibleBoat.getGlobalActive();

        return condition1 || isElligibleBoatCompanyActiveFalse() ? "line-through" : "";
    }

    /** /////////////////////// ACTIONS //////////////////////////////////// **/

    Block onSuccessFromCompanySelectForm() throws SuiviObsmerException {
        companyBoatInfos = null;
         // boatSelectedImmatriculation is getting from Persist("flash")
        getCompanyBoatInfos();   
        return boatInfosZone.getBody();
    }

    Block onActionFromEditBoatInfos() {
        boatInfosEditable = true;
        return boatInfosZone.getBody();
    }

    Block onActionFromCancelEditBoatInfos() throws SuiviObsmerException {
        /*if (propertyChange.isChanged()) {
            if (log.isDebugEnabled()) {
                log.debug("Change property");
            }
        }*/
        
        // Set boatSelectedImmatriculation for boatInfos to reinitialize it (next getBoatInfos() call)
        //boatSelectedImmatriculation = getBoatInfos().getBoat().getImmatriculation();
        // Suppress boatInfos to get the one from serviceBoat (not updated yet)
        companyBoatInfos = null;
        return boatInfosZone.getBody();
    }

    void onSelectedFromAddBoatInfosSampleRow() throws SuiviObsmerException {
        // We stay in edition mode
        boatInfosEditable = true;
        if (!StringUtils.isEmpty(boatInfosSampleRowCode)) {
            SampleRow row = getSampleRowSelectModel().findObject(boatInfosSampleRowCode);
            companyBoatInfos.setNewElligibleBoat(row);
        }
    }

    void onSelectedFromRemoveBoatInfosSampleRow(String sampleRowCode) throws SuiviObsmerException {
        boatInfosEditable = true;
        companyBoatInfos.removeElligibleBoat(sampleRowCode);
    }

    void onSelectedFromActiveBoatInfosSampleRow(String sampleRowCode) throws SuiviObsmerException {
        boatInfosEditable = true;
        companyBoatInfos.activeElligibleBoat(sampleRowCode);
    }

    Block onSuccessFromBoatInfosForm() throws SuiviObsmerException {
        if (!boatInfosEditable) {
            // Save data
            serviceBoat.createUpdateCompanyBoatInfos(companyBoatInfos);
        }
        return boatInfosZone.getBody();
    }

    Block onSuccessFromCalculateBoardings() throws SuiviObsmerException {
        // Reinitialiaze companyId for select (admin only)
        if (user.getAdmin()) {
            companyId = getCompanyBoatInfos().getCompany().getTopiaId();
        }
        return boatInfosZone.getBody();
    }

    /**************************** Create new contact **************************/

    @InjectPage
    private Contacts contacts;

    Object onActionFromAddNewContactFromBoat(int boatImmatriculation) throws SuiviObsmerException {
        // Get selected sampleRow
        sampleRow = getSampleRow();
        // Get boat from list
        boat = getBoats().get(boatImmatriculation);
        contacts.createNewContact(boat, sampleRow);
        return contacts;
    }

    Object onActionFromAddNewContactFromSampleRow(String sampleRowCode) throws SuiviObsmerException {
        // Get selected boat from BoatInfos
        boat = getBoatInfos().getBoat();
        // Get sampleRow from elligibleBoat list
        sampleRow = getSampleRowSelectModel().findObject(sampleRowCode);
        contacts.createNewContact(boat, sampleRow);
        return contacts;
    }

    /**************************** Go to last ActivityCalendar *****************/

    @InjectPage
    private BoatActivityCalendar calendarPage;

    public boolean hasActivityCalendar() throws SuiviObsmerException {
        boat = getBoatInfos().getBoat();
        return boat.sizeActivityCalendar() != 0;
    }

    Object onActionFromShowLastActivityCalendar() throws SuiviObsmerException {
        boat = getBoatInfos().getBoat();
        calendarPage.setBoat(boat);
        return calendarPage;
    }
}
