/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.dbeditor;

import com.opensymphony.xwork2.interceptor.annotations.InputConfig;
import fr.ifremer.echobase.entities.EchoBaseUserEntityEnum;
import fr.ifremer.echobase.services.service.importdb.ImportService;
import fr.ifremer.echobase.ui.actions.dbeditor.AbstractLoadPage;
import java.io.File;
import javax.inject.Inject;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topia.service.csv.in.CsvImportResult;

public class ImportTable
extends AbstractLoadPage {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ImportTable.class);
    protected File importFile;
    protected boolean createIfNotFound = true;
    protected String importFileContentType;
    protected String importFileFileName;
    private CsvImportResult<EchoBaseUserEntityEnum> result;
    private Exception error;
    @Inject
    protected transient ImportService importService;

    public CsvImportResult<EchoBaseUserEntityEnum> getResult() {
        return this.result;
    }

    public File getImportFile() {
        return this.importFile;
    }

    public void setImportFile(File importFile) {
        this.importFile = importFile;
    }

    public String getImportFileContentType() {
        return this.importFileContentType;
    }

    public void setImportFileContentType(String importFileContentType) {
        this.importFileContentType = importFileContentType;
    }

    public String getImportFileFileName() {
        return this.importFileFileName;
    }

    public void setImportFileFileName(String importFileFileName) {
        this.importFileFileName = importFileFileName;
    }

    public boolean isCreateIfNotFound() {
        return this.createIfNotFound;
    }

    public void setCreateIfNotFound(boolean createIfNotFound) {
        this.createIfNotFound = createIfNotFound;
    }

    public Exception getError() {
        return this.error;
    }

    public String getErrorStack() {
        String errorStack = null;
        if (this.error != null) {
            errorStack = ExceptionUtils.getStackTrace((Throwable)this.error);
        }
        return errorStack;
    }

    public String input() throws Exception {
        this.load();
        return "input";
    }

    @InputConfig(methodName="input")
    public String execute() throws Exception {
        block2: {
            try {
                this.result = this.importService.importDatas(this.getEntityType(), this.importFileFileName, this.importFile, this.createIfNotFound, this.getEchoBaseSession().getUser());
            }
            catch (Exception eee) {
                this.result = CsvImportResult.newResult((TopiaEntityEnum)this.entityType, (String)this.importFileFileName, (boolean)false);
                this.error = eee;
                this.addFlashError(this.t("echobase.info.import.failed", new Object[0]));
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)"Error while import ", (Throwable)eee);
            }
        }
        return "success";
    }
}

