/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.interceptors;

import com.google.common.base.Preconditions;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import fr.ifremer.echobase.entities.EchoBaseUser;
import fr.ifremer.echobase.ui.EchoBaseSession;
import fr.ifremer.echobase.ui.interceptors.AbstractCheckInterceptor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CheckUserIsAdmin
extends AbstractCheckInterceptor {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(CheckUserIsAdmin.class);

    protected boolean doCheck(ActionInvocation invocation) {
        EchoBaseSession echoBaseSession = EchoBaseSession.getEchoBaseSession((ActionContext)invocation.getInvocationContext());
        EchoBaseUser user = echoBaseSession.getUser();
        Preconditions.checkNotNull((Object)user, (Object)"No user found is session");
        boolean admin = user.isAdmin();
        if (!admin && log.isDebugEnabled()) {
            log.debug((Object)"User is not admin, will redirect to home");
        }
        return admin;
    }
}

