/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.jgitflow.helper;

import com.atlassian.maven.plugins.jgitflow.VersionState;
import com.atlassian.maven.plugins.jgitflow.exception.MavenJGitFlowException;
import com.atlassian.maven.plugins.jgitflow.helper.BranchHelper;
import com.atlassian.maven.plugins.jgitflow.helper.ProjectHelper;
import com.atlassian.maven.plugins.jgitflow.provider.ProjectCacheKey;
import com.atlassian.maven.plugins.jgitflow.provider.VersionProvider;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.maven.shared.release.util.ReleaseUtil;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Repository;

@Component(role=ProjectHelper.class)
public class DefaultProjectHelper
extends AbstractLogEnabled
implements ProjectHelper {
    private static String OS = System.getProperty("os.name").toLowerCase();
    private static boolean isWindows = OS.indexOf("win") >= 0;
    @Requirement
    private ArtifactFactory artifactFactory;
    @Requirement
    private VersionProvider versionProvider;
    @Requirement
    private BranchHelper branchHelper;

    @Override
    public void commitAllChanges(Git git, String message) throws MavenJGitFlowException {
        try {
            Status status = git.status().call();
            if (!status.isClean()) {
                git.add().addFilepattern(".").call();
                git.commit().setMessage(message).call();
            }
        }
        catch (GitAPIException e) {
            throw new MavenJGitFlowException("error committing changes: " + e.getMessage(), e);
        }
    }

    @Override
    public void commitAllPoms(Git git, List<MavenProject> reactorProjects, String message) throws MavenJGitFlowException {
        String fullBranchName = this.branchHelper.getCurrentBranchName();
        try {
            File canonicalRepoDir;
            Status status = git.status().call();
            Repository repository = git.getRepository();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("(" + fullBranchName + ") committing all poms on branch '" + repository.getBranch() + "'");
            }
            File repoDir = repository.getDirectory().getParentFile();
            try {
                canonicalRepoDir = repoDir.getCanonicalFile();
            }
            catch (IOException e) {
                throw new MavenJGitFlowException("Cannot get canonical name for repository directory <" + repoDir + ">", e);
            }
            if (!status.isClean()) {
                AddCommand add = git.add();
                MavenProject rootProject = ReleaseUtil.getRootProject(reactorProjects);
                for (MavenProject project : reactorProjects) {
                    String pomPath = this.relativePath(canonicalRepoDir, project.getFile());
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("(" + fullBranchName + ") adding file pattern for poms commit: " + pomPath);
                    }
                    if (isWindows) {
                        pomPath = StringUtils.replace((String)pomPath, (String)"\\", (String)"/");
                    }
                    add.addFilepattern(pomPath);
                }
                add.call();
                git.commit().setMessage(message).call();
            }
        }
        catch (GitAPIException e) {
            throw new MavenJGitFlowException("error committing pom changes: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new MavenJGitFlowException("error committing pom changes: " + e.getMessage(), e);
        }
    }

    private String relativePath(File canonicalBasedir, File file) throws MavenJGitFlowException {
        String pomPath;
        String basePath = canonicalBasedir.getPath();
        try {
            pomPath = file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new MavenJGitFlowException("Cannot get canonical name for pom file <" + file + ">", e);
        }
        int basePathLen = basePath.length();
        if (pomPath.regionMatches(true, 0, basePath, 0, basePathLen) && (pomPath = pomPath.substring(basePathLen)).startsWith(File.separator)) {
            pomPath = pomPath.substring(1);
        }
        return pomPath;
    }

    @Override
    public void checkPomForVersionState(VersionState state, List<MavenProject> reactorProjects) throws MavenJGitFlowException {
        String fullBranchName = this.branchHelper.getCurrentBranchName();
        this.getLogger().info("(" + fullBranchName + ") Checking for " + state.name() + " version in projects...");
        boolean hasSnapshotProject = false;
        for (MavenProject project : reactorProjects) {
            if (!ArtifactUtils.isSnapshot((String)project.getVersion())) continue;
            hasSnapshotProject = true;
            break;
        }
        if (!this.isStateValid(state, hasSnapshotProject)) {
            String message = VersionState.SNAPSHOT.equals((Object)state) ? "Unable to find SNAPSHOT version in reactor projects!" : "Some reactor projects contain SNAPSHOT versions!";
            throw new MavenJGitFlowException(message);
        }
    }

    private boolean isStateValid(VersionState state, boolean hasSnapshot) {
        return VersionState.SNAPSHOT.equals((Object)state) && hasSnapshot || VersionState.RELEASE.equals((Object)state) && !hasSnapshot;
    }

    @Override
    public List<String> checkForNonReactorSnapshots(ProjectCacheKey cacheKey, List<MavenProject> reactorProjects) throws MavenJGitFlowException {
        ArrayList snapshots = Lists.newArrayList();
        String fullBranchName = this.branchHelper.getCurrentBranchName();
        this.getLogger().info("(" + fullBranchName + ") Checking dependencies and plugins for snapshots ...");
        Map<String, String> originalReactorVersions = this.versionProvider.getOriginalVersions(cacheKey, reactorProjects);
        for (MavenProject project : reactorProjects) {
            snapshots.addAll(this.checkProjectForNonReactorSnapshots(project, originalReactorVersions));
        }
        return snapshots;
    }

    private List<String> checkProjectForNonReactorSnapshots(MavenProject project, Map<String, String> originalReactorVersions) throws MavenJGitFlowException {
        List mgntDependencies;
        String parentSnap;
        ArrayList snapshots = Lists.newArrayList();
        Map artifactMap = ArtifactUtils.artifactMapByVersionlessId((Collection)project.getArtifacts());
        if (project.getParentArtifact() != null && !Strings.isNullOrEmpty((String)(parentSnap = this.checkArtifact(this.getArtifactFromMap(project.getParentArtifact(), artifactMap), originalReactorVersions, "parent")))) {
            snapshots.add(parentSnap);
        }
        try {
            Set dependencyArtifacts = project.createArtifacts(this.artifactFactory, null, null);
            snapshots.addAll(this.checkArtifacts(dependencyArtifacts, originalReactorVersions, "dependency"));
        }
        catch (InvalidDependencyVersionException e) {
            throw new MavenJGitFlowException("Failed to create dependency artifacts", e);
        }
        DependencyManagement dmgnt = project.getDependencyManagement();
        if (null != dmgnt && null != (mgntDependencies = dmgnt.getDependencies())) {
            for (Dependency dep : mgntDependencies) {
                String depSnap = this.checkArtifact(dep.getGroupId(), dep.getArtifactId(), dep.getVersion(), originalReactorVersions, "dependency management");
                if (Strings.isNullOrEmpty((String)depSnap)) continue;
                snapshots.add(depSnap);
            }
        }
        Set pluginArtifacts = project.getPluginArtifacts();
        snapshots.addAll(this.checkArtifacts(pluginArtifacts, originalReactorVersions, "plugin"));
        PluginManagement pmgnt = project.getPluginManagement();
        if (null != pmgnt) {
            List mgntPlugins = pmgnt.getPlugins();
            for (Plugin plugin : mgntPlugins) {
                String pluginSnap = this.checkArtifact(plugin.getGroupId(), plugin.getArtifactId(), plugin.getVersion(), originalReactorVersions, "plugin management");
                if (Strings.isNullOrEmpty((String)pluginSnap)) continue;
                snapshots.add(pluginSnap);
            }
        }
        Set reportArtifacts = project.getReportArtifacts();
        snapshots.addAll(this.checkArtifacts(reportArtifacts, originalReactorVersions, "report"));
        Set extensionArtifacts = project.getExtensionArtifacts();
        snapshots.addAll(this.checkArtifacts(extensionArtifacts, originalReactorVersions, "extensions"));
        return snapshots;
    }

    private List<String> checkArtifacts(Set<Artifact> artifacts, Map<String, String> originalReactorVersions, String type) {
        ArrayList snapshots = Lists.newArrayList();
        for (Artifact artifact : artifacts) {
            String snap = this.checkArtifact(artifact, originalReactorVersions, type);
            if (Strings.isNullOrEmpty((String)snap)) continue;
            snapshots.add(snap);
        }
        return snapshots;
    }

    private String checkArtifact(Artifact artifact, Map<String, String> originalReactorVersions, String type) {
        boolean isSnapshot;
        String versionlessArtifactKey = ArtifactUtils.versionlessKey((String)artifact.getGroupId(), (String)artifact.getArtifactId());
        boolean bl = isSnapshot = artifact.isSnapshot() && !artifact.getBaseVersion().equals(originalReactorVersions.get(versionlessArtifactKey));
        if (isSnapshot) {
            return type + " - " + versionlessArtifactKey;
        }
        return null;
    }

    private String checkArtifact(String groupId, String artifactId, String version, Map<String, String> originalReactorVersions, String type) {
        boolean isSnapshot;
        String versionlessArtifactKey = ArtifactUtils.versionlessKey((String)groupId, (String)artifactId);
        boolean bl = isSnapshot = ArtifactUtils.isSnapshot((String)version) && !version.equals(originalReactorVersions.get(versionlessArtifactKey));
        if (isSnapshot) {
            return type + " - " + versionlessArtifactKey;
        }
        return null;
    }

    private Artifact getArtifactFromMap(Artifact originalArtifact, Map<String, Artifact> artifactMap) {
        String versionlessId = ArtifactUtils.versionlessKey((Artifact)originalArtifact);
        Artifact checkArtifact = artifactMap.get(versionlessId);
        if (checkArtifact == null) {
            checkArtifact = originalArtifact;
        }
        return checkArtifact;
    }
}

