/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jgitflow.core.command;

import com.atlassian.jgitflow.core.GitFlowConfiguration;
import com.atlassian.jgitflow.core.JGitFlowConstants;
import com.atlassian.jgitflow.core.command.AbstractGitFlowCommand;
import com.atlassian.jgitflow.core.exception.JGitFlowExtensionException;
import com.atlassian.jgitflow.core.exception.JGitFlowGitAPIException;
import com.atlassian.jgitflow.core.exception.JGitFlowIOException;
import com.atlassian.jgitflow.core.exception.LocalBranchMissingException;
import com.atlassian.jgitflow.core.extension.BranchMergingExtension;
import com.atlassian.jgitflow.core.extension.impl.MergeProcessExtensionWrapper;
import com.atlassian.jgitflow.core.util.GitHelper;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.MergeCommand;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.transport.RefSpec;

public abstract class AbstractBranchMergingCommand<C, T>
extends AbstractGitFlowCommand<C, T> {
    private boolean keepBranch;
    private boolean forceDeleteBranch = true;
    private String message;

    protected AbstractBranchMergingCommand(String branchName, Git git, GitFlowConfiguration gfConfig) {
        super(branchName, git, gfConfig);
        this.message = "tagging release " + branchName;
    }

    protected MergeResult doMerge(String branchToMerge, String mergeTarget, MergeProcessExtensionWrapper extension) throws LocalBranchMissingException, JGitFlowGitAPIException, JGitFlowIOException, GitAPIException, JGitFlowExtensionException {
        return this.doMerge(branchToMerge, mergeTarget, extension, false);
    }

    protected MergeResult doMerge(String branchToMerge, String mergeTarget, MergeProcessExtensionWrapper extension, boolean squash) throws LocalBranchMissingException, JGitFlowGitAPIException, JGitFlowIOException, GitAPIException, JGitFlowExtensionException {
        return this.doMerge(branchToMerge, mergeTarget, extension, squash, MergeCommand.FastForwardMode.NO_FF);
    }

    protected MergeResult doMerge(String branchToMerge, String mergeTarget, MergeProcessExtensionWrapper extension, boolean squash, MergeCommand.FastForwardMode ffMode) throws LocalBranchMissingException, JGitFlowGitAPIException, JGitFlowIOException, GitAPIException, JGitFlowExtensionException {
        MergeResult mergeResult = this.createEmptyMergeResult();
        this.runExtensionCommands(extension.beforeCheckout());
        this.git.checkout().setName(mergeTarget).call();
        this.runExtensionCommands(extension.afterCheckout());
        if (!GitHelper.isMergedInto(this.git, branchToMerge, mergeTarget)) {
            this.reporter.infoText(this.getCommandName(), "merging '" + branchToMerge + "' into '" + mergeTarget + "'...");
            this.runExtensionCommands(extension.beforeMerge());
            Ref localBranchRef = GitHelper.getLocalBranch(this.git, branchToMerge);
            if (squash) {
                this.reporter.infoText(this.getCommandName(), "squashing merge");
                mergeResult = this.git.merge().setSquash(true).include(localBranchRef).call();
                if (mergeResult.getMergeStatus().isSuccessful()) {
                    this.git.commit().setMessage(this.getScmMessagePrefix() + "squashing '" + branchToMerge + "' into '" + mergeTarget + "'" + this.getScmMessageSuffix()).call();
                }
                this.forceDeleteBranch = true;
            } else {
                mergeResult = this.git.merge().setFastForward(ffMode).include(localBranchRef).call();
                if (mergeResult.getMergeStatus().isSuccessful() && MergeCommand.FastForwardMode.FF.equals((Object)ffMode)) {
                    this.git.commit().setMessage(this.getScmMessagePrefix() + "merging '" + branchToMerge + "' into '" + mergeTarget + "'" + this.getScmMessageSuffix()).call();
                }
            }
            this.runExtensionCommands(extension.afterMerge());
        }
        this.reporter.mergeResult(this.getCommandName(), mergeResult);
        if (!mergeResult.getMergeStatus().isSuccessful()) {
            this.reporter.errorText(this.getCommandName(), "merge into '" + mergeTarget + "' was not successful! Aborting...");
            if (mergeResult.getMergeStatus().equals((Object)MergeResult.MergeStatus.CONFLICTING)) {
                this.reporter.errorText(this.getCommandName(), "please resolve your merge conflicts and re-run " + this.getCommandName());
            } else {
                this.reporter.errorText(this.getCommandName(), "until JGit supports merge resets, please run 'git reset --merge' to get back to a clean state");
            }
        }
        return mergeResult;
    }

    protected void doTag(String branchToTag, String tagMessage, MergeResult resultToLog, BranchMergingExtension extension) throws GitAPIException, JGitFlowGitAPIException, JGitFlowExtensionException {
        this.runExtensionCommands(extension.beforeTag());
        this.git.checkout().setName(branchToTag).call();
        String tagName = this.gfConfig.getPrefixValue(JGitFlowConstants.PREFIXES.VERSIONTAG.configKey()) + this.getBranchName();
        if (!GitHelper.tagExists(this.git, tagName)) {
            this.reporter.infoText(this.getCommandName(), String.format("tagging with name: <%s>. merge status (%s)", tagName, resultToLog.getMergeStatus()));
            this.git.tag().setName(tagName).setMessage(this.getScmMessagePrefix() + tagMessage + this.getScmMessageSuffix()).call();
        }
        this.runExtensionCommands(extension.afterTag());
    }

    protected void cleanupBranchesIfNeeded(String branchToCheckout, String ... branchesToDelete) throws GitAPIException, JGitFlowGitAPIException {
        if (!this.keepBranch) {
            this.git.checkout().setName(branchToCheckout).call();
            for (String branchToDelete : branchesToDelete) {
                if (GitHelper.localBranchExists(this.git, branchToDelete)) {
                    this.reporter.infoText(this.getCommandName(), "deleting local branch: " + branchToDelete);
                    this.git.branchDelete().setForce(this.forceDeleteBranch).setBranchNames(new String[]{branchToDelete}).call();
                }
                if (!this.isPush() || !GitHelper.remoteBranchExists(this.git, branchToDelete)) continue;
                this.reporter.infoText(this.getCommandName(), "pushing deleted branch: :" + branchToDelete);
                RefSpec deleteSpec = new RefSpec().setSource(null).setDestination("refs/heads/" + branchToDelete);
                this.git.push().setRemote("origin").setRefSpecs(new RefSpec[]{deleteSpec}).call();
            }
        }
    }

    protected void checkoutTopicBranch(String branchName, BranchMergingExtension extension) throws GitAPIException, JGitFlowExtensionException {
        this.git.checkout().setName(branchName).call();
        this.runExtensionCommands(extension.afterTopicCheckout());
    }

    protected MergeResult createEmptyMergeResult() {
        return new MergeResult(null, null, new ObjectId[]{null, null}, MergeResult.MergeStatus.ALREADY_UP_TO_DATE, (MergeStrategy)MergeStrategy.RESOLVE, null);
    }

    protected boolean checkMergeResults(MergeResult ... resultsToCheck) {
        boolean isSuccess = true;
        for (MergeResult result : resultsToCheck) {
            if (result.getMergeStatus().isSuccessful()) continue;
            isSuccess = false;
            break;
        }
        return isSuccess;
    }

    public C setKeepBranch(boolean keepBranch) {
        this.keepBranch = keepBranch;
        return (C)this;
    }

    public C setForceDeleteBranch(boolean force) {
        this.forceDeleteBranch = force;
        return (C)this;
    }

    public C setMessage(String message) {
        this.message = message;
        return (C)this;
    }

    public boolean isForceDeleteBranch() {
        return this.forceDeleteBranch;
    }

    public boolean isKeepBranch() {
        return this.keepBranch;
    }

    public String getMessage() {
        return this.message;
    }
}

