/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.sulky.sounds.jlayer;

import de.huxhorn.sulky.sounds.Sounds;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javazoom.jl.decoder.JavaLayerException;
import javazoom.jl.player.Player;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JLayerSounds
implements Sounds {
    private final Logger logger = LoggerFactory.getLogger(JLayerSounds.class);
    private final List<String> playList = new ArrayList<String>();
    private Map<String, String> soundLocations = new HashMap<String, String>();
    private boolean mute;

    public JLayerSounds() {
        Thread t = new Thread((Runnable)new PlayRunnable(), "SoundPlayRunnable");
        t.setDaemon(true);
        t.start();
    }

    public boolean isMute() {
        return this.mute;
    }

    public void setMute(boolean mute) {
        this.mute = mute;
    }

    public Map<String, String> getSoundLocations() {
        return this.soundLocations;
    }

    public void setSoundLocations(Map<String, String> soundLocations) {
        this.soundLocations = soundLocations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void play(String soundName, boolean ignoreDuplicates) {
        if (!this.isMute()) {
            List<String> list = this.playList;
            synchronized (list) {
                if (ignoreDuplicates && this.playList.contains(soundName)) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Ignoring duplicate sound '{}'.", (Object)soundName);
                    }
                    return;
                }
                this.playList.add(soundName);
                this.playList.notifyAll();
            }
        }
    }

    public void play(String soundName) {
        this.play(soundName, true);
    }

    private Player resolvePlayer(String soundName) {
        block18: {
            InputStream soundStream;
            block17: {
                String soundLocation = null;
                if (this.soundLocations != null) {
                    soundLocation = this.soundLocations.get(soundName);
                }
                if (soundLocation == null) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("No soundlocation defined for sound {}.", (Object)soundName);
                    }
                    return null;
                }
                soundStream = JLayerSounds.class.getResourceAsStream(soundLocation);
                if (soundStream == null) {
                    block16: {
                        File file;
                        if (this.logger.isInfoEnabled()) {
                            this.logger.info("Couldn't retrieve {} as a resource...", (Object)soundLocation);
                        }
                        if ((file = new File(soundLocation)).isFile()) {
                            try {
                                soundStream = new FileInputStream(file);
                            }
                            catch (FileNotFoundException e) {
                                if (!this.logger.isInfoEnabled()) break block16;
                                this.logger.info("Couldn't open {} as a file.", (Object)soundLocation);
                            }
                        }
                    }
                    if (soundStream == null) {
                        try {
                            URL url = new URL(soundLocation);
                            soundStream = url.openStream();
                        }
                        catch (MalformedURLException e) {
                            if (this.logger.isInfoEnabled()) {
                                this.logger.info("Couldn't open {} as a URL.", (Object)soundLocation);
                            }
                        }
                        catch (IOException e) {
                            if (!this.logger.isInfoEnabled()) break block17;
                            this.logger.info("Couldn't open {} as a URL.", (Object)soundLocation);
                        }
                    }
                }
            }
            if (soundStream != null) {
                try {
                    return new Player(soundStream);
                }
                catch (JavaLayerException ex) {
                    if (!this.logger.isWarnEnabled()) break block18;
                    this.logger.warn("Exception while creating player for sound '{}'!", (Object)soundName, (Object)ex);
                }
            }
        }
        return null;
    }

    private class PlayRunnable
    implements Runnable {
        private PlayRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                String nextSound;
                List list = JLayerSounds.this.playList;
                synchronized (list) {
                    while (JLayerSounds.this.playList.size() == 0) {
                        try {
                            JLayerSounds.this.playList.wait();
                        }
                        catch (InterruptedException e) {
                            if (JLayerSounds.this.logger.isInfoEnabled()) {
                                JLayerSounds.this.logger.info("Interrupted...");
                            }
                            return;
                        }
                    }
                    nextSound = (String)JLayerSounds.this.playList.get(0);
                }
                if (!JLayerSounds.this.isMute()) {
                    Player player;
                    if (JLayerSounds.this.logger.isInfoEnabled()) {
                        JLayerSounds.this.logger.info("Playing sound {}.", (Object)nextSound);
                    }
                    if ((player = JLayerSounds.this.resolvePlayer(nextSound)) != null) {
                        try {
                            player.play();
                            player.close();
                        }
                        catch (JavaLayerException ex) {
                            if (JLayerSounds.this.logger.isWarnEnabled()) {
                                JLayerSounds.this.logger.warn("Exception while playing sound '{}'!", (Object)nextSound, (Object)ex);
                            }
                        }
                    } else if (JLayerSounds.this.logger.isInfoEnabled()) {
                        JLayerSounds.this.logger.info("Couldn't resolve player for sound '{}'.", (Object)nextSound);
                    }
                }
                list = JLayerSounds.this.playList;
                synchronized (list) {
                    JLayerSounds.this.playList.remove(0);
                }
            }
        }
    }
}

