/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.data.logging.protobuf;

import de.huxhorn.lilith.data.eventsource.EventIdentifier;
import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.data.eventsource.SourceIdentifier;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.lilith.data.logging.protobuf.LoggingEventProtobufEncoder;
import de.huxhorn.lilith.data.logging.protobuf.generated.LoggingProto;
import de.huxhorn.sulky.codec.Encoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingEventWrapperProtobufEncoder
implements Encoder<EventWrapper<LoggingEvent>> {
    private boolean compressing;

    public LoggingEventWrapperProtobufEncoder(boolean compressing) {
        this.compressing = compressing;
    }

    public boolean isCompressing() {
        return this.compressing;
    }

    public void setCompressing(boolean compressing) {
        this.compressing = compressing;
    }

    public byte[] encode(EventWrapper<LoggingEvent> wrapper) {
        LoggingProto.EventWrapper converted = LoggingEventWrapperProtobufEncoder.convert(wrapper);
        if (converted == null) {
            return null;
        }
        if (!this.compressing) {
            return converted.toByteArray();
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gos = new GZIPOutputStream(out);
            converted.writeTo(gos);
            gos.flush();
            gos.close();
            return out.toByteArray();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static LoggingProto.EventWrapper convert(EventWrapper<LoggingEvent> wrapper) {
        LoggingEvent event;
        if (wrapper == null) {
            return null;
        }
        LoggingProto.EventWrapper.Builder builder = LoggingProto.EventWrapper.newBuilder();
        EventIdentifier eventId = wrapper.getEventIdentifier();
        if (eventId != null) {
            builder.setEventIdentifier(LoggingEventWrapperProtobufEncoder.convert(eventId));
        }
        if ((event = (LoggingEvent)wrapper.getEvent()) != null) {
            builder.setEvent(LoggingEventProtobufEncoder.convert(event));
        }
        return builder.build();
    }

    public static LoggingProto.EventIdentifier convert(EventIdentifier eventId) {
        if (eventId == null) {
            return null;
        }
        LoggingProto.EventIdentifier.Builder builder = LoggingProto.EventIdentifier.newBuilder();
        SourceIdentifier sourceId = eventId.getSourceIdentifier();
        if (sourceId != null) {
            builder.setSourceIdentifier(LoggingEventWrapperProtobufEncoder.convert(sourceId));
        }
        builder.setLocalId(eventId.getLocalId());
        return builder.build();
    }

    public static LoggingProto.SourceIdentifier convert(SourceIdentifier sourceId) {
        if (sourceId == null) {
            return null;
        }
        LoggingProto.SourceIdentifier.Builder builder = LoggingProto.SourceIdentifier.newBuilder();
        String identifier = sourceId.getIdentifier();
        if (identifier != null) {
            builder.setIdentifier(identifier);
        }
        if ((identifier = sourceId.getSecondaryIdentifier()) != null) {
            builder.setSecondaryIdentifier(identifier);
        }
        return builder.build();
    }
}

