/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.runtime;

import de.flapdoodle.embed.process.collections.Collections;
import de.flapdoodle.embed.process.config.ISupportConfig;
import de.flapdoodle.embed.process.distribution.Platform;
import de.flapdoodle.embed.process.io.Readers;
import de.flapdoodle.embed.process.runtime.ProcessControl;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class NUMA {
    private static Logger logger = Logger.getLogger(NUMA.class.getName());
    static final Map<Platform, Boolean> NUMA_STATUS_MAP = new HashMap<Platform, Boolean>();

    public static synchronized boolean isNUMA(ISupportConfig support, Platform platform) {
        Boolean ret = NUMA_STATUS_MAP.get((Object)platform);
        if (ret == null) {
            ret = NUMA.isNUMAOnce(support, platform);
            NUMA_STATUS_MAP.put(platform, ret);
        }
        return ret;
    }

    public static boolean isNUMAOnce(ISupportConfig support, Platform platform) {
        if (platform == Platform.Linux) {
            try {
                boolean isNUMA;
                ProcessControl process = ProcessControl.fromCommandLine(support, Collections.newArrayList("grep", "NUMA=y", "/boot/config-`uname -r`"), true);
                Reader reader = process.getReader();
                String content = Readers.readAll(reader);
                process.stop();
                boolean bl = isNUMA = !content.isEmpty();
                if (isNUMA) {
                    logger.warning("-----------------------------------------------\nNUMA support is still alpha. If you have any Problems with it, please contact us.\n-----------------------------------------------");
                }
                return isNUMA;
            }
            catch (IOException ix) {
                ix.printStackTrace();
            }
        }
        return false;
    }
}

