/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jackson.api.impl;

import com.webcohesion.enunciate.api.ApiRegistrationContext;
import com.webcohesion.enunciate.api.Styles;
import com.webcohesion.enunciate.api.datatype.DataTypeReference;
import com.webcohesion.enunciate.api.datatype.Property;
import com.webcohesion.enunciate.facets.Facet;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedElement;
import com.webcohesion.enunciate.javac.decorations.element.ElementUtils;
import com.webcohesion.enunciate.javac.javadoc.JavaDoc;
import com.webcohesion.enunciate.javac.javadoc.JavaDocTagHandler;
import com.webcohesion.enunciate.metadata.ReadOnly;
import com.webcohesion.enunciate.modules.jackson.api.impl.DataTypeReferenceImpl;
import com.webcohesion.enunciate.modules.jackson.model.Member;
import com.webcohesion.enunciate.modules.jackson.model.types.JsonArrayType;
import com.webcohesion.enunciate.util.BeanValidationUtils;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;

public class PropertyImpl
implements Property {
    private final Member member;
    private ApiRegistrationContext registrationContext;
    private final boolean plural;

    public PropertyImpl(Member member, ApiRegistrationContext registrationContext) {
        this(member, registrationContext, false);
    }

    public PropertyImpl(Member member, ApiRegistrationContext registrationContext, boolean plural) {
        this.member = member;
        this.registrationContext = registrationContext;
        this.plural = plural;
    }

    public String getName() {
        return this.member.getName();
    }

    public DataTypeReference getDataType() {
        return new DataTypeReferenceImpl(this.plural ? new JsonArrayType(this.member.getJsonType()) : this.member.getJsonType(), this.registrationContext);
    }

    public String getDescription() {
        JavaDoc javaDoc = this.member.getJavaDoc(this.registrationContext.getTagHandler());
        JavaDoc.JavaDocTagList returns = (JavaDoc.JavaDocTagList)javaDoc.get((Object)"return");
        if (returns != null && !returns.isEmpty() && javaDoc.toString().trim().isEmpty()) {
            return (String)returns.get(0);
        }
        return javaDoc.toString();
    }

    public String getDeprecated() {
        return ElementUtils.findDeprecationMessage((DecoratedElement)this.member, (JavaDocTagHandler)this.registrationContext.getTagHandler());
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        return (A)this.member.getAnnotation(annotationType);
    }

    public Map<String, AnnotationMirror> getAnnotations() {
        return this.member.getAnnotations();
    }

    public Set<Facet> getFacets() {
        return this.member.getFacets();
    }

    public boolean isRequired() {
        return this.member.isRequired();
    }

    public boolean isReadOnly() {
        return this.member.getAnnotation(ReadOnly.class) != null || this.member.getJavaDoc().get((Object)"readonly") != null;
    }

    public String getConstraints() {
        return BeanValidationUtils.describeConstraints((Element)((Object)this.member), (boolean)this.isRequired());
    }

    public String getDefaultValue() {
        return this.member.getDefaultValue();
    }

    public JavaDoc getJavaDoc() {
        return this.member.getJavaDoc(this.registrationContext.getTagHandler());
    }

    public Set<String> getStyles() {
        return Styles.gatherStyles((Element)((Object)this.member), (Map)this.member.getContext().getContext().getConfiguration().getAnnotationStyles());
    }

    public String getSince() {
        JavaDoc.JavaDocTagList sinceTags = (JavaDoc.JavaDocTagList)this.getJavaDoc().get((Object)"since");
        return sinceTags == null ? null : sinceTags.toString();
    }
}

