/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.spring.security;

import com.vaadin.flow.server.HandlerHelper;
import com.vaadin.flow.spring.security.RequestUtil;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.MediaType;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.savedrequest.SavedRequest;
import org.springframework.security.web.servlet.util.matcher.PathPatternRequestMatcher;
import org.springframework.security.web.util.matcher.MediaTypeRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestHeaderRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.stereotype.Component;
import org.springframework.web.accept.ContentNegotiationStrategy;
import org.springframework.web.accept.HeaderContentNegotiationStrategy;

@Component
public class VaadinDefaultRequestCache
implements RequestCache {
    @Autowired
    private RequestUtil requestUtil;
    @Value(value="${server.error.path:/error}")
    private String configuredErrorPath;
    private RequestCache delegateRequestCache = new HttpSessionRequestCache();
    private final RequestMatcher defaultIgnoreRules = VaadinDefaultRequestCache.createDefaultIgnoreRules();
    private RequestMatcher ignoreRequestMatcher = null;

    public void saveRequest(HttpServletRequest request, HttpServletResponse response) {
        if (this.requestUtil.isFrameworkInternalRequest(request)) {
            this.getLogger().debug("Did not save request since it is a Vaadin internal framework request");
            return;
        }
        if (this.requestUtil.isEndpointRequest(request)) {
            this.getLogger().debug("Did not save request since it is a Hilla endpoint request");
            return;
        }
        if (this.isServiceWorkerInitiated(request)) {
            this.getLogger().debug("Did not save request since it is a service worker initiated request");
            return;
        }
        if (this.isErrorRequest(request)) {
            this.getLogger().debug("Did not save request since it is an error page");
            return;
        }
        if (HandlerHelper.isNonHtmlInitiatedRequest((HttpServletRequest)request)) {
            this.getLogger().debug("Did not save request since its initiator is not a web page");
            return;
        }
        if (this.defaultIgnoreRules.matches(request)) {
            this.getLogger().debug("Did not save request since it matched default ignore rules {}", (Object)this.defaultIgnoreRules);
            return;
        }
        if (this.ignoreRequestMatcher != null && this.ignoreRequestMatcher.matches(request)) {
            this.getLogger().debug("Did not save request since it matched custom ignore rules {}", (Object)this.ignoreRequestMatcher);
            return;
        }
        this.getLogger().debug("Saving request to {}", (Object)request.getRequestURI());
        this.delegateRequestCache.saveRequest(request, response);
    }

    private boolean isErrorRequest(HttpServletRequest request) {
        String pathInContext = HandlerHelper.getRequestPathInsideContext((HttpServletRequest)request);
        String errorPath = this.configuredErrorPath;
        if (errorPath.startsWith("/")) {
            errorPath = errorPath.substring(1);
        }
        return errorPath.equals(pathInContext);
    }

    public SavedRequest getRequest(HttpServletRequest request, HttpServletResponse response) {
        return this.delegateRequestCache.getRequest(request, response);
    }

    public HttpServletRequest getMatchingRequest(HttpServletRequest request, HttpServletResponse response) {
        return this.delegateRequestCache.getMatchingRequest(request, response);
    }

    public void removeRequest(HttpServletRequest request, HttpServletResponse response) {
        this.delegateRequestCache.removeRequest(request, response);
    }

    private boolean isServiceWorkerInitiated(HttpServletRequest request) {
        String referer = request.getHeader("Referer");
        return referer != null && referer.endsWith("sw.js");
    }

    public void setDelegateRequestCache(RequestCache delegateRequestCache) {
        this.delegateRequestCache = delegateRequestCache;
    }

    public void ignoreRequests(RequestMatcher requestMatcher) {
        this.ignoreRequestMatcher = requestMatcher;
    }

    private static RequestMatcher createDefaultIgnoreRules() {
        PathPatternRequestMatcher.Builder matcherBuilder = PathPatternRequestMatcher.withDefaults();
        PathPatternRequestMatcher favIcon = matcherBuilder.matcher("/favicon.*");
        PathPatternRequestMatcher wellKnown = matcherBuilder.matcher("/.well-known/**");
        RequestHeaderRequestMatcher xhrRequestedWith = new RequestHeaderRequestMatcher("X-Requested-With", "XMLHttpRequest");
        ArrayList<Object> matchers = new ArrayList<Object>();
        matchers.add(favIcon);
        matchers.add(wellKnown);
        HeaderContentNegotiationStrategy contentNegotiationStrategy = new HeaderContentNegotiationStrategy();
        matchers.add(VaadinDefaultRequestCache.matchingMediaType((ContentNegotiationStrategy)contentNegotiationStrategy, MediaType.APPLICATION_JSON));
        matchers.add(xhrRequestedWith);
        matchers.add(VaadinDefaultRequestCache.matchingMediaType((ContentNegotiationStrategy)contentNegotiationStrategy, MediaType.MULTIPART_FORM_DATA));
        matchers.add(VaadinDefaultRequestCache.matchingMediaType((ContentNegotiationStrategy)contentNegotiationStrategy, MediaType.TEXT_EVENT_STREAM));
        return new OrRequestMatcher(matchers);
    }

    private static RequestMatcher matchingMediaType(ContentNegotiationStrategy contentNegotiationStrategy, MediaType mediaType) {
        MediaTypeRequestMatcher mediaRequest = new MediaTypeRequestMatcher(contentNegotiationStrategy, new MediaType[]{mediaType});
        mediaRequest.setIgnoredMediaTypes(Collections.singleton(MediaType.ALL));
        return mediaRequest;
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }
}

